import logging
from typing import Tuple
import omegaconf.dictconfig

logger = logging.getLogger(__name__)


def generate_qualification(config: omegaconf.dictconfig.DictConfig, style: str = 'image') -> Tuple[str,str]:
    questions_xhtml = """
<QuestionForm xmlns='http://mechanicalturk.amazonaws.com/AWSMechanicalTurkDataSchemas/2005-10-01/QuestionForm.xsd'>
    <Overview>
        {overview}
    </Overview>
    {all_questions} 
</QuestionForm>
"""
    answers_xhtml = """
<AnswerKey xmlns="http://mechanicalturk.amazonaws.com/AWSMechanicalTurkDataSchemas/2005-10-01/AnswerKey.xsd">
    {all_answers}
</AnswerKey>
"""
    question_answers = [
        ["A telephone is used for communication. When is this possible?",
         "It is connected to network", "Telephone is connected to network",
         "Avoid pronouns for referring to objects", [0, 1]],
        ["A telephone is used for communication. When is this impossible?",
         "Telephone is unplugged", "Telephone is not plugged in",
         "Avoid using negative sentences", [1, 0]],
        ["A telephone is used for communication. When is this impossible?",
         "The city power is down", "Telephone is unplugged",
         "Do not overthink", [0, 1]],
        ["A telephone is used for communication. When is this impossible?",
         "There is a power outage", "Telephone is detached from electric source",
         "Be specific", [0, 1]],
        ["A telephone is used for communication. When is this impossible?",
         "Telephone is broken", "Telephone power/network cord is cut off",
         "Be specific", [0, 1]],
        ["A telephone is used for communication. When is this possible?",
         "You are able to speak", "The person using the phone can speak",
         "use pronouns for people", [1, 0]],
        ["A telephone is used for communication. When is this impossible?",
         "You cannot speak", "You are mute",
         "avoid negatives", [0, 1]],
        ["A telephone is used for communication. When is this possible?",
         "Have connection/network", "The telephone is connected to network",
         "write actual sentences", [0, 1]],
    ]

    if style == 'link':
        overview = """
<FormattedContent><![CDATA[
<strong>Please read the instructions and examples <a href="https://proska.github.io/MCQInstructions.html">here</a> before you begin.</strong>
For each prompt question, select the best response that matches the requirements in the detailed instructions.
]]></FormattedContent>
"""
    else:
        overview = """
<Binary>
  <MimeType>
    <Type>image</Type>
    <SubType>jpg</SubType>
  </MimeType>
  <DataURL>https://proska.github.io/images/MCQinstructions.jpg</DataURL>
  <AltText>Instructions</AltText>
</Binary>
"""

    question_template = """
    <Question>
      <QuestionIdentifier>Q{myid}</QuestionIdentifier>
      <DisplayName>Q{myid}</DisplayName>
      <IsRequired>true</IsRequired>
      <QuestionContent>
        <Text> {prompt} </Text>
      </QuestionContent>
      <AnswerSpecification>
        <SelectionAnswer>
          <StyleSuggestion>radiobutton</StyleSuggestion>
          <Selections>
            <Selection>
              <SelectionIdentifier>Q{myid}_resp1</SelectionIdentifier>
              <Text>{resp1}</Text>
            </Selection>
            <Selection>
              <SelectionIdentifier>Q{myid}_resp2</SelectionIdentifier>
              <Text>{resp2}</Text>
            </Selection>
          </Selections>
        </SelectionAnswer>
      </AnswerSpecification>
    </Question>
"""

    answer_template = """
    <Question>
      <QuestionIdentifier>Q{myid}</QuestionIdentifier>
      <AnswerOption>
        <SelectionIdentifier>Q{myid}_resp1</SelectionIdentifier>
        <AnswerScore>{score1}</AnswerScore>
      </AnswerOption>
      <AnswerOption>
        <SelectionIdentifier>Q{myid}_resp2</SelectionIdentifier>
        <AnswerScore>{score2}</AnswerScore>
      </AnswerOption>
    </Question>
"""
    # add the questions
    all_questions = ""
    all_answers = ""
    for i, (prompt, resp1, resp2, guide, scores) in enumerate(question_answers):
        all_questions += question_template.format(prompt=prompt, resp1=resp1, resp2=resp2, myid=i)

        all_answers += answer_template.format(myid=i, score1=scores[0], score2=scores[1])

    questions = questions_xhtml.format(overview=overview, all_questions=all_questions)
    if config.results.question_path is not None:
        with open(config.results.question_path, "w") as outf:
            outf.write(questions)

    answers = answers_xhtml.format(all_answers=all_answers)
    if config.results.answer_path is not None:
        with open(config.results.answer_path, "w") as outf:
            outf.write(answers)

    return questions, answers


if __name__ == '__main__':

    config = omegaconf.dictconfig.DictConfig({
        'results': {
            'question_path': './QualQuestions.xml',
            'answer_path': './QualAnswers.xml',
        },
    })
    generate_qualification(config)
