import torch
import pandas as pd
from abc import ABC, abstractmethod


class Representer(ABC):
    @abstractmethod
    def get_representations(self, data: pd.DataFrame) -> torch.Tensor:
        """Get representations which will determine the hypothesized labels, e.g. softmax, cosine dist"""
        pass
