import time

PAD_VALUE = -1
JOINT_LABEL_SEP = '/'

OOV_STRING = "<OOV>"

DEFAULT_BUCKET_BOUNDARIES = [20, 30, 50, 80, 100, 120, 150]

VERY_LARGE = 1e9
VERY_SMALL = -1e9
SMOOTHED_VERY_LARGE = 1e3
SMOOTHED_VERY_SMALL = -1e3

# Optimizer hyperparameters
hparams = {
  'learning_rate': 0.04,
  'input_project_layer_norm': False,
  'decay_rate': 1.5,
  'decay_steps': 5000,
  'warmup_steps': 16000,
  'beta1': 0.9,
  'beta2': 0.98,
  'epsilon': 1e-12,
  'use_nesterov': True,
  'batch_size': 5192,
  'attn_debug': False,
  'shuffle_buffer_multiplier': 5,
  'eval_throttle_secs': 1,
  'eval_every_steps': 8001,
  'num_train_epochs': 100000,
  'gradient_clip_norm': 5.0,
  'label_smoothing': 0.1,
  'moving_average_decay': 0.999,
  'average_norms': False,
  'input_dropout': 1.0,
  'bilinear_dropout': 1.0,
  'parser_dropout': 1.0,
  'mlp_dropout': 1.0,
  'attn_dropout': 1.0,
  'ff_dropout': 1.0,
  'prepost_dropout': 1.0,
  'random_seed': int(time.time()),
  'optimizer': 'lazyadam',
  'gamma': 0.0,
  'is_token_based_batching': True,
  'mode': 'train',
  'special_attention_mode': 'my_discounting',
  'cwr': 'None',
  'output_attention_weight': False,
  'parse_gold_headcount': 1,
  'parse_dep_headcount': 1,
  'parse_dep_cwrs_headcount': 1,
  'use_hparams_headcounts': False,
  'parse_gold_injection': 'injection',
  'parse_dep_injection': 'injection',
  'parse_dep_cwrs_injection': 'injection',
  'aggregator_mlp_bn': False,
  'relchain_softmax_smoothing': False,
  'transformation_fn_norm' : 'softmax',
  'using_log_prob': False,
  'use_hparams_aggregation_reduction_mode': False,
  'aggregation_reduction_mode': 'sum',
  'using_input_with_root': False,
  'debug': False,
  'use_labeled_adjacency_mtx_hparams_option': False,
  'head_label_aggregation': 'log_multi',
  'label_score_aggregation': 'logsumexp',
  'use_strength_bias': False,
  'on_value': -1e0,
  'train_with_crf': False,
  'use_hparams_head_dropout_option': False,
  'head_dropout_rate': 1.,
  'use_hparams_head_replacing_option': False,
  'head_dropout': 1.0,
  'use_hparams_label_replacing_option': False,
  'label_dropout': 1.0,
  'use_hparams_on_prob_option': False,
  'on_prob': 99e-2,
  'discounting_aggregation_strategy': 'prob_add_fixed',
  'use_hparams_selective_gating_option': False,
  'selective_gating_mode': 'self-recurrent',
  'use_hparams_prod_mode_option': False,
  'prod_mode': "eye-end_node-noop",
  'label_score_multiplier': 1.,
  'is_ud': False,
  'glove_300d': False,
  'conll05': False,
  'conll09': False,
  'conll12': False,
  'new_masking': False,
  'extreme_value': False,
  'bilstm': False,
  'training_min_steps': 100000,
  'cwr_ood': False,
  'use_hparams_transformation_fn':False,
  'transformation_fn': 'IDK',
  'bicrf': False,
  'dep_prior_trainable': False,
  'layer_norm_to_heads': False,
  'kup1down_up_to': -1,
  'weight_per_label': False,
  'one_up':False,
  'one_down':False,
  'memory_efficient': False,
  'joint_par_srl_training': False,
  'relu_implementation': False,
  'srl_layernorm': False,
  'elevate_underline':False,
  'use_pos_tag': False,
  'exclude_specific_path': False,
  'use_dependency_type_on_bilinear': False,
  'self_recurrent': False,
  'self_recurrent_new': False,
  'additional_self_recurrent': 0,
  'additional_one_up': 0,
  'additional_one_down': 0,
  'pow_norm':False,
  'share_scorer':False,
  'take_gold_by_chance':False,
  'concat_pos_mlp': False,
  'concat_pos_mlp_ng': False,
  'concat_pos_mlp_emb': False,
  'allow_concat_pos_at_normal_scorer': False,
  'kup1down_repeat': 1,
  'apply_weight_to_normal': False,
  'apply_mean_weight': False,
  'double_down': False,
  'double_down_repeat': 1,
  'double_up': False,
  'double_up_repeat': 1,
  'aggregation_weight_one_init': False,
  'double_down_with_preid_patterns':False,
  'pattern_dominant': False,
  'one_down_with_preid_patterns': False,
  'learn_mask_per_srl_label': False,
  'double_down_with_intermediate_nodes': False,
  'one_down_with_intermediate_nodes': False,
  'share_pred_role_mlp': False,
  'one_up_with_intermediate_nodes': False,
  'self_recurrent_new_with_intermediate_nodes': False,
  'xl_scorer': False,
  'remove_global_scorer': False,
  'train_with_gold_first': False,
  'use_lstm': False,
  'add_non_prediction_prior_to_one_down': False,
  'apply_custom_loss_weight': False,
  'sixupkdown_up_to': -1,
  'return_last': False,
  'sixupkdown_starts_from': 0,
  'kuptwodown_up_to': -1,
  'threeupkdown_up_to': -1,
  'new_updown_search': False,
  'train_global_scorer_with_all_data':False,
  'mixture_model':-1,
  'mixture_model_inference_mode': "max",
  'z_entropy_loss': False,
  'gumbel_temperature': 1e-5,
  'cluster_prob': False,
  'downward_propagation_depth': 0,
  'use_lstm_hiddens':False,
  'half_return_size':False,
  'use_pred_role_feature': False,
  'legacy_mode': False,
  'before_after_indicator': False,
  'lstm_counting': False,
  'l1_dense_regularizer': False,
  'wfs_layer_norm': False,
  'stop_parse_gradient': False,
  'srl_score_layer_norm': False,
  'pred_role_share_map': False,
  'boost_non_empty_loss': 1,
  'flooding':False,
  'mixture_model_embedding': 0,
  'num_samples': 3,
  'mixture_model_normal_embedding': 0,
  'use_lexicons': False,
  'cluster_emb_only': False,
  'latent_hidden_size': 64,
  'latent_use_direction': True,
  'bilinear_as_distance': False,
  'normalize_mlp_to_unit': False,
  'latent_use_lr_direction': False,
  'separate_bilinear_cluster': False,
  'latent_use_dep_label': False,
  'lstm_search_up_depth': 5,
  'lstm_search_down_depth': 3,
  'use_gumbel_max_on_input': False,
  'add_exclusion_dist': False,
  'lstm_learn_count': False,
  'use_trigger_batch': False,
  'ignore_mask': False,
  'disc_final_slot': True,
  'exact_est_of_prob': False,
  'use_fixed_pattern': False,
  'hard_pruning': False,
  'correct_vi_objective': False,
  'clip_z_prob': False,
  'sharpen_z_prob': False,
  'parse_label_count': -1
}


def get_default(name):
  try:
    return hparams[name]
  except KeyError:
    print('Undefined default hparam value `%s' % name)
    exit(1)
