/*
 * Decompiled with CFR 0.152.
 */
package ter.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ter.core.Alignment;
import ter.core.Shift;
import ter.io.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SgmlProcessor {
    private String cur_set;
    private String src_lang;
    private String trg_lang;
    private String doc_id;
    private String sys_id;
    private String seg_id;
    private String hyp_rank;
    private String id;
    private Map<String, ATTRNAME> sgm_attr_names;
    private Map<String, TAGNAME> sgm_tag_names = new HashMap<String, TAGNAME>();
    private boolean is_ref;
    private String last_doc = "";
    private String last_seg = "";
    private String hyp_set;
    private boolean is_first_doc = true;
    private boolean is_first_seg = true;
    private Pattern start_tag_i;
    private Pattern end_tag_i;
    private Pattern start_end_tag_i;
    private Pattern no_tag_i;
    private Pattern attr_i;
    private boolean is_sgml;
    private Document document;
    private DocumentBuilderFactory factory = null;
    private DocumentBuilder builder = null;
    private Element cur_element;

    public TAGNAME tag_type(String name) {
        TAGNAME val = this.sgm_tag_names.get(name.toLowerCase());
        if (val == null) {
            return TAGNAME.UNKNOWN;
        }
        return val;
    }

    public ATTRNAME attr_type(String name) {
        ATTRNAME val = this.sgm_attr_names.get(name.toLowerCase());
        if (val == null) {
            return ATTRNAME.UNKNOWN;
        }
        return val;
    }

    public SgmlProcessor() {
        this.sgm_tag_names.put("tstset", TAGNAME.TSTSET);
        this.sgm_tag_names.put("refset", TAGNAME.REFSET);
        this.sgm_tag_names.put("doc", TAGNAME.DOC);
        this.sgm_tag_names.put("audiofile", TAGNAME.AUDIOFILE);
        this.sgm_tag_names.put("hyp", TAGNAME.HYP);
        this.sgm_tag_names.put("seg", TAGNAME.SEG);
        this.sgm_tag_names.put("word", TAGNAME.WORD);
        this.sgm_tag_names.put("p", TAGNAME.P);
        this.sgm_tag_names.put("hl", TAGNAME.HL);
        this.sgm_attr_names = new HashMap<String, ATTRNAME>();
        this.sgm_attr_names.put("setid", ATTRNAME.SETID);
        this.sgm_attr_names.put("srclang", ATTRNAME.SRCLANG);
        this.sgm_attr_names.put("trglang", ATTRNAME.TRGLANG);
        this.sgm_attr_names.put("docid", ATTRNAME.DOCID);
        this.sgm_attr_names.put("fileid", ATTRNAME.FILEID);
        this.sgm_attr_names.put("sysid", ATTRNAME.SYSID);
        this.sgm_attr_names.put("id", ATTRNAME.ID);
        this.sgm_attr_names.put("segid", ATTRNAME.SEGID);
        this.sgm_attr_names.put("start", ATTRNAME.START);
        this.sgm_attr_names.put("end", ATTRNAME.END);
    }

    public Document parse(String fn) {
        this.document = null;
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setValidating(false);
        this.factory.setNamespaceAware(true);
        try {
            this.builder = this.factory.newDocumentBuilder();
            this.builder.setErrorHandler(new ErrorHandler(){

                public void fatalError(SAXParseException sxe) throws SAXException {
                }

                public void error(SAXParseException spe) throws SAXParseException {
                    System.out.println("** SAXParseException, line " + spe.getLineNumber() + ", uri " + spe.getSystemId());
                    System.out.println("   " + spe.getMessage());
                }

                public void warning(SAXParseException warn) throws SAXParseException {
                    System.out.println("** Warning, line " + warn.getLineNumber() + ", uri " + warn.getSystemId());
                    System.out.println("   " + warn.getMessage());
                }
            });
            this.document = this.builder.parse(new File(fn));
            System.out.println("\"" + fn + "\" was successfully parsed as XML");
        }
        catch (SAXParseException spe) {
            this.buildDom(fn);
            if (this.document != null) {
                System.out.println("\"" + fn + "\" was successfully parsed as SGML");
            }
        }
        catch (SAXException sxe) {
            System.out.println("** SAXExceptionError ");
            sxe.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            System.out.println("** PCError ");
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println("** IOError ");
            ioe.printStackTrace();
        }
        return this.document;
    }

    public void loadSegs(Node node, Map<String, List<String>> segs, Map<String, List<String>> ids) {
        short type = node.getNodeType();
        this.is_ref = true;
        switch (type) {
            case 9: {
                this.loadSegs(((Document)node).getDocumentElement(), segs, ids);
                break;
            }
            case 1: {
                this.loadSegsElement(node, segs);
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.loadSegs(children.item(i), segs, ids);
                }
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                String text = node.getNodeValue().trim();
                if (this.id != null && text != null) {
                    List<String> val1 = segs.get(this.id);
                    List<String> val2 = ids.get(this.id);
                    if (val1 == null) {
                        ArrayList<String> al1 = new ArrayList<String>(6);
                        ArrayList<String> al2 = new ArrayList<String>(6);
                        al1.add(text);
                        al2.add(this.sys_id);
                        segs.put(this.id, al1);
                        ids.put(this.id, al2);
                    } else {
                        List<String> al1 = val1;
                        List<String> al2 = val2;
                        al1.add(text);
                        al2.add(this.sys_id);
                    }
                }
                this.id = null;
                break;
            }
        }
    }

    public void loadSegs(Node node, Map<String, List<String>> segs) {
        short type = node.getNodeType();
        this.is_ref = false;
        switch (type) {
            case 9: {
                this.loadSegs(((Document)node).getDocumentElement(), segs);
                break;
            }
            case 1: {
                this.loadSegsElement(node, segs);
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.loadSegs(children.item(i), segs);
                }
                break;
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                String text = node.getNodeValue().trim();
                if (this.id != null && text != null) {
                    List<String> val = segs.get(this.id);
                    if (val == null) {
                        ArrayList<String> al = new ArrayList<String>(6);
                        al.add(text);
                        segs.put(this.id, al);
                    } else {
                        List<String> al = val;
                        al.add(text);
                    }
                }
                this.id = null;
                break;
            }
        }
    }

    public void writeXMLHeader(BufferedWriter xml, String hyp_fn, String ref_fn, boolean caseon) {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("hh:mm:ss, E, MM dd yyyy");
        try {
            xml.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            xml.newLine();
            xml.write("<system title=\"Byblos\" hyp_fname=\"" + hyp_fn + "\" ref_fname=\"" + ref_fn + "\" creation_date=\"" + formatter.format(now.getTime()));
            if (caseon) {
                xml.write("\" case_sense=\"1\">");
            } else {
                xml.write("\" case_sense=\"0\">");
            }
            xml.newLine();
            xml.write("<tstset setid=\"" + (this.hyp_set == null ? "" : this.hyp_set) + "\" srclang=\"" + (this.src_lang == null ? "" : this.src_lang) + "\" trglang=\"" + (this.trg_lang == null ? "" : this.trg_lang) + "\">");
            xml.newLine();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return;
        }
    }

    public void writeXMLAlignment(BufferedWriter xml, Alignment result, String id, boolean istrans) {
        HashMap<ATTRNAME, String> cur_ids = this.parseID(id, istrans);
        if (istrans && this.is_first_doc) {
            try {
                xml.write("  <doc docid=\"\">");
                this.is_first_doc = false;
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                return;
            }
        }
        if (cur_ids != null) {
            String cur_rank = cur_ids.get((Object)ATTRNAME.RANK);
            if (this.newDoc(cur_ids)) {
                this.writeXMLDoc(xml, cur_ids);
            } else if (this.newSeg(cur_ids)) {
                this.writeXMLSeg(xml, cur_ids);
            }
            try {
                xml.write("      <hyp id=\"" + cur_rank + "\" refid=\"" + result.bestRef + "\" wrd_cnt=\"" + result.numWords + "\" num_errs=\"" + result.numEdits + "\">");
                this.writeXMLAlignmentDetails(xml, result.ref, result.aftershift, result.alignment, result.allshifts);
                xml.write("      </hyp>");
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                return;
            }
        }
    }

    public void writeXMLFooter(BufferedWriter xml) {
        try {
            xml.newLine();
            xml.write("    </seg>");
            xml.newLine();
            xml.write("  </doc>");
            xml.newLine();
            xml.write("</tstset>");
            xml.newLine();
            xml.write("</system>");
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return;
        }
    }

    public static String join(String delim, List<Integer> al) {
        String ret = "";
        if (al != null) {
            for (int i = 0; i < al.size() - 1; ++i) {
                ret = ret + al.get(i) + delim;
            }
            ret = ret + al.get(al.size() - 1);
        }
        return ret;
    }

    private boolean newDoc(HashMap<ATTRNAME, String> cur_ids) {
        String val = cur_ids.get((Object)ATTRNAME.DOCID);
        String cur_doc = val;
        if (cur_doc.equalsIgnoreCase(this.last_doc)) {
            return false;
        }
        this.last_doc = cur_doc;
        return true;
    }

    private boolean newSeg(HashMap<ATTRNAME, String> cur_ids) {
        String val = cur_ids.get((Object)ATTRNAME.SEGID);
        String cur_seg = val;
        if (cur_seg.equalsIgnoreCase(this.last_seg)) {
            return false;
        }
        this.last_seg = cur_seg;
        return true;
    }

    private HashMap<ATTRNAME, String> parseID(String id, boolean istrans) {
        HashMap<ATTRNAME, String> ret = new HashMap<ATTRNAME, String>();
        String[] sl = id.split(":+");
        if (istrans) {
            if (sl.length < 2) {
                ret.put(ATTRNAME.RANK, "");
                ret.put(ATTRNAME.SEGID, id);
            } else {
                ret.put(ATTRNAME.RANK, sl[1]);
                ret.put(ATTRNAME.SEGID, sl[0]);
            }
            ret.put(ATTRNAME.DOCID, "");
        } else {
            if (sl.length < 2) {
                System.out.println("** Error: Invalid id");
                return null;
            }
            ret.put(ATTRNAME.RANK, sl[1]);
            String s = sl[0].replaceAll("\\[", "");
            String[] sl1 = s.split("\\]+");
            if (sl1.length < 2) {
                System.out.println("** Error: Invalid id");
                return null;
            }
            ret.put(ATTRNAME.DOCID, sl1[0]);
            try {
                ret.put(ATTRNAME.SEGID, "" + Integer.valueOf(sl1[1]));
            }
            catch (NumberFormatException nfe) {
                ret.put(ATTRNAME.SEGID, sl1[1]);
            }
        }
        return ret;
    }

    private void writeXMLDoc(BufferedWriter xml, HashMap<ATTRNAME, String> cur_ids) {
        try {
            if (!this.is_first_doc) {
                xml.newLine();
                xml.write("    </seg>");
                xml.newLine();
                xml.write("  </doc>");
                xml.newLine();
            }
            this.is_first_doc = false;
            this.is_first_seg = false;
            String cur_doc = cur_ids.get((Object)ATTRNAME.DOCID);
            String cur_seg = cur_ids.get((Object)ATTRNAME.SEGID);
            xml.write("  <doc docid=\"" + cur_doc + "\">");
            xml.newLine();
            xml.write("    <seg segid=\"" + cur_seg + "\">");
            xml.newLine();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return;
        }
    }

    private void writeXMLSeg(BufferedWriter xml, HashMap<ATTRNAME, String> cur_ids) {
        try {
            if (!this.is_first_seg) {
                xml.newLine();
                xml.write("    </seg>");
            }
            xml.newLine();
            this.is_first_seg = false;
            String cur_seg = cur_ids.get((Object)ATTRNAME.SEGID);
            xml.write("    <seg segid=\"" + cur_seg + "\">");
            xml.newLine();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            return;
        }
    }

    private void writeXMLAlignmentDetails(BufferedWriter xml, String[] ref, String[] hyp, char[] alignment, Shift[] allshifts) {
        HashMap align_info = new HashMap();
        ArrayList<Integer> shift_dists = new ArrayList<Integer>();
        int anum = 1;
        int ind_start = 0;
        int ind_end = 1;
        int ind_from = 2;
        int ind_in = 3;
        int slen = 0;
        int non_inserr = 0;
        if (allshifts != null) {
            for (int i = 0; i < allshifts.length; ++i) {
                ArrayList<Integer> al;
                int dist;
                int nfrom;
                int nend;
                int nstart;
                int ostart = allshifts[i].start;
                int oend = allshifts[i].end;
                int odest = allshifts[i].newloc;
                slen = allshifts[i].size();
                if (odest >= oend) {
                    nstart = odest + 1 - slen;
                    nend = nstart + slen - 1;
                    nfrom = ostart;
                    dist = odest - oend;
                } else {
                    nstart = odest + 1;
                    nend = nstart + slen - 1;
                    nfrom = ostart + slen;
                    dist = (ostart - odest - 1) * -1;
                }
                shift_dists.add(dist);
                List<Integer> val = (ArrayList<Integer>)align_info.get(nstart + "-" + ind_start);
                if (val == null) {
                    al = new ArrayList<Integer>();
                    al.add(anum);
                    align_info.put(nstart + "-" + ind_start, al);
                } else {
                    al = val;
                    al.add(anum);
                }
                val = (List)align_info.get(nend + "-" + ind_end);
                if (val == null) {
                    al = new ArrayList();
                    al.add(anum);
                    align_info.put(nend + "-" + ind_end, al);
                } else {
                    al = val;
                    al.add(anum);
                }
                val = (List)align_info.get(nfrom + "-" + ind_from);
                if (val == null) {
                    al = new ArrayList();
                    al.add(anum);
                    align_info.put(nfrom + "-" + ind_from, al);
                } else {
                    al = val;
                    al.add(anum);
                }
                if (slen > 0) {
                    for (int j = nstart; j <= nend; ++j) {
                        List<Integer> al2;
                        val = (List)align_info.get(j + "-" + ind_in);
                        if (val == null) {
                            al2 = new ArrayList();
                            ((ArrayList)al2).add(anum);
                            align_info.put(j + "-" + ind_in, al2);
                            continue;
                        }
                        al2 = val;
                        ((ArrayList)al2).add(anum);
                    }
                }
                ++anum;
            }
        }
        int hyp_idx = 0;
        int ref_idx = 0;
        if (alignment != null) {
            block16: for (int i = 0; i < alignment.length; ++i) {
                List val;
                String shift_in_str = "";
                if (alignment[i] != 'D' && slen > 0 && (val = (List)align_info.get(hyp_idx + "-" + ind_in)) != null) {
                    shift_in_str = SgmlProcessor.join(",", val);
                }
                switch (alignment[i]) {
                    case ' ': {
                        try {
                            if (i == 0) {
                                xml.newLine();
                            }
                            if (!ref[ref_idx].equals(hyp[hyp_idx])) {
                                System.out.println("* Error: unmatch found, " + ref[ref_idx] + " vs. " + hyp[hyp_idx]);
                            }
                            xml.write("        ");
                            xml.write("\"" + ref[ref_idx] + "\",\"" + hyp[hyp_idx] + "\"," + "C,");
                            if (shift_in_str.equalsIgnoreCase("")) {
                                xml.write("0");
                            } else {
                                val = (List)align_info.get(hyp_idx + "-" + ind_in);
                                if (val != null) {
                                    List al = val;
                                    xml.write("" + shift_dists.get((Integer)al.get(0) - 1));
                                }
                            }
                            xml.newLine();
                            ++hyp_idx;
                            ++ref_idx;
                            ++non_inserr;
                            continue block16;
                        }
                        catch (IOException ioe) {
                            System.out.println(ioe);
                            return;
                        }
                    }
                    case 'S': 
                    case 'T': {
                        try {
                            if (i == 0) {
                                xml.newLine();
                            }
                            xml.write("        ");
                            xml.write("\"" + ref[ref_idx] + "\",\"" + hyp[hyp_idx] + "\",S,0");
                            xml.newLine();
                            ++ref_idx;
                            ++hyp_idx;
                            ++non_inserr;
                            continue block16;
                        }
                        catch (IOException ioe) {
                            System.out.println(ioe);
                            return;
                        }
                    }
                    case 'D': {
                        try {
                            if (i == 0) {
                                xml.newLine();
                            }
                            xml.write("        ");
                            xml.write("\"" + ref[ref_idx] + "\",\"\",D,0");
                            xml.newLine();
                            ++ref_idx;
                            ++non_inserr;
                            continue block16;
                        }
                        catch (IOException ioe) {
                            System.out.println(ioe);
                            return;
                        }
                    }
                    case 'I': {
                        try {
                            if (i == 0) {
                                xml.newLine();
                            }
                            xml.write("        ");
                            xml.write("\"\",\"" + hyp[hyp_idx] + "\",I,0");
                            xml.newLine();
                            ++hyp_idx;
                            continue block16;
                        }
                        catch (IOException ioe) {
                            System.out.println(ioe);
                            return;
                        }
                    }
                }
            }
        }
        if (non_inserr != ref.length && ref.length > 1) {
            System.out.println("** Error, unmatch non-insertion erros " + non_inserr + " and reference length " + ref.length);
        }
    }

    private void addDomElement(Element parent, Element child, Map<String, String> content) {
        for (String attr_name : content.keySet()) {
            String attr_val = content.get(attr_name);
            attr_val = attr_val.replaceAll("\"", "");
            child.setAttribute(attr_name, attr_val);
        }
        parent.appendChild(child);
    }

    private void getAttr(String inner, Map<String, String> content) {
        while (inner != "") {
            Matcher attr_m = this.attr_i.matcher(inner);
            if (attr_m.matches()) {
                String attr_name = attr_m.group(1);
                String attr_val = attr_m.group(2);
                content.put(attr_name, attr_val);
                inner = attr_m.group(3);
                continue;
            }
            inner = "";
        }
    }

    private int getNTag(String line, Tag tag) {
        Matcher start_tag_m = this.start_tag_i.matcher(line);
        Matcher end_tag_m = this.end_tag_i.matcher(line);
        Matcher start_end_tag_m = this.start_end_tag_i.matcher(line);
        Matcher no_tag_m = this.no_tag_i.matcher(line);
        if (start_end_tag_m.matches()) {
            tag.name = start_end_tag_m.group(1);
            String inner = start_end_tag_m.group(2);
            this.getAttr(inner, tag.content);
            tag.rest = start_end_tag_m.group(3);
            return 3;
        }
        if (end_tag_m.matches()) {
            tag.name = end_tag_m.group(1);
            tag.rest = end_tag_m.group(3);
            return 2;
        }
        if (start_tag_m.matches()) {
            tag.name = start_tag_m.group(1);
            String inner = start_tag_m.group(2);
            this.getAttr(inner, tag.content);
            tag.rest = start_tag_m.group(3);
            return 1;
        }
        if (no_tag_m.matches()) {
            tag.name = "";
            tag.rest = no_tag_m.group(2);
            tag.content.put("text", no_tag_m.group(1));
            return 1;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildDomLine(String line) {
        Tag tag = new Tag();
        if (line.trim().equals("")) {
            return;
        }
        if (this.document == null) {
            return;
        }
        int found = this.getNTag(line, tag);
        if (!(this.cur_element != null || found != 1 && found != 3 || tag.name.equalsIgnoreCase(""))) {
            if (!tag.name.equalsIgnoreCase("tstset") && !tag.name.equalsIgnoreCase("refset")) return;
            this.is_sgml = true;
            Element root = this.document.createElement(tag.name);
            this.document.appendChild(root);
            this.cur_element = root;
            for (String attr_name : tag.content.keySet()) {
                String attr_val = tag.content.get(attr_name);
                attr_val = attr_val.replaceAll("\"", "");
                this.cur_element.setAttribute(attr_name, attr_val);
            }
            this.buildDomLine(tag.rest);
            return;
        } else {
            if (this.cur_element == null) return;
            switch (found) {
                case 1: {
                    if (tag.name.equalsIgnoreCase("")) {
                        String text = tag.content.get("text");
                        if (text != null) {
                            this.cur_element.appendChild(this.document.createTextNode(text));
                        }
                        this.buildDomLine(tag.rest);
                        return;
                    }
                    Element child = this.document.createElement(tag.name);
                    this.addDomElement(this.cur_element, child, tag.content);
                    this.cur_element = child;
                    this.buildDomLine(tag.rest);
                    return;
                }
                case 2: {
                    if (tag.name.equalsIgnoreCase(this.cur_element.getTagName())) {
                        if (this.cur_element.getParentNode().getNodeType() == 9) return;
                        this.cur_element = (Element)this.cur_element.getParentNode();
                        return;
                    }
                    System.out.println("** Warning: found mis-matching tags in line: " + line + " - " + tag.name + " vs " + this.cur_element.getTagName());
                    this.document = null;
                    return;
                }
                case 3: {
                    if (!tag.name.equalsIgnoreCase("")) {
                        Element child = this.document.createElement(tag.name);
                        this.addDomElement(this.cur_element, child, tag.content);
                        this.buildDomLine(tag.rest);
                        return;
                    }
                    System.out.println("** Warning: found empty name tags " + tag.name);
                    this.document = null;
                    return;
                }
            }
        }
    }

    private void buildDom(String fn) {
        BufferedReader stream;
        this.is_sgml = false;
        this.start_tag_i = Pattern.compile("^\\s*\\<([^> ]*)\\s*([^>]*)\\>(.*)$", 2);
        this.end_tag_i = Pattern.compile("^\\s*\\</([^> ]*)\\s*([^>]*)\\>(.*)$", 2);
        this.start_end_tag_i = Pattern.compile("^\\s*\\<([^> ]*)\\s*([^>]*)\\\\>(.*)$", 2);
        this.attr_i = Pattern.compile("^\\s*(\\S+)=(\\S+)\\s*(.*)$", 2);
        this.no_tag_i = Pattern.compile("^\\s*([^\\<]*)(.*)\\s*$", 2);
        try {
            stream = new BufferedReader(new FileReader(fn));
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            this.document = null;
            return;
        }
        try {
            String line;
            this.cur_element = null;
            this.builder = this.factory.newDocumentBuilder();
            this.document = this.builder.newDocument();
            while ((line = stream.readLine()) != null) {
                if (line.matches("^\\s*$")) continue;
                this.buildDomLine(line);
            }
            if (!this.is_sgml) {
                this.document = null;
            }
        }
        catch (ParserConfigurationException pce) {
            System.out.println("** PCError ");
            pce.printStackTrace();
            this.document = null;
            return;
        }
        catch (IOException ioe) {
            System.out.println(ioe);
            this.document = null;
            return;
        }
    }

    private void loadSegsElement(Node node, Map<String, List<String>> segs) {
        String name = node.getNodeName().trim();
        NamedNodeMap attrs = node.getAttributes();
        switch (this.tag_type(name)) {
            case TSTSET: 
            case REFSET: {
                if (attrs == null) break;
                block27: for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    String attrName = attr.getNodeName().trim();
                    switch (this.attr_type(attrName)) {
                        case SETID: {
                            this.cur_set = attr.getNodeValue().trim();
                            if (this.is_ref) continue block27;
                            this.hyp_set = this.cur_set;
                            continue block27;
                        }
                        case SRCLANG: {
                            this.src_lang = attr.getNodeValue().trim();
                            continue block27;
                        }
                        case TRGLANG: {
                            this.trg_lang = attr.getNodeValue().trim();
                            continue block27;
                        }
                    }
                }
                break;
            }
            case DOC: {
                if (attrs == null) break;
                block28: for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    String attrName = attr.getNodeName().trim().toLowerCase();
                    switch (this.attr_type(attrName)) {
                        case DOCID: {
                            this.doc_id = attr.getNodeValue().trim();
                            continue block28;
                        }
                        case SYSID: {
                            this.sys_id = attr.getNodeValue().trim();
                            continue block28;
                        }
                    }
                }
                break;
            }
            case AUDIOFILE: {
                if (attrs == null) break;
                block29: for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    String attrName = attr.getNodeName().trim().toLowerCase();
                    switch (this.attr_type(attrName)) {
                        case FILEID: {
                            this.doc_id = attr.getNodeValue().trim();
                            continue block29;
                        }
                    }
                }
                break;
            }
            case SEG: {
                if (attrs == null) break;
                block30: for (int i = 0; i < attrs.getLength(); ++i) {
                    Node attr = attrs.item(i);
                    String attrName = attr.getNodeName().trim();
                    switch (this.attr_type(attrName)) {
                        case ID: {
                            this.seg_id = attr.getNodeValue().trim();
                            this.id = "[" + this.doc_id + "][" + String.format("%1$04d", Integer.valueOf(this.seg_id)) + "]";
                            continue block30;
                        }
                        case SEGID: {
                            this.seg_id = attr.getNodeValue().trim();
                            continue block30;
                        }
                    }
                }
                break;
            }
            case HYP: {
                if (attrs != null) {
                    block31: for (int i = 0; i < attrs.getLength(); ++i) {
                        Node attr = attrs.item(i);
                        String attrName = attr.getNodeName().trim();
                        switch (this.attr_type(attrName)) {
                            case ID: {
                                String rank = attr.getNodeValue().trim();
                                this.id = "[" + this.doc_id + "][" + String.format("%1$04d", Integer.valueOf(this.seg_id)) + "]:" + rank;
                                continue block31;
                            }
                        }
                    }
                }
            }
            case WORD: {
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ATTRNAME {
        SETID,
        SRCLANG,
        TRGLANG,
        DOCID,
        FILEID,
        SYSID,
        ID,
        SEGID,
        START,
        END,
        RANK,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TAGNAME {
        TSTSET,
        REFSET,
        DOC,
        AUDIOFILE,
        SEG,
        HYP,
        WORD,
        HL,
        P,
        UNKNOWN;

    }
}

