/*
 * Decompiled with CFR 0.152.
 */
package ter.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import ter.core.Alignment;
import ter.core.CostFunction;
import ter.core.Normalizer;
import ter.core.Shift;
import ter.util.IntPair;
import ter.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerScorer {
    private static final boolean DEBUG = false;
    private boolean normalized = false;
    private boolean caseon = false;
    private boolean nopunct = false;
    private IntPair[] refSpans = null;
    private IntPair[] hypSpans = null;
    public double ref_len = -1.0;
    public int BEAM_WIDTH = 20;
    private static final double INF = 999999.0;
    private final int MAX_SHIFT_SIZE = 10;
    private int MAX_SHIFT_DIST = 50;
    private int NUM_SEGMENTS_SCORED = 0;
    private int NUM_SHIFTS_CONSIDERED = 0;
    private int NUM_BEAM_SEARCH_CALLS = 0;
    private double[][] S = new double[350][350];
    private char[][] P = new char[350][350];

    public void setNormalize(boolean b) {
        this.normalized = b;
    }

    public void setCase(boolean b) {
        this.caseon = b;
    }

    public void setPunct(boolean b) {
        this.nopunct = b;
    }

    public void setBeamWidth(int i) {
        this.BEAM_WIDTH = i;
    }

    public void setShiftDist(int i) {
        this.MAX_SHIFT_DIST = i;
    }

    public void setRefSpan(String span) {
        if (span != null && span.trim() != "") {
            String[] spans = span.split("\\s+");
            this.refSpans = new IntPair[spans.length];
            for (int i = 0; i < spans.length; ++i) {
                String[] s = spans[i].split(":");
                this.refSpans[i] = new IntPair(Integer.valueOf(s[0]), Integer.valueOf(s[1]));
            }
        }
    }

    public void setHypSpan(String span) {
        if (span != null && span.trim() != "") {
            String[] spans = span.split("\\s+");
            this.hypSpans = new IntPair[spans.length];
            for (int i = 0; i < spans.length; ++i) {
                String[] s = spans[i].split(":");
                this.hypSpans[i] = new IntPair(Integer.valueOf(s[0]), Integer.valueOf(s[1]));
            }
        }
    }

    public void setRefLen(List<String> reflens) {
        String reflen = "";
        if (reflens == null || reflens.size() == 0) {
            this.ref_len = -1.0;
            return;
        }
        this.ref_len = 0.0;
        for (int i = 0; i < reflens.size(); ++i) {
            reflen = reflens.get(i);
            if (reflen.length() == 0) {
                this.ref_len += 0.0;
                continue;
            }
            this.ref_len += (double)this.tokenize(reflen).length;
        }
        this.ref_len /= (double)reflens.size();
    }

    public void setRefLen(double d) {
        this.ref_len = d >= 0.0 ? d : -1.0;
    }

    public Alignment TER(String[] hyp, String[] ref) {
        return this.TER(hyp, ref, new CostFunction());
    }

    public Alignment TER(String hyp, String ref) {
        return this.TER(hyp, ref, new CostFunction());
    }

    public Alignment TER(String hyp, String ref, CostFunction costfunc) {
        Alignment to_return;
        if (!this.caseon) {
            hyp = hyp.toLowerCase();
            ref = ref.toLowerCase();
        }
        if (ref.length() == 0 || hyp.length() == 0) {
            to_return = this.TERnullstr(hyp, ref, costfunc);
            if (this.ref_len >= 0.0) {
                to_return.numWords = this.ref_len;
            }
        } else {
            String[] hyparr = this.tokenize(hyp);
            String[] refarr = this.tokenize(ref);
            to_return = this.TER(hyparr, refarr, costfunc);
            if (this.ref_len >= 0.0) {
                to_return.numWords = this.ref_len;
            }
        }
        return to_return;
    }

    public Alignment TERnullstr(String hyp, String ref, CostFunction costfunc) {
        Alignment to_return = new Alignment();
        String[] hyparr = this.tokenize(hyp);
        String[] refarr = this.tokenize(ref);
        if (hyp.length() == 0 && ref.length() == 0) {
            to_return.numWords = 0.0;
            to_return.numEdits = 0.0;
        } else if (hyp.length() == 0) {
            to_return.alignment = new char[refarr.length];
            for (int i = 0; i < refarr.length; ++i) {
                to_return.alignment[i] = 68;
            }
            to_return.numWords = refarr.length;
            to_return.numEdits = refarr.length;
        } else {
            to_return.alignment = new char[hyparr.length];
            for (int i = 0; i < hyparr.length; ++i) {
                to_return.alignment[i] = 73;
            }
            to_return.numWords = 0.0;
            to_return.numEdits = hyparr.length;
        }
        to_return.hyp = hyparr;
        to_return.ref = refarr;
        to_return.aftershift = hyparr;
        return to_return;
    }

    public Alignment TER(String[] hyp, String[] ref, CostFunction costfunc) {
        Object[] returns;
        Map<List<String>, Set<Integer>> rloc = this.BuildWordMatches(hyp, ref);
        Alignment cur_align = this.MinEditDist(hyp, ref, costfunc, this.hypSpans);
        String[] cur = hyp;
        cur_align.hyp = hyp;
        cur_align.ref = ref;
        cur_align.aftershift = hyp;
        double edits = 0.0;
        boolean numshifts = false;
        ArrayList<Shift> allshifts = new ArrayList<Shift>(hyp.length + ref.length);
        while ((returns = this.CalcBestShift(cur, hyp, ref, rloc, cur_align, costfunc)) != null) {
            Shift bestShift = (Shift)returns[0];
            edits += bestShift.cost;
            cur_align = (Alignment)returns[1];
            bestShift.alignment = cur_align.alignment;
            bestShift.aftershift = cur_align.aftershift;
            allshifts.add(bestShift);
            cur = cur_align.aftershift;
        }
        Alignment to_return = cur_align;
        to_return.allshifts = allshifts.toArray(new Shift[0]);
        to_return.numEdits += edits;
        ++this.NUM_SEGMENTS_SCORED;
        return to_return;
    }

    public String[] tokenize(String s) {
        return Normalizer.tokenize(s, this.normalized, this.nopunct);
    }

    private Map<List<String>, Set<Integer>> BuildWordMatches(String[] hyp, String[] ref) {
        HashSet<String> hwhash = new HashSet<String>();
        for (int i = 0; i < hyp.length; ++i) {
            hwhash.add(hyp[i]);
        }
        boolean[] cor = new boolean[ref.length];
        for (int i = 0; i < ref.length; ++i) {
            cor[i] = hwhash.contains(ref[i]);
        }
        List<String> reflist = Arrays.asList(ref);
        HashMap<List<String>, Set<Integer>> to_return = new HashMap<List<String>, Set<Integer>>();
        for (int start = 0; start < ref.length; ++start) {
            if (!cor[start]) continue;
            for (int end = start; end < ref.length && end - start <= 10 && cor[end]; ++end) {
                Set<Object> vals;
                List<String> topush = reflist.subList(start, end + 1);
                if (to_return.containsKey(topush)) {
                    vals = to_return.get(topush);
                    vals.add(new Integer(start));
                    continue;
                }
                vals = new TreeSet();
                vals.add(new Integer(start));
                to_return.put(topush, vals);
            }
        }
        return to_return;
    }

    private static void FindAlignErr(Alignment align, boolean[] herr, boolean[] rerr, int[] ralign) {
        int hpos = -1;
        int rpos = -1;
        for (int i = 0; i < align.alignment.length; ++i) {
            char sym = align.alignment[i];
            if (sym == ' ') {
                herr[++hpos] = false;
                rerr[++rpos] = false;
                ralign[rpos] = hpos;
                continue;
            }
            if (sym == 'S') {
                herr[++hpos] = true;
                rerr[++rpos] = true;
                ralign[rpos] = hpos;
                continue;
            }
            if (sym == 'I') {
                herr[++hpos] = true;
                continue;
            }
            if (sym == 'D') {
                rerr[++rpos] = true;
                ralign[rpos] = hpos;
                continue;
            }
            System.err.print("Error!  Invalid mini align sequence " + sym + " at pos " + i + "\n");
            System.exit(-1);
        }
    }

    private Object[] CalcBestShift(String[] cur, String[] hyp, String[] ref, Map<List<String>, Set<Integer>> rloc, Alignment med_align, CostFunction costfunc) {
        double maxfix;
        double curfix;
        Object[] to_return = new Object[2];
        boolean anygain = false;
        boolean[] herr = new boolean[hyp.length];
        boolean[] rerr = new boolean[ref.length];
        int[] ralign = new int[ref.length];
        TerScorer.FindAlignErr(med_align, herr, rerr, ralign);
        Shift[][] poss_shifts = this.GatherAllPossShifts(cur, ref, rloc, med_align, herr, rerr, ralign, costfunc);
        double curerr = med_align.numEdits;
        double cur_best_shift_cost = 0.0;
        Alignment cur_best_align = med_align;
        Shift cur_best_shift = new Shift();
        for (int i = poss_shifts.length - 1; !(i < 0 || (curfix = curerr - (cur_best_shift_cost + cur_best_align.numEdits)) > (maxfix = (double)(2 * (1 + i))) || cur_best_shift_cost != 0.0 && curfix == maxfix); --i) {
            for (int s = 0; !(s >= poss_shifts[i].length || (curfix = curerr - (cur_best_shift_cost + cur_best_align.numEdits)) > maxfix || cur_best_shift_cost != 0.0 && curfix == maxfix); ++s) {
                Shift curshift = poss_shifts[i][s];
                Pair<String[], IntPair[]> shiftReturns = this.PerformShift(cur, curshift);
                String[] shiftarr = (String[])shiftReturns.first;
                IntPair[] curHypSpans = (IntPair[])shiftReturns.second;
                Alignment curalign = this.MinEditDist(shiftarr, ref, costfunc, curHypSpans);
                curalign.hyp = hyp;
                curalign.ref = ref;
                curalign.aftershift = shiftarr;
                double gain = cur_best_align.numEdits + cur_best_shift_cost - (curalign.numEdits + curshift.cost);
                if (!(gain > 0.0) && (cur_best_shift_cost != 0.0 || gain != 0.0)) continue;
                anygain = true;
                cur_best_shift = curshift;
                cur_best_shift_cost = curshift.cost;
                cur_best_align = curalign;
            }
        }
        if (anygain) {
            to_return[0] = cur_best_shift;
            to_return[1] = cur_best_align;
            return to_return;
        }
        return null;
    }

    private Shift[][] GatherAllPossShifts(String[] hyp, String[] ref, Map<List<String>, Set<Integer>> rloc, Alignment align, boolean[] herr, boolean[] rerr, int[] ralign, CostFunction costfunc) {
        if (this.MAX_SHIFT_DIST <= 0) {
            Shift[][] to_return = new Shift[][]{};
            return to_return;
        }
        ArrayList[] allshifts = new ArrayList[11];
        for (int i = 0; i < allshifts.length; ++i) {
            allshifts[i] = new ArrayList();
        }
        List<String> hyplist = Arrays.asList(hyp);
        for (int start = 0; start < hyp.length; ++start) {
            if (!rloc.containsKey(hyplist.subList(start, start + 1))) continue;
            boolean ok = false;
            Iterator<Integer> mti = rloc.get(hyplist.subList(start, start + 1)).iterator();
            while (mti.hasNext() && !ok) {
                int moveto = mti.next();
                if (start == ralign[moveto] || ralign[moveto] - start > this.MAX_SHIFT_DIST || start - ralign[moveto] - 1 > this.MAX_SHIFT_DIST) continue;
                ok = true;
            }
            if (!ok) continue;
            ok = true;
            for (int end = start; ok && end < hyp.length && end < start + 10; ++end) {
                List<String> cand = hyplist.subList(start, end + 1);
                ok = false;
                if (!rloc.containsKey(cand)) continue;
                boolean any_herr = false;
                for (int i = 0; i <= end - start && !any_herr; ++i) {
                    if (!herr[start + i]) continue;
                    any_herr = true;
                }
                if (!any_herr) {
                    ok = true;
                    continue;
                }
                for (int moveto : rloc.get(cand)) {
                    if (ralign[moveto] == start || ralign[moveto] >= start && ralign[moveto] <= end || ralign[moveto] - start > this.MAX_SHIFT_DIST || start - ralign[moveto] > this.MAX_SHIFT_DIST) continue;
                    ok = true;
                    boolean any_rerr = false;
                    for (int i = 0; i <= end - start && !any_rerr; ++i) {
                        if (!rerr[moveto + i]) continue;
                        any_rerr = true;
                    }
                    if (!any_rerr) continue;
                    for (int roff = -1; roff <= end - start; ++roff) {
                        Shift topush = null;
                        if (roff == -1 && moveto == 0) {
                            topush = new Shift(start, end, -1, -1);
                        } else if (start != ralign[moveto + roff] && (roff == 0 || ralign[moveto + roff] != ralign[moveto])) {
                            int newloc = ralign[moveto + roff];
                            topush = new Shift(start, end, moveto + roff, newloc);
                        }
                        if (topush == null) continue;
                        topush.shifted = cand;
                        topush.cost = costfunc.shift_cost(topush);
                        allshifts[end - start].add(topush);
                    }
                }
            }
        }
        Shift[][] to_return = new Shift[11][];
        for (int i = 0; i < to_return.length; ++i) {
            to_return[i] = allshifts[i].toArray(new Shift[allshifts[i].size()]);
        }
        return to_return;
    }

    public Pair<String[], IntPair[]> PerformShift(String[] words, Shift s) {
        return this.PerformShift(words, s.start, s.end, s.newloc);
    }

    private Pair<String[], IntPair[]> PerformShift(String[] words, int start, int end, int newloc) {
        int c = 0;
        String[] nwords = (String[])words.clone();
        IntPair[] spans = null;
        if (this.hypSpans != null) {
            spans = new IntPair[this.hypSpans.length];
        }
        if (newloc == -1) {
            int i;
            for (i = start; i <= end; ++i) {
                nwords[c++] = words[i];
                if (this.hypSpans == null) continue;
                spans[c - 1] = this.hypSpans[i];
            }
            for (i = 0; i <= start - 1; ++i) {
                nwords[c++] = words[i];
                if (this.hypSpans == null) continue;
                spans[c - 1] = this.hypSpans[i];
            }
            for (i = end + 1; i < words.length; ++i) {
                nwords[c++] = words[i];
                if (this.hypSpans == null) continue;
                spans[c - 1] = this.hypSpans[i];
            }
        } else if (newloc < start) {
            int i;
            for (i = 0; i <= newloc; ++i) {
                nwords[c++] = words[i];
                if (this.hypSpans == null) continue;
                spans[c - 1] = this.hypSpans[i];
            }
            for (i = start; i <= end; ++i) {
                nwords[c++] = words[i];
                if (this.hypSpans == null) continue;
                spans[c - 1] = this.hypSpans[i];
            }
            for (i = newloc + 1; i <= start - 1; ++i) {
                nwords[c++] = words[i];
                if (this.hypSpans == null) continue;
                spans[c - 1] = this.hypSpans[i];
            }
            for (i = end + 1; i < words.length; ++i) {
                nwords[c++] = words[i];
                if (this.hypSpans == null) continue;
                spans[c - 1] = this.hypSpans[i];
            }
        } else if (newloc > end) {
            int i;
            for (i = 0; i <= start - 1; ++i) {
                nwords[c++] = words[i];
                if (this.hypSpans == null) continue;
                spans[c - 1] = this.hypSpans[i];
            }
            for (i = end + 1; i <= newloc; ++i) {
                nwords[c++] = words[i];
                if (this.hypSpans == null) continue;
                spans[c - 1] = this.hypSpans[i];
            }
            for (i = start; i <= end; ++i) {
                nwords[c++] = words[i];
                if (this.hypSpans == null) continue;
                spans[c - 1] = this.hypSpans[i];
            }
            for (i = newloc + 1; i < words.length; ++i) {
                nwords[c++] = words[i];
                if (this.hypSpans == null) continue;
                spans[c - 1] = this.hypSpans[i];
            }
        } else {
            int i;
            for (i = 0; i <= start - 1; ++i) {
                nwords[c++] = words[i];
                if (this.hypSpans == null) continue;
                spans[c - 1] = this.hypSpans[i];
            }
            for (i = end + 1; i < words.length && i <= end + (newloc - start); ++i) {
                nwords[c++] = words[i];
                if (this.hypSpans == null) continue;
                spans[c - 1] = this.hypSpans[i];
            }
            for (i = start; i <= end; ++i) {
                nwords[c++] = words[i];
                if (this.hypSpans == null) continue;
                spans[c - 1] = this.hypSpans[i];
            }
            for (i = end + (newloc - start) + 1; i < words.length; ++i) {
                nwords[c++] = words[i];
                if (this.hypSpans == null) continue;
                spans[c - 1] = this.hypSpans[i];
            }
        }
        ++this.NUM_SHIFTS_CONSIDERED;
        return new Pair<String[], IntPair[]>(nwords, spans);
    }

    private Alignment MinEditDist(String[] hyp, String[] ref, CostFunction costfunc, IntPair[] curHypSpans) {
        int j;
        int i;
        double current_best = 999999.0;
        double last_best = 999999.0;
        int first_good = 0;
        int current_first_good = 0;
        int last_good = -1;
        int cur_last_good = 0;
        int last_peak = 0;
        int cur_last_peak = 0;
        int hwsize = hyp.length - 1;
        int rwsize = ref.length - 1;
        ++this.NUM_BEAM_SEARCH_CALLS;
        if (ref.length + 1 > this.S.length || hyp.length + 1 > this.S.length) {
            int max = ref.length;
            if (hyp.length > ref.length) {
                max = hyp.length;
            }
            this.S = new double[max += 26][max];
            this.P = new char[max][max];
        }
        for (i = 0; i <= ref.length; ++i) {
            for (j = 0; j <= hyp.length; ++j) {
                this.S[i][j] = -1.0;
                this.P[i][j] = 48;
            }
        }
        this.S[0][0] = 0.0;
        for (j = 0; j <= hyp.length; ++j) {
            last_best = current_best;
            current_best = 999999.0;
            first_good = current_first_good;
            current_first_good = -1;
            last_good = cur_last_good;
            cur_last_good = -1;
            last_peak = cur_last_peak;
            cur_last_peak = 0;
            for (i = first_good; i <= ref.length && i <= last_good; ++i) {
                if (this.S[i][j] < 0.0) continue;
                double score = this.S[i][j];
                if (j < hyp.length && score > last_best + (double)this.BEAM_WIDTH) continue;
                if (current_first_good == -1) {
                    current_first_good = i;
                }
                if (i < ref.length && j < hyp.length && (this.refSpans == null || this.hypSpans == null || TerScorer.spanIntersection(this.refSpans[i], curHypSpans[j]))) {
                    double cost;
                    if (ref[i].equals(hyp[j])) {
                        cost = costfunc.match_cost(hyp[j], ref[i]) + score;
                        if (this.S[i + 1][j + 1] == -1.0 || cost < this.S[i + 1][j + 1]) {
                            this.S[i + 1][j + 1] = cost;
                            this.P[i + 1][j + 1] = 32;
                        }
                        if (cost < current_best) {
                            current_best = cost;
                        }
                        if (current_best == cost) {
                            cur_last_peak = i + 1;
                        }
                    } else {
                        cost = costfunc.substitute_cost(hyp[j], ref[i]) + score;
                        if (this.S[i + 1][j + 1] < 0.0 || cost < this.S[i + 1][j + 1]) {
                            this.S[i + 1][j + 1] = cost;
                            this.P[i + 1][j + 1] = 83;
                            if (cost < current_best) {
                                current_best = cost;
                            }
                            if (current_best == cost) {
                                cur_last_peak = i + 1;
                            }
                        }
                    }
                }
                cur_last_good = i + 1;
                if (j < hyp.length) {
                    double icost = score + costfunc.insert_cost(hyp[j]);
                    if (this.S[i][j + 1] < 0.0 || this.S[i][j + 1] > icost) {
                        this.S[i][j + 1] = icost;
                        this.P[i][j + 1] = 73;
                        if (cur_last_peak < i && current_best == icost) {
                            cur_last_peak = i;
                        }
                    }
                }
                if (i >= ref.length) continue;
                double dcost = score + costfunc.delete_cost(ref[i]);
                if (!(this.S[i + 1][j] < 0.0) && !(this.S[i + 1][j] > dcost)) continue;
                this.S[i + 1][j] = dcost;
                this.P[i + 1][j] = 68;
                if (i < last_good) continue;
                last_good = i + 1;
            }
        }
        int tracelength = 0;
        i = ref.length;
        j = hyp.length;
        while (i > 0 || j > 0) {
            ++tracelength;
            if (this.P[i][j] == ' ') {
                --i;
                --j;
                continue;
            }
            if (this.P[i][j] == 'S') {
                --i;
                --j;
                continue;
            }
            if (this.P[i][j] == 'D') {
                --i;
                continue;
            }
            if (this.P[i][j] == 'I') {
                --j;
                continue;
            }
            System.out.println("Invalid path: " + this.P[i][j]);
            System.exit(-1);
        }
        char[] path = new char[tracelength];
        i = ref.length;
        j = hyp.length;
        while (i > 0 || j > 0) {
            path[--tracelength] = this.P[i][j];
            if (this.P[i][j] == ' ') {
                --i;
                --j;
                continue;
            }
            if (this.P[i][j] == 'S') {
                --i;
                --j;
                continue;
            }
            if (this.P[i][j] == 'D') {
                --i;
                continue;
            }
            if (this.P[i][j] != 'I') continue;
            --j;
        }
        Alignment to_return = new Alignment();
        to_return.numWords = ref.length;
        to_return.alignment = path;
        to_return.numEdits = this.S[ref.length][hyp.length];
        return to_return;
    }

    private static boolean spanIntersection(IntPair refSpan, IntPair hypSpan) {
        return refSpan.cdr >= hypSpan.car && refSpan.car <= hypSpan.cdr;
    }

    public int numBeamCalls() {
        return this.NUM_BEAM_SEARCH_CALLS;
    }

    public int numSegsScored() {
        return this.NUM_SEGMENTS_SCORED;
    }

    public int numShiftsTried() {
        return this.NUM_SHIFTS_CONSIDERED;
    }
}

