from milie.evals.evaluate import Benchmark
from milie.evals.matcher import Matcher
from milie.evals.generalReader import GeneralReader
import os
from milie.carb.carb import Benchmark as CarbBenchmark
from milie.carb.matcher import Matcher as CarbMatcher
from milie.carb.oie_readers.tabReader import TabReader, JsonReader
import json
from collections import defaultdict

class Evaluate():
    def __init__(self):
        self.b = None

    def evaluate(self, prediction_file, gold_file):
        auc, prec, rec, f1, all_results = self.get_performance(prediction_file, gold_file)
        results = dict()
        results['f1'] = f1
        results['precision'] = prec
        results['recall'] = rec
        return results, all_results

    def get_performance(self, prediction_file, gold_file):
        auc, precision, recall, f1 = [None for _ in range(4)]
        all_results= None
        if 'Re-OIE2016' in gold_file:
            matching_func = Matcher.lexicalMatch
            error_fn = 'error_idxs.txt'
            evaluator = Benchmark(gold_file)
            reader = JsonReader()
            reader.read(prediction_file)
            (precision, recall, f1), auc = evaluator.compare(
                predicted=reader.oie,
                matchingFunc=matching_func,
                output_fn='pr_curve.txt',
                error_file=error_fn)
        elif 'CaRB' in gold_file:
            matching_func = CarbMatcher.binary_linient_tuple_match
            error_fn = 'error_idxs.txt'
            evaluator = CarbBenchmark(gold_file)
            reader = JsonReader()
            reader.read(prediction_file)

            auc, (precision, recall, f1),all_results = evaluator.compare(
                    predicted=reader.oie,
                    matchingFunc=matching_func,
                    output_fn='pr_curve.txt',
                    error_file=error_fn)
        return auc, precision, recall, f1, all_results

    def _read_file(self, gold_file):
        with open(gold_file, encoding='utf8') as f:
            data = json.load(f)
        return data


if __name__ == '__main__':
    eval = Evaluate()
    pred_file = 'C:\\data\\milie\\prediction_es_pp.tok'
    gold_file = 'C:\\data\\milie\\Re-OIE2016-Spanish-Clean.json'
    results = eval.evaluate(pred_file, gold_file)
    print(results[0])

