import torch


def hinge_loss(output, target):
    """
    Args:
        output: A Variable containing a FloatTensor of size
            (batch, max_len) which contains the
            unnormalized probability for each class.
        target: A Variable containing a LongTensor of size
            (batch, max_len) which contains the index of the true
            class for each corresponding step.

    Returns:
        loss: An average loss value masked by the length.
    """
    loss = 1 - torch.mul(output, target)
    loss[loss < 0] = 0
    loss = torch.mean(loss, dim=1, keepdim=False)
    loss = torch.mean(loss, dim=0)
    return loss
