#!/bin/bash

CONFIG_EN="config/config_GenEAE_ere_mbart50copy_en_lang_eos-triggerword_template-roletype.json"
CONFIG_ES="config/config_GenEAE_ere_mbart50copy_es_lang_eos-triggerword_template-roletype.json"

# CONFIG_EN="config/config_GenEAE_ere_mT5copy_en-triggerword_template-roletype.json"
# CONFIG_ES="config/config_GenEAE_ere_mT5copy_es-triggerword_template-roletype.json"

# CONFIG_EN="config/config_GenEAE_ere_mT5copy-base_en-triggerword_template-roletype.json"
# CONFIG_ES="config/config_GenEAE_ere_mT5copy-base_es-triggerword_template-roletype.json"

TEST_EN="../Data/ERE_crossling/ere_en_xlmroberta/test.w1.oneie.json"
TEST_ES="../Data/ERE_crossling/ere_es_xlmroberta/test.w1.oneie.json"

GPU=$1
MODEL=$2
LANG=$3

export CUDA_VISIBLE_DEVICES=$GPU

echo $CONFIG_EN
python eval_pipelineEE.py -ceae $CONFIG_EN -eae $MODEL -g -w predictions/$LANG --no_dev --ere --constrained_decode
python ../BaseModel/external_scorer.py -p predictions/$LANG/test.pred.json -g $TEST_EN

echo $CONFIG_ES
python eval_pipelineEE.py -ceae $CONFIG_ES -eae $MODEL -g -w predictions/$LANG --no_dev --ere --constrained_decode
python ../BaseModel/external_scorer.py -p predictions/$LANG/test.pred.json -g $TEST_ES

