root=./
#export PYTHONPATH=$root:$PYTHONPATH

MODEL_SUFFIX=$1
SUBSET=$2
tag=$3
gen_subsets="train valid test"
if ! [[ "${gen_subsets}" =~ "${SUBSET}" ]]
then
    SUBSET=test
fi
echo $SUBSET
model_signature=${MODEL_SUFFIX}
log_signature=${MODEL_SUFFIX}_${SUBSET}

echo wmt19_ch_en/${log_signature}

export CUDA_VISIBLE_DEVICES=0
python ${root}/fairseq_cli/my_generate.py \
    ${root}/data-bin/wmt19_ch_en \
    --source-lang ch --target-lang en \
    --task my_translation \
    --mode at \
    --path ${root}/checkpoints/wmt19_ch_en/${model_signature}/${tag}.pt \
    --beam 5 \
    --gen-subset ${SUBSET} \
    --results-path ${root}/log/at/wmt19_ch_en/logging_${log_signature} \
    --my-results-path ${root}/output/at_output/wmt19_ch_en/temp_${log_signature}.txt

python $root/scripts/order_res.py ${$root}/output/at_output/wmt19_ch_en/temp_${log_signature}.txt
${root}/scripts/foreval_chen/eval_test19.sh ${log_signature}