/*
 * Decompiled with CFR 0.152.
 */
package utils_bk;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class FileUtils {
    public static String UTF8 = "UTF-8";
    public static String ASCII = "ASCII";
    public static String ISO88591 = "ISO-8859-1";
    public static String Treebank = "Treebank";
    public static String XML = "XML";
    public static String Pipes = "Pipes";
    public static String Plain = "Plain";
    public static String Tab = "Tab";
    public static String ApplicationPath = null;
    public static String NLPFiles_descr_path = "program-data/default-NLPFiles-descriptions/";
    public static FileFilter onlyFilesFilter = new FileFilter(){

        public boolean accept(File file) {
            return !file.isDirectory() && !file.getName().matches("\\..*");
        }
    };
    public static FileFilter onlyDirsNonAuxDirs = new FileFilter(){

        public boolean accept(File file) {
            return !file.isFile() && !file.getName().matches(".*([-_]features|\\.d)");
        }
    };
    public static Comparator fileSizeAsc = new Comparator(){

        public int compare(Object f1, Object f2) {
            if (((File)f1).length() < ((File)f2).length()) {
                return -1;
            }
            if (((File)f1).length() > ((File)f2).length()) {
                return 1;
            }
            return 0;
        }
    };
    public static Comparator fileSizeDesc = new Comparator(){

        public int compare(Object f1, Object f2) {
            if (((File)f1).length() > ((File)f2).length()) {
                return -1;
            }
            if (((File)f1).length() < ((File)f2).length()) {
                return 1;
            }
            return 0;
        }
    };

    public static String getExecutionPath() {
        try {
            return System.getProperty("user.dir");
        }
        catch (Exception e) {
            System.err.println("Errors found (FileUtils):\n\tApplication path not found: " + e.getMessage() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
            }
            return "";
        }
    }

    public static String getApplicationPath() {
        try {
            String innerpath = ApplicationPath;
            if (ApplicationPath == null) {
                URL url = FileUtils.class.getProtectionDomain().getCodeSource().getLocation();
                innerpath = new File(URLDecoder.decode(url.getFile(), "UTF-8")).getAbsolutePath();
                if (innerpath.contains(".jar")) {
                    if ((innerpath = innerpath.substring(0, innerpath.lastIndexOf(File.separator) + 1)).endsWith(File.separator + "lib" + File.separator)) {
                        innerpath = innerpath.substring(0, innerpath.length() - 4);
                    }
                } else if (innerpath.endsWith("build" + File.separator + "classes" + File.separator)) {
                    innerpath = innerpath.substring(0, innerpath.length() - 14);
                }
                if (innerpath.matches(".*Utils_BasicKit.*")) {
                    innerpath = "/home/hector/Dropbox/JApplications/TIMEE/";
                }
                ApplicationPath = innerpath;
            }
            return innerpath;
        }
        catch (Exception e) {
            System.err.println("Errors found (FileUtils):\n\tApplication path not found: " + e.getMessage() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
            }
            return "";
        }
    }

    public static void copyFileUtil(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static void copyFileUtilappend(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out, true).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static boolean deleteRecursively(File f) throws Exception {
        if (f.isDirectory()) {
            File[] aFiles;
            for (File oFileCur : aFiles = f.listFiles()) {
                FileUtils.deleteRecursively(new File(oFileCur.getAbsolutePath()));
            }
        }
        return f.delete();
    }

    public static String renameTo(String filename, String rename_re, String rename_replacement) {
        try {
            String newname = filename;
            newname = newname.replaceAll(rename_re, rename_replacement);
            File f = new File(filename);
            File f2 = new File(newname);
            if (f2.exists() && !f2.delete()) {
                throw new Exception("renameTo: destination file (" + f2 + ") exists and cannot be deleted or overwritten.");
            }
            Boolean correct = f.renameTo(new File(newname));
            if (correct.booleanValue()) {
                return newname;
            }
            throw new Exception("Error renaming");
        }
        catch (Exception e) {
            System.err.println("Errors found (FileUtils):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNLPFormat(File f) {
        String nlp_format = Plain;
        HashMap<String, Integer> scores = new HashMap<String, Integer>();
        scores.put(Treebank, 0);
        scores.put(XML, 0);
        scores.put(Pipes, 0);
        scores.put(Plain, 1);
        scores.put(Tab, 0);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            try {
                String line = null;
                int linen = 0;
                while ((line = reader.readLine()) != null && linen < 50) {
                    ++linen;
                    if ((Integer)scores.get(Pipes) != -1 && line.length() > 0) {
                        if (line.contains("|")) {
                            scores.put(Pipes, (Integer)scores.get(Pipes) + 1);
                        } else {
                            scores.put(Pipes, -1);
                        }
                    }
                    if ((Integer)scores.get(Tab) != -1 && line.length() > 0) {
                        if (line.contains("\t")) {
                            scores.put(Tab, (Integer)scores.get(Tab) + 1);
                        } else {
                            scores.put(Tab, -1);
                        }
                    }
                    if ((Integer)scores.get(Treebank) != -1 && line.matches("\\s*[^\\(\\s].*")) {
                        scores.put(Treebank, -1);
                    }
                    if ((Integer)scores.get(Treebank) != -1 && line.matches("\\s*\\(.*")) {
                        scores.put(Treebank, (Integer)scores.get(Treebank) + 1);
                    }
                    if (!line.matches(".*<(/)?[^>]+>.*")) continue;
                    scores.put(XML, (Integer)scores.get(XML) + 1);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            int highscore = 0;
            for (Map.Entry score : scores.entrySet()) {
                if ((Integer)score.getValue() <= highscore) continue;
                highscore = (Integer)score.getValue();
                nlp_format = (String)score.getKey();
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (FileUtils):\n\t" + e.toString() + ":" + e.getMessage() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
        return nlp_format;
    }

    public static String getExtension(String filename) {
        try {
            if (!filename.contains(".")) {
                throw new Exception("\tFileUtils: " + filename + " does not have extension");
            }
            return filename.substring(filename.lastIndexOf(46) + 1, filename.length());
        }
        catch (Exception e) {
            System.err.println("Errors found (FileUtils):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
            }
            return "";
        }
    }

    public static String getFolder(String f) throws IOException {
        return f.substring(0, f.lastIndexOf(47) + 1);
    }

    public static Boolean checkEncoding(File f, String encodings) {
        String encoding = FileUtils.getEncoding(f);
        if (encoding.equals(ASCII) || encodings.toUpperCase().contains(encoding)) {
            return true;
        }
        return false;
    }

    public static Boolean checkEncoding(String encoding, String encodings) {
        if (encoding.equals(ASCII) || encodings.toUpperCase().contains(encoding)) {
            return true;
        }
        return false;
    }

    public static String getEncoding(byte[] bytes) {
        int comptador = 0;
        int i = 0;
        short b = 0;
        boolean ascii = true;
        for (i = 0; i < bytes.length; ++i) {
            b = (short)(0xFF & bytes[i]);
            if (comptador > 0) {
                if (b >> 6 != 2) {
                    return ISO88591;
                }
                --comptador;
                continue;
            }
            if ((b & 0x80) <= 0) continue;
            ascii = false;
            if (b >> 5 == 6) {
                comptador = 1;
                continue;
            }
            if (b >> 4 == 14) {
                comptador = 2;
                continue;
            }
            if (b >> 3 == 30) {
                comptador = 3;
                continue;
            }
            return ISO88591;
        }
        return ascii ? ASCII : UTF8;
    }

    public static String getEncoding(File f) {
        return FileUtils.getEncoding(FileUtils.file2bytes(f));
    }

    public static String bytes2file(byte[] b, String filename) {
        String ret;
        block4: {
            ret = null;
            try {
                File f = new File(filename);
                if (f.exists()) {
                    throw new IOException("\n\n\tError: file " + filename + " already exists");
                }
                f = null;
                ret = filename;
                FileOutputStream fw = new FileOutputStream(ret);
                if (b != null) {
                    fw.write(b);
                }
                fw.close();
            }
            catch (Exception e) {
                System.err.println("Errors found (FileUtils):\n\t" + e.getMessage() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block4;
                e.printStackTrace(System.err);
            }
        }
        return ret;
    }

    public static byte[] file2bytes(File f) {
        try {
            int rc;
            FileInputStream fi = new FileInputStream(f);
            ArrayList<Byte> bytes = new ArrayList<Byte>();
            while ((rc = fi.read()) > -1) {
                byte c = (byte)(rc & 0xFF);
                bytes.add(c);
            }
            fi.close();
            int bsize = bytes.size();
            byte[] rbytes = new byte[bsize];
            for (int i = 0; i < bsize; ++i) {
                rbytes[i] = (Byte)bytes.get(i);
            }
            return rbytes;
        }
        catch (Exception e) {
            System.err.println("Errors found (FileUtils):\n\t" + e.getMessage() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String fileName, String charsetName) throws IOException {
        FileInputStream is = new FileInputStream(fileName);
        try {
            int bufsize = 4096;
            int available = ((InputStream)is).available();
            byte[] data = new byte[available < 4096 ? 4096 : available];
            int used = 0;
            while (true) {
                int got;
                if (data.length - used < 4096) {
                    byte[] newData = new byte[data.length << 1];
                    System.arraycopy(data, 0, newData, 0, used);
                    data = newData;
                }
                if ((got = ((InputStream)is).read(data, used, data.length - used)) <= 0) break;
                used += got;
            }
            String string = charsetName != null ? new String(data, 0, used, charsetName) : new String(data, 0, used);
            return string;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String fileName, String charsetName, int size) throws IOException {
        FileInputStream f = new FileInputStream(fileName);
        try {
            int readsize = (int)new File(fileName).length();
            if (size < readsize) {
                readsize = size;
            }
            byte[] buffer = new byte[readsize];
            f.read(buffer);
            String string = charsetName != null ? new String(buffer, charsetName) : new String(buffer);
            return string;
        }
        finally {
            f.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileFromString(String str, String fileName) throws IOException {
        OutputStreamWriter of = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(fileName))), Charset.forName("UTF8"));
        try {
            of.write(str);
        }
        finally {
            of.close();
        }
    }
}

