import numpy as np

def load_data(infile):
    data = []
    with open(infile,'r') as lines:
        batch = []
        for line in lines:
            if line.strip() == '':
                data.append(batch[:])
                batch = []
                continue
            splits = line.strip().split(',')
            tok_id = splits[5]
            label = float(splits[-1])
            del splits[5]
            del splits[-1]
            feat = [float(x) for x in splits]
            batch.append((tok_id,get_label(label),np.array(feat)))
    return data


def get_label(elem):
    if elem < 0.25:
        return 0
    elif elem < 0.5:
        return 1
    elif elem < 0.75:
        return 2
    else:
        return 3
