%Compute the matrix representation of the cross product
%function [V,vShift] = essential_hat3(v)
%V is a [3x3xN] array of skew-symmetric matrices where each [3x3] block is
%the matrix representation of the cross product of one of the columns of v
%vShift is equal to permute(v,[1 3 2]).
function [V, vShift] = essential_hat3(v)
    N = size(v,2);
    V = zeros(3,3,N);
    vShift = permute(v,[1 3 2]);
    V(1,2,:) = -vShift(3,:,:);
    V(2,1,:) = vShift(3,:,:);
    V(1,3,:) = vShift(2,:,:);
    V(3,1,:) = -vShift(2,:,:);
    V(2,3,:) = -vShift(1,:,:);
    V(3,2,:) = vShift(1,:,:);
end