/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.tiff;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFDecodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFDirectory;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFFaxDecoder;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFField;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFLZWDecoder;
import org.apache.batik.ext.awt.image.codec.util.SeekableStream;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class TIFFImage
extends AbstractRed {
    public static final int COMP_NONE = 1;
    public static final int COMP_FAX_G3_1D = 2;
    public static final int COMP_FAX_G3_2D = 3;
    public static final int COMP_FAX_G4_2D = 4;
    public static final int COMP_LZW = 5;
    public static final int COMP_JPEG_OLD = 6;
    public static final int COMP_JPEG_TTN2 = 7;
    public static final int COMP_PACKBITS = 32773;
    public static final int COMP_DEFLATE = 32946;
    private static final int TYPE_UNSUPPORTED = -1;
    private static final int TYPE_BILEVEL = 0;
    private static final int TYPE_GRAY_4BIT = 1;
    private static final int TYPE_GRAY = 2;
    private static final int TYPE_GRAY_ALPHA = 3;
    private static final int TYPE_PALETTE = 4;
    private static final int TYPE_RGB = 5;
    private static final int TYPE_RGB_ALPHA = 6;
    private static final int TYPE_YCBCR_SUB = 7;
    private static final int TYPE_GENERIC = 8;
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    SeekableStream stream;
    int tileSize;
    int tilesX;
    int tilesY;
    long[] tileOffsets;
    long[] tileByteCounts;
    char[] colormap;
    int sampleSize;
    int compression;
    byte[] palette;
    int numBands;
    int chromaSubH;
    int chromaSubV;
    long tiffT4Options;
    long tiffT6Options;
    int fillOrder;
    int predictor;
    JPEGDecodeParam decodeParam = null;
    boolean colorConvertJPEG = false;
    Inflater inflater = null;
    boolean isBigEndian;
    int imageType;
    boolean isWhiteZero = false;
    int dataType;
    boolean decodePaletteAsShorts;
    boolean tiled;
    private TIFFFaxDecoder decoder = null;
    private TIFFLZWDecoder lzwDecoder = null;

    private static final Raster decodeJPEG(byte[] data, JPEGDecodeParam decodeParam, boolean colorConvert, int minX, int minY) {
        Raster jpegRaster;
        ByteArrayInputStream jpegStream = new ByteArrayInputStream(data);
        JPEGImageDecoder decoder = decodeParam == null ? JPEGCodec.createJPEGDecoder((InputStream)jpegStream) : JPEGCodec.createJPEGDecoder((InputStream)jpegStream, (JPEGDecodeParam)decodeParam);
        try {
            jpegRaster = colorConvert ? decoder.decodeAsBufferedImage().getWritableTile(0, 0) : decoder.decodeAsRaster();
        }
        catch (IOException ioe) {
            throw new RuntimeException("TIFFImage13");
        }
        return jpegRaster.createTranslatedChild(minX, minY);
    }

    private final void inflate(byte[] deflated, byte[] inflated) {
        this.inflater.setInput(deflated);
        try {
            this.inflater.inflate(inflated);
        }
        catch (DataFormatException dfe) {
            throw new RuntimeException("TIFFImage17: " + dfe.getMessage());
        }
        this.inflater.reset();
    }

    private static SampleModel createPixelInterleavedSampleModel(int dataType, int tileWidth, int tileHeight, int bands) {
        int[] bandOffsets = new int[bands];
        int i = 0;
        while (i < bands) {
            bandOffsets[i] = i;
            ++i;
        }
        return new PixelInterleavedSampleModel(dataType, tileWidth, tileHeight, bands, tileWidth * bands, bandOffsets);
    }

    private long[] getFieldAsLongs(TIFFField field) {
        long[] value = null;
        if (field.getType() == 3) {
            char[] charValue = field.getAsChars();
            value = new long[charValue.length];
            int i = 0;
            while (i < charValue.length) {
                value[i] = charValue[i] & 0xFFFF;
                ++i;
            }
        } else if (field.getType() == 4) {
            value = field.getAsLongs();
        } else {
            throw new RuntimeException();
        }
        return value;
    }

    public TIFFImage(SeekableStream stream, TIFFDecodeParam param, int directory) throws IOException {
        int tileHeight;
        int tileWidth;
        int extraSamples;
        char[] planarConfiguration;
        char[] cArray;
        this.stream = stream;
        if (param == null) {
            param = new TIFFDecodeParam();
        }
        this.decodePaletteAsShorts = param.getDecodePaletteAsShorts();
        TIFFDirectory dir = param.getIFDOffset() == null ? new TIFFDirectory(stream, directory) : new TIFFDirectory(stream, param.getIFDOffset(), directory);
        TIFFField sfield = dir.getField(277);
        int samplesPerPixel = sfield == null ? 1 : (int)sfield.getAsLong(0);
        TIFFField planarConfigurationField = dir.getField(284);
        if (planarConfigurationField == null) {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = '\u0001';
        } else {
            cArray = planarConfiguration = planarConfigurationField.getAsChars();
        }
        if (planarConfiguration[0] != '\u0001' && samplesPerPixel != 1) {
            throw new RuntimeException("TIFFImage0");
        }
        TIFFField bitsField = dir.getField(258);
        char[] bitsPerSample = null;
        if (bitsField != null) {
            bitsPerSample = bitsField.getAsChars();
        } else {
            bitsPerSample = new char[]{'\u0001'};
            int i = 1;
            while (i < bitsPerSample.length) {
                if (bitsPerSample[i] != bitsPerSample[0]) {
                    throw new RuntimeException("TIFFImage1");
                }
                ++i;
            }
        }
        this.sampleSize = bitsPerSample[0];
        TIFFField sampleFormatField = dir.getField(339);
        char[] sampleFormat = null;
        if (sampleFormatField != null) {
            sampleFormat = sampleFormatField.getAsChars();
            int l = 1;
            while (l < sampleFormat.length) {
                if (sampleFormat[l] != sampleFormat[0]) {
                    throw new RuntimeException("TIFFImage2");
                }
                ++l;
            }
        } else {
            sampleFormat = new char[]{'\u0001'};
        }
        boolean isValidDataFormat = false;
        switch (this.sampleSize) {
            case 1: 
            case 4: 
            case 8: {
                if (sampleFormat[0] == '\u0003') break;
                this.dataType = 0;
                isValidDataFormat = true;
                break;
            }
            case 16: {
                if (sampleFormat[0] == '\u0003') break;
                this.dataType = sampleFormat[0] == '\u0002' ? 2 : 1;
                isValidDataFormat = true;
                break;
            }
            case 32: {
                if (sampleFormat[0] == '\u0003') {
                    isValidDataFormat = false;
                    break;
                }
                this.dataType = 3;
                isValidDataFormat = true;
            }
        }
        if (!isValidDataFormat) {
            throw new RuntimeException("TIFFImage3");
        }
        TIFFField compField = dir.getField(259);
        this.compression = compField == null ? 1 : compField.getAsInt(0);
        int photometricType = (int)dir.getFieldAsLong(262);
        this.imageType = -1;
        switch (photometricType) {
            case 0: {
                this.isWhiteZero = true;
            }
            case 1: {
                if (this.sampleSize == 1 && samplesPerPixel == 1) {
                    this.imageType = 0;
                    break;
                }
                if (this.sampleSize == 4 && samplesPerPixel == 1) {
                    this.imageType = 1;
                    break;
                }
                if (this.sampleSize % 8 != 0) break;
                if (samplesPerPixel == 1) {
                    this.imageType = 2;
                    break;
                }
                if (samplesPerPixel == 2) {
                    this.imageType = 3;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 2: {
                if (this.sampleSize % 8 != 0) break;
                if (samplesPerPixel == 3) {
                    this.imageType = 5;
                    break;
                }
                if (samplesPerPixel == 4) {
                    this.imageType = 6;
                    break;
                }
                this.imageType = 8;
                break;
            }
            case 3: {
                if (samplesPerPixel != true || this.sampleSize != 4 && this.sampleSize != 8 && this.sampleSize != 16) break;
                this.imageType = 4;
                break;
            }
            case 4: {
                if (this.sampleSize != 1 || samplesPerPixel != true) break;
                this.imageType = 0;
                break;
            }
            case 6: {
                if (this.compression == 7 && this.sampleSize == 8 && samplesPerPixel == 3) {
                    this.colorConvertJPEG = param.getJPEGDecompressYCbCrToRGB();
                    this.imageType = this.colorConvertJPEG ? 5 : 8;
                    break;
                }
                TIFFField chromaField = dir.getField(530);
                if (chromaField != null) {
                    this.chromaSubH = chromaField.getAsInt(0);
                    this.chromaSubV = chromaField.getAsInt(1);
                } else {
                    this.chromaSubV = 2;
                    this.chromaSubH = 2;
                }
                if (this.chromaSubH * this.chromaSubV == 1) {
                    this.imageType = 8;
                    break;
                }
                if (this.sampleSize != 8 || samplesPerPixel != 3) break;
                this.imageType = 7;
                break;
            }
            default: {
                if (this.sampleSize % 8 != 0) break;
                this.imageType = 8;
            }
        }
        if (this.imageType == -1) {
            throw new RuntimeException("TIFFImage4");
        }
        Rectangle bounds = new Rectangle(0, 0, (int)dir.getFieldAsLong(256), (int)dir.getFieldAsLong(257));
        this.numBands = samplesPerPixel;
        TIFFField efield = dir.getField(338);
        int n = extraSamples = efield == null ? 0 : (int)efield.getAsLong(0);
        if (dir.getField(324) != null) {
            this.tiled = true;
            tileWidth = (int)dir.getFieldAsLong(322);
            tileHeight = (int)dir.getFieldAsLong(323);
            this.tileOffsets = dir.getField(324).getAsLongs();
            this.tileByteCounts = this.getFieldAsLongs(dir.getField(325));
        } else {
            this.tiled = false;
            tileWidth = dir.getField(322) != null ? (int)dir.getFieldAsLong(322) : bounds.width;
            TIFFField field = dir.getField(278);
            if (field == null) {
                tileHeight = dir.getField(323) != null ? (int)dir.getFieldAsLong(323) : bounds.height;
            } else {
                long l = field.getAsLong(0);
                long infinity = 1L;
                tileHeight = l == (infinity = (infinity << 32) - 1L) ? bounds.height : (int)l;
            }
            TIFFField tileOffsetsField = dir.getField(273);
            if (tileOffsetsField == null) {
                throw new RuntimeException("TIFFImage5");
            }
            this.tileOffsets = this.getFieldAsLongs(tileOffsetsField);
            TIFFField tileByteCountsField = dir.getField(279);
            if (tileByteCountsField == null) {
                throw new RuntimeException("TIFFImage6");
            }
            this.tileByteCounts = this.getFieldAsLongs(tileByteCountsField);
        }
        this.tilesX = (bounds.width + tileWidth - 1) / tileWidth;
        this.tilesY = (bounds.height + tileHeight - 1) / tileHeight;
        this.tileSize = tileWidth * tileHeight * this.numBands;
        this.isBigEndian = dir.isBigEndian();
        TIFFField fillOrderField = dir.getField(266);
        this.fillOrder = fillOrderField != null ? fillOrderField.getAsInt(0) : 1;
        switch (this.compression) {
            case 1: 
            case 32773: {
                break;
            }
            case 32946: {
                this.inflater = new Inflater();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.sampleSize != 1) {
                    throw new RuntimeException("TIFFImage7");
                }
                if (this.compression == 3) {
                    TIFFField t4OptionsField = dir.getField(292);
                    this.tiffT4Options = t4OptionsField != null ? t4OptionsField.getAsLong(0) : 0L;
                }
                if (this.compression == 4) {
                    TIFFField t6OptionsField = dir.getField(293);
                    this.tiffT6Options = t6OptionsField != null ? t6OptionsField.getAsLong(0) : 0L;
                }
                this.decoder = new TIFFFaxDecoder(this.fillOrder, tileWidth, tileHeight);
                break;
            }
            case 5: {
                TIFFField predictorField = dir.getField(317);
                if (predictorField == null) {
                    this.predictor = 1;
                } else {
                    this.predictor = predictorField.getAsInt(0);
                    if (this.predictor != 1 && this.predictor != 2) {
                        throw new RuntimeException("TIFFImage8");
                    }
                    if (this.predictor == 2 && this.sampleSize != 8) {
                        throw new RuntimeException(this.sampleSize + "TIFFImage9");
                    }
                }
                this.lzwDecoder = new TIFFLZWDecoder(tileWidth, this.predictor, samplesPerPixel);
                break;
            }
            case 6: {
                throw new RuntimeException("TIFFImage15");
            }
            case 7: {
                if (!(this.sampleSize == 8 && (this.imageType == 2 && samplesPerPixel == 1 || this.imageType == 4 && samplesPerPixel == 1 || this.imageType == 5 && samplesPerPixel == 3))) {
                    throw new RuntimeException("TIFFImage16");
                }
                if (!dir.isTagPresent(347)) break;
                TIFFField jpegTableField = dir.getField(347);
                byte[] jpegTable = jpegTableField.getAsBytes();
                ByteArrayInputStream tableStream = new ByteArrayInputStream(jpegTable);
                JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)tableStream);
                decoder.decodeAsRaster();
                this.decodeParam = decoder.getJPEGDecodeParam();
                break;
            }
            default: {
                throw new RuntimeException("TIFFImage10");
            }
        }
        ColorModel colorModel = null;
        SampleModel sampleModel = null;
        switch (this.imageType) {
            case 0: 
            case 1: {
                byte[] map;
                sampleModel = new MultiPixelPackedSampleModel(this.dataType, tileWidth, tileHeight, this.sampleSize);
                if (this.imageType == 0) {
                    map = new byte[]{this.isWhiteZero ? (byte)-1 : 0, this.isWhiteZero ? (byte)0 : -1};
                    colorModel = new IndexColorModel(1, 2, map, map, map);
                    break;
                }
                map = new byte[16];
                if (this.isWhiteZero) {
                    int i = 0;
                    while (i < map.length) {
                        map[i] = (byte)(255 - 16 * i);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < map.length) {
                        map[i] = (byte)(16 * i);
                        ++i;
                    }
                }
                colorModel = new IndexColorModel(4, 16, map, map, map);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                int[] reverseOffsets = new int[this.numBands];
                int i = 0;
                while (i < this.numBands) {
                    reverseOffsets[i] = this.numBands - 1 - i;
                    ++i;
                }
                sampleModel = new PixelInterleavedSampleModel(this.dataType, tileWidth, tileHeight, this.numBands, this.numBands * tileWidth, reverseOffsets);
                if (this.imageType == 2) {
                    colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{this.sampleSize}, false, false, 1, this.dataType);
                    break;
                }
                if (this.imageType == 5) {
                    colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{this.sampleSize, this.sampleSize, this.sampleSize}, false, false, 1, this.dataType);
                    break;
                }
                int transparency = 1;
                if (extraSamples == 1) {
                    transparency = 3;
                } else if (extraSamples == 2) {
                    transparency = 2;
                }
                colorModel = this.createAlphaComponentColorModel(this.dataType, this.numBands, extraSamples == 1, transparency);
                break;
            }
            case 7: 
            case 8: {
                int[] bandOffsets = new int[this.numBands];
                int i = 0;
                while (i < this.numBands) {
                    bandOffsets[i] = i;
                    ++i;
                }
                sampleModel = new PixelInterleavedSampleModel(this.dataType, tileWidth, tileHeight, this.numBands, this.numBands * tileWidth, bandOffsets);
                colorModel = null;
                break;
            }
            case 4: {
                TIFFField cfield = dir.getField(320);
                if (cfield == null) {
                    throw new RuntimeException("TIFFImage11");
                }
                this.colormap = cfield.getAsChars();
                if (this.decodePaletteAsShorts) {
                    this.numBands = 3;
                    if (this.dataType == 0) {
                        this.dataType = 1;
                    }
                    sampleModel = TIFFImage.createPixelInterleavedSampleModel(this.dataType, tileWidth, tileHeight, this.numBands);
                    colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{16, 16, 16}, false, false, 1, this.dataType);
                    break;
                }
                this.numBands = 1;
                if (this.sampleSize == 4) {
                    sampleModel = new MultiPixelPackedSampleModel(0, tileWidth, tileHeight, this.sampleSize);
                } else if (this.sampleSize == 8) {
                    sampleModel = TIFFImage.createPixelInterleavedSampleModel(0, tileWidth, tileHeight, this.numBands);
                } else if (this.sampleSize == 16) {
                    this.dataType = 1;
                    sampleModel = TIFFImage.createPixelInterleavedSampleModel(1, tileWidth, tileHeight, this.numBands);
                }
                int bandLength = this.colormap.length / 3;
                byte[] r = new byte[bandLength];
                byte[] g = new byte[bandLength];
                byte[] b = new byte[bandLength];
                int gIndex = bandLength;
                int bIndex = bandLength * 2;
                if (this.dataType == 2) {
                    int i = 0;
                    while (i < bandLength) {
                        r[i] = param.decodeSigned16BitsTo8Bits((short)this.colormap[i]);
                        g[i] = param.decodeSigned16BitsTo8Bits((short)this.colormap[gIndex + i]);
                        b[i] = param.decodeSigned16BitsTo8Bits((short)this.colormap[bIndex + i]);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < bandLength) {
                        r[i] = param.decode16BitsTo8Bits(this.colormap[i] & 0xFFFF);
                        g[i] = param.decode16BitsTo8Bits(this.colormap[gIndex + i] & 0xFFFF);
                        b[i] = param.decode16BitsTo8Bits(this.colormap[bIndex + i] & 0xFFFF);
                        ++i;
                    }
                }
                colorModel = new IndexColorModel(this.sampleSize, bandLength, r, g, b);
                break;
            }
            default: {
                throw new RuntimeException("TIFFImage4");
            }
        }
        HashMap<String, TIFFDirectory> properties = new HashMap<String, TIFFDirectory>();
        properties.put("tiff_directory", dir);
        this.init((CachableRed)null, bounds, colorModel, sampleModel, 0, 0, properties);
    }

    public TIFFDirectory getPrivateIFD(long offset) throws IOException {
        return new TIFFDirectory(this.stream, offset, 0);
    }

    public WritableRaster copyData(WritableRaster wr) {
        this.copyToRaster(wr);
        return wr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Raster getTile(int tileX, int tileY) {
        byte[] data;
        if (tileX < 0 || tileX >= this.tilesX || tileY < 0 || tileY >= this.tilesY) {
            throw new IllegalArgumentException("TIFFImage12");
        }
        byte[] bdata = null;
        short[] sdata = null;
        int[] idata = null;
        SampleModel sampleModel = this.getSampleModel();
        WritableRaster tile = this.makeTile(tileX, tileY);
        DataBuffer buffer = tile.getDataBuffer();
        int dataType = sampleModel.getDataType();
        if (dataType == 0) {
            bdata = ((DataBufferByte)buffer).getData();
        } else if (dataType == 1) {
            sdata = ((DataBufferUShort)buffer).getData();
        } else if (dataType == 2) {
            sdata = ((DataBufferShort)buffer).getData();
        } else if (dataType == 3) {
            idata = ((DataBufferInt)buffer).getData();
        }
        long save_offset = 0L;
        try {
            save_offset = this.stream.getFilePointer();
            this.stream.seek(this.tileOffsets[tileY * this.tilesX + tileX]);
        }
        catch (IOException ioe) {
            throw new RuntimeException("TIFFImage13");
        }
        int byteCount = (int)this.tileByteCounts[tileY * this.tilesX + tileX];
        Rectangle newRect = !this.tiled ? tile.getBounds() : new Rectangle(tile.getMinX(), tile.getMinY(), this.tileWidth, this.tileHeight);
        int unitsInThisTile = newRect.width * newRect.height * this.numBands;
        Object object = data = (Object)(this.compression != 1 || this.imageType == 4 ? new byte[byteCount] : null);
        if (this.imageType == 0) {
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(data, 0, byteCount);
                    int bytesInThisTile = newRect.width % 8 == 0 ? newRect.width / 8 * newRect.height : (newRect.width / 8 + 1) * newRect.height;
                    this.decodePackbits(data, bytesInThisTile, bdata);
                } else if (this.compression == 5) {
                    this.stream.readFully(data, 0, byteCount);
                    this.lzwDecoder.decode(data, bdata, newRect.height);
                } else if (this.compression == 2) {
                    this.stream.readFully(data, 0, byteCount);
                    this.decoder.decode1D(bdata, data, 0, newRect.height);
                } else if (this.compression == 3) {
                    this.stream.readFully(data, 0, byteCount);
                    this.decoder.decode2D(bdata, data, 0, newRect.height, this.tiffT4Options);
                } else if (this.compression == 4) {
                    this.stream.readFully(data, 0, byteCount);
                    this.decoder.decodeT6(bdata, data, 0, newRect.height, this.tiffT6Options);
                } else if (this.compression == 32946) {
                    this.stream.readFully(data, 0, byteCount);
                    this.inflate(data, bdata);
                } else if (this.compression == 1) {
                    this.stream.readFully(bdata, 0, byteCount);
                }
                this.stream.seek(save_offset);
                return tile;
            }
            catch (IOException ioe) {
                throw new RuntimeException("TIFFImage13");
            }
        }
        if (this.imageType == 4) {
            if (this.sampleSize == 16) {
                if (this.decodePaletteAsShorts) {
                    short[] tempData = null;
                    int unitsBeforeLookup = unitsInThisTile / 3;
                    int entries = unitsBeforeLookup * 2;
                    try {
                        byte[] byteArray;
                        if (this.compression == 32773) {
                            this.stream.readFully(data, 0, byteCount);
                            byteArray = new byte[entries];
                            this.decodePackbits(data, entries, byteArray);
                            tempData = new short[unitsBeforeLookup];
                            this.interpretBytesAsShorts(byteArray, tempData, unitsBeforeLookup);
                        } else if (this.compression == 5) {
                            this.stream.readFully(data, 0, byteCount);
                            byteArray = new byte[entries];
                            this.lzwDecoder.decode(data, byteArray, newRect.height);
                            tempData = new short[unitsBeforeLookup];
                            this.interpretBytesAsShorts(byteArray, tempData, unitsBeforeLookup);
                        } else if (this.compression == 32946) {
                            this.stream.readFully(data, 0, byteCount);
                            byteArray = new byte[entries];
                            this.inflate(data, byteArray);
                            tempData = new short[unitsBeforeLookup];
                            this.interpretBytesAsShorts(byteArray, tempData, unitsBeforeLookup);
                        } else if (this.compression == 1) {
                            tempData = new short[byteCount / 2];
                            this.readShorts(byteCount / 2, tempData);
                        }
                        this.stream.seek(save_offset);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("TIFFImage13");
                    }
                    if (dataType == 1) {
                        int count = 0;
                        int len = this.colormap.length / 3;
                        int len2 = len * 2;
                        int i = 0;
                        while (i < unitsBeforeLookup) {
                            int lookup = tempData[i] & 0xFFFF;
                            char cmapValue = this.colormap[lookup + len2];
                            sdata[count++] = (short)(cmapValue & 0xFFFF);
                            cmapValue = this.colormap[lookup + len];
                            sdata[count++] = (short)(cmapValue & 0xFFFF);
                            cmapValue = this.colormap[lookup];
                            sdata[count++] = (short)(cmapValue & 0xFFFF);
                            ++i;
                        }
                        return tile;
                    } else {
                        if (dataType != 2) return tile;
                        int count = 0;
                        int len = this.colormap.length / 3;
                        int len2 = len * 2;
                        int i = 0;
                        while (i < unitsBeforeLookup) {
                            int lookup = tempData[i] & 0xFFFF;
                            char cmapValue = this.colormap[lookup + len2];
                            sdata[count++] = (short)cmapValue;
                            cmapValue = this.colormap[lookup + len];
                            sdata[count++] = (short)cmapValue;
                            cmapValue = this.colormap[lookup];
                            sdata[count++] = (short)cmapValue;
                            ++i;
                        }
                    }
                    return tile;
                }
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(data, 0, byteCount);
                        int bytesInThisTile = unitsInThisTile * 2;
                        byte[] byteArray = new byte[bytesInThisTile];
                        this.decodePackbits(data, bytesInThisTile, byteArray);
                        this.interpretBytesAsShorts(byteArray, sdata, unitsInThisTile);
                    } else if (this.compression == 5) {
                        this.stream.readFully(data, 0, byteCount);
                        byte[] byteArray = new byte[unitsInThisTile * 2];
                        this.lzwDecoder.decode(data, byteArray, newRect.height);
                        this.interpretBytesAsShorts(byteArray, sdata, unitsInThisTile);
                    } else if (this.compression == 32946) {
                        this.stream.readFully(data, 0, byteCount);
                        byte[] byteArray = new byte[unitsInThisTile * 2];
                        this.inflate(data, byteArray);
                        this.interpretBytesAsShorts(byteArray, sdata, unitsInThisTile);
                    } else if (this.compression == 1) {
                        this.readShorts(byteCount / 2, sdata);
                    }
                    this.stream.seek(save_offset);
                    return tile;
                }
                catch (IOException ioe) {
                    throw new RuntimeException("TIFFImage13");
                }
            }
            if (this.sampleSize == 8) {
                if (this.decodePaletteAsShorts) {
                    byte[] tempData = null;
                    int unitsBeforeLookup = unitsInThisTile / 3;
                    try {
                        if (this.compression == 32773) {
                            this.stream.readFully(data, 0, byteCount);
                            tempData = new byte[unitsBeforeLookup];
                            this.decodePackbits(data, unitsBeforeLookup, tempData);
                        } else if (this.compression == 5) {
                            this.stream.readFully(data, 0, byteCount);
                            tempData = new byte[unitsBeforeLookup];
                            this.lzwDecoder.decode(data, tempData, newRect.height);
                        } else if (this.compression == 7) {
                            this.stream.readFully(data, 0, byteCount);
                            Raster tempTile = TIFFImage.decodeJPEG(data, this.decodeParam, this.colorConvertJPEG, tile.getMinX(), tile.getMinY());
                            int[] tempPixels = new int[unitsBeforeLookup];
                            tempTile.getPixels(tile.getMinX(), tile.getMinY(), tile.getWidth(), tile.getHeight(), tempPixels);
                            tempData = new byte[unitsBeforeLookup];
                            int i = 0;
                            while (i < unitsBeforeLookup) {
                                tempData[i] = (byte)tempPixels[i];
                                ++i;
                            }
                        } else if (this.compression == 32946) {
                            this.stream.readFully(data, 0, byteCount);
                            tempData = new byte[unitsBeforeLookup];
                            this.inflate(data, tempData);
                        } else if (this.compression == 1) {
                            tempData = new byte[byteCount];
                            this.stream.readFully(tempData, 0, byteCount);
                        }
                        this.stream.seek(save_offset);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("TIFFImage13");
                    }
                    int count = 0;
                    int len = this.colormap.length / 3;
                    int len2 = len * 2;
                    int i = 0;
                    while (i < unitsBeforeLookup) {
                        int lookup = tempData[i] & 0xFF;
                        char cmapValue = this.colormap[lookup + len2];
                        sdata[count++] = (short)(cmapValue & 0xFFFF);
                        cmapValue = this.colormap[lookup + len];
                        sdata[count++] = (short)(cmapValue & 0xFFFF);
                        cmapValue = this.colormap[lookup];
                        sdata[count++] = (short)(cmapValue & 0xFFFF);
                        ++i;
                    }
                    return tile;
                }
                try {
                    if (this.compression == 32773) {
                        this.stream.readFully(data, 0, byteCount);
                        this.decodePackbits(data, unitsInThisTile, bdata);
                    } else if (this.compression == 5) {
                        this.stream.readFully(data, 0, byteCount);
                        this.lzwDecoder.decode(data, bdata, newRect.height);
                    } else if (this.compression == 7) {
                        this.stream.readFully(data, 0, byteCount);
                        tile.setRect(TIFFImage.decodeJPEG(data, this.decodeParam, this.colorConvertJPEG, tile.getMinX(), tile.getMinY()));
                    } else if (this.compression == 32946) {
                        this.stream.readFully(data, 0, byteCount);
                        this.inflate(data, bdata);
                    } else if (this.compression == 1) {
                        this.stream.readFully(bdata, 0, byteCount);
                    }
                    this.stream.seek(save_offset);
                    return tile;
                }
                catch (IOException ioe) {
                    throw new RuntimeException("TIFFImage13");
                }
            }
            if (this.sampleSize != 4) return tile;
            int padding = newRect.width % 2 == 0 ? 0 : 1;
            int bytesPostDecoding = (newRect.width / 2 + padding) * newRect.height;
            if (this.decodePaletteAsShorts) {
                byte[] tempData = null;
                try {
                    this.stream.readFully(data, 0, byteCount);
                    this.stream.seek(save_offset);
                }
                catch (IOException ioe) {
                    throw new RuntimeException("TIFFImage13");
                }
                if (this.compression == 32773) {
                    tempData = new byte[bytesPostDecoding];
                    this.decodePackbits(data, bytesPostDecoding, tempData);
                } else if (this.compression == 5) {
                    tempData = new byte[bytesPostDecoding];
                    this.lzwDecoder.decode(data, tempData, newRect.height);
                } else if (this.compression == 32946) {
                    tempData = new byte[bytesPostDecoding];
                    this.inflate(data, tempData);
                } else if (this.compression == 1) {
                    tempData = data;
                }
                int bytes = unitsInThisTile / 3;
                data = new byte[bytes];
                int srcCount = 0;
                int dstCount = 0;
                int j = 0;
                while (j < newRect.height) {
                    int i = 0;
                    while (i < newRect.width / 2) {
                        data[dstCount++] = (byte)((tempData[srcCount] & 0xF0) >> 4);
                        data[dstCount++] = (byte)(tempData[srcCount++] & 0xF);
                        ++i;
                    }
                    if (padding == 1) {
                        data[dstCount++] = (byte)((tempData[srcCount++] & 0xF0) >> 4);
                    }
                    ++j;
                }
                int len = this.colormap.length / 3;
                int len2 = len * 2;
                int count = 0;
                int i = 0;
                while (i < bytes) {
                    int lookup = data[i] & 0xFF;
                    char cmapValue = this.colormap[lookup + len2];
                    sdata[count++] = (short)(cmapValue & 0xFFFF);
                    cmapValue = this.colormap[lookup + len];
                    sdata[count++] = (short)(cmapValue & 0xFFFF);
                    cmapValue = this.colormap[lookup];
                    sdata[count++] = (short)(cmapValue & 0xFFFF);
                    ++i;
                }
                return tile;
            }
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(data, 0, byteCount);
                    this.decodePackbits(data, bytesPostDecoding, bdata);
                } else if (this.compression == 5) {
                    this.stream.readFully(data, 0, byteCount);
                    this.lzwDecoder.decode(data, bdata, newRect.height);
                } else if (this.compression == 32946) {
                    this.stream.readFully(data, 0, byteCount);
                    this.inflate(data, bdata);
                } else if (this.compression == 1) {
                    this.stream.readFully(bdata, 0, byteCount);
                }
                this.stream.seek(save_offset);
                return tile;
            }
            catch (IOException ioe) {
                throw new RuntimeException("TIFFImage13");
            }
        }
        if (this.imageType == 1) {
            try {
                if (this.compression == 32773) {
                    this.stream.readFully(data, 0, byteCount);
                    int bytesInThisTile = newRect.width % 8 == 0 ? newRect.width / 2 * newRect.height : (newRect.width / 2 + 1) * newRect.height;
                    this.decodePackbits(data, bytesInThisTile, bdata);
                } else if (this.compression == 5) {
                    this.stream.readFully(data, 0, byteCount);
                    this.lzwDecoder.decode(data, bdata, newRect.height);
                } else if (this.compression == 32946) {
                    this.stream.readFully(data, 0, byteCount);
                    this.inflate(data, bdata);
                } else {
                    this.stream.readFully(bdata, 0, byteCount);
                }
                this.stream.seek(save_offset);
                return tile;
            }
            catch (IOException ioe) {
                throw new RuntimeException("TIFFImage13");
            }
        }
        try {
            byte[] byteArray;
            if (this.sampleSize == 8) {
                if (this.compression == 1) {
                    this.stream.readFully(bdata, 0, byteCount);
                } else if (this.compression == 5) {
                    this.stream.readFully(data, 0, byteCount);
                    this.lzwDecoder.decode(data, bdata, newRect.height);
                } else if (this.compression == 32773) {
                    this.stream.readFully(data, 0, byteCount);
                    this.decodePackbits(data, unitsInThisTile, bdata);
                } else if (this.compression == 7) {
                    this.stream.readFully(data, 0, byteCount);
                    tile.setRect(TIFFImage.decodeJPEG(data, this.decodeParam, this.colorConvertJPEG, tile.getMinX(), tile.getMinY()));
                } else if (this.compression == 32946) {
                    this.stream.readFully(data, 0, byteCount);
                    this.inflate(data, bdata);
                }
            } else if (this.sampleSize == 16) {
                if (this.compression == 1) {
                    this.readShorts(byteCount / 2, sdata);
                } else if (this.compression == 5) {
                    this.stream.readFully(data, 0, byteCount);
                    byte[] byteArray2 = new byte[unitsInThisTile * 2];
                    this.lzwDecoder.decode(data, byteArray2, newRect.height);
                    this.interpretBytesAsShorts(byteArray2, sdata, unitsInThisTile);
                } else if (this.compression == 32773) {
                    this.stream.readFully(data, 0, byteCount);
                    int bytesInThisTile = unitsInThisTile * 2;
                    byteArray = new byte[bytesInThisTile];
                    this.decodePackbits(data, bytesInThisTile, byteArray);
                    this.interpretBytesAsShorts(byteArray, sdata, unitsInThisTile);
                } else if (this.compression == 32946) {
                    this.stream.readFully(data, 0, byteCount);
                    byte[] byteArray3 = new byte[unitsInThisTile * 2];
                    this.inflate(data, byteArray3);
                    this.interpretBytesAsShorts(byteArray3, sdata, unitsInThisTile);
                }
            } else if (this.sampleSize == 32 && dataType == 3) {
                if (this.compression == 1) {
                    this.readInts(byteCount / 4, idata);
                } else if (this.compression == 5) {
                    this.stream.readFully(data, 0, byteCount);
                    byte[] byteArray4 = new byte[unitsInThisTile * 4];
                    this.lzwDecoder.decode(data, byteArray4, newRect.height);
                    this.interpretBytesAsInts(byteArray4, idata, unitsInThisTile);
                } else if (this.compression == 32773) {
                    this.stream.readFully(data, 0, byteCount);
                    int bytesInThisTile = unitsInThisTile * 4;
                    byteArray = new byte[bytesInThisTile];
                    this.decodePackbits(data, bytesInThisTile, byteArray);
                    this.interpretBytesAsInts(byteArray, idata, unitsInThisTile);
                } else if (this.compression == 32946) {
                    this.stream.readFully(data, 0, byteCount);
                    byte[] byteArray5 = new byte[unitsInThisTile * 4];
                    this.inflate(data, byteArray5);
                    this.interpretBytesAsInts(byteArray5, idata, unitsInThisTile);
                }
            }
            this.stream.seek(save_offset);
        }
        catch (IOException ioe) {
            throw new RuntimeException("TIFFImage13");
        }
        switch (this.imageType) {
            case 2: 
            case 3: {
                if (!this.isWhiteZero) return tile;
                if (dataType == 0 && !(this.getColorModel() instanceof IndexColorModel)) {
                    int l = 0;
                    while (l < bdata.length) {
                        bdata[l] = (byte)(255 - bdata[l]);
                        l += this.numBands;
                    }
                    return tile;
                } else if (dataType == 1) {
                    int ushortMax = 65535;
                    int l = 0;
                    while (l < sdata.length) {
                        sdata[l] = (short)(ushortMax - sdata[l]);
                        l += this.numBands;
                    }
                    return tile;
                } else if (dataType == 2) {
                    int l = 0;
                    while (l < sdata.length) {
                        sdata[l] = ~sdata[l];
                        l += this.numBands;
                    }
                    return tile;
                } else {
                    if (dataType != 3) return tile;
                    long uintMax = 0xFFFFFFFFL;
                    int l = 0;
                    while (l < idata.length) {
                        idata[l] = (int)(uintMax - (long)idata[l]);
                        l += this.numBands;
                    }
                }
                return tile;
            }
            case 5: {
                if (this.sampleSize == 8 && this.compression != 7) {
                    int i = 0;
                    while (i < unitsInThisTile) {
                        byte bswap = bdata[i];
                        bdata[i] = bdata[i + 2];
                        bdata[i + 2] = bswap;
                        i += 3;
                    }
                    return tile;
                } else if (this.sampleSize == 16) {
                    int i = 0;
                    while (i < unitsInThisTile) {
                        short sswap = sdata[i];
                        sdata[i] = sdata[i + 2];
                        sdata[i + 2] = sswap;
                        i += 3;
                    }
                    return tile;
                } else {
                    if (this.sampleSize != 32 || dataType != 3) return tile;
                    int i = 0;
                    while (i < unitsInThisTile) {
                        int iswap = idata[i];
                        idata[i] = idata[i + 2];
                        idata[i + 2] = iswap;
                        i += 3;
                    }
                }
                return tile;
            }
            case 6: {
                if (this.sampleSize == 8) {
                    int i = 0;
                    while (i < unitsInThisTile) {
                        byte bswap = bdata[i];
                        bdata[i] = bdata[i + 3];
                        bdata[i + 3] = bswap;
                        bswap = bdata[i + 1];
                        bdata[i + 1] = bdata[i + 2];
                        bdata[i + 2] = bswap;
                        i += 4;
                    }
                    return tile;
                } else if (this.sampleSize == 16) {
                    int i = 0;
                    while (i < unitsInThisTile) {
                        short sswap = sdata[i];
                        sdata[i] = sdata[i + 3];
                        sdata[i + 3] = sswap;
                        sswap = sdata[i + 1];
                        sdata[i + 1] = sdata[i + 2];
                        sdata[i + 2] = sswap;
                        i += 4;
                    }
                    return tile;
                } else {
                    if (this.sampleSize != 32 || dataType != 3) return tile;
                    int i = 0;
                    while (i < unitsInThisTile) {
                        int iswap = idata[i];
                        idata[i] = idata[i + 3];
                        idata[i + 3] = iswap;
                        iswap = idata[i + 1];
                        idata[i + 1] = idata[i + 2];
                        idata[i + 2] = iswap;
                        i += 4;
                    }
                }
                return tile;
            }
            case 7: {
                int pixelsPerDataUnit = this.chromaSubH * this.chromaSubV;
                int numH = newRect.width / this.chromaSubH;
                int numV = newRect.height / this.chromaSubV;
                byte[] tempData = new byte[numH * numV * (pixelsPerDataUnit + 2)];
                System.arraycopy(bdata, 0, tempData, 0, tempData.length);
                int samplesPerDataUnit = pixelsPerDataUnit * 3;
                int[] pixels = new int[samplesPerDataUnit];
                int bOffset = 0;
                int offsetCb = pixelsPerDataUnit;
                int offsetCr = offsetCb + 1;
                int y = newRect.y;
                int j = 0;
                while (j < numV) {
                    int x = newRect.x;
                    int i = 0;
                    while (i < numH) {
                        int Cb = tempData[bOffset + offsetCb];
                        int Cr = tempData[bOffset + offsetCr];
                        int k = 0;
                        while (k < samplesPerDataUnit) {
                            pixels[k++] = tempData[bOffset++];
                            pixels[k++] = Cb;
                            pixels[k++] = Cr;
                        }
                        bOffset += 2;
                        tile.setPixels(x, y, this.chromaSubH, this.chromaSubV, pixels);
                        x += this.chromaSubH;
                        ++i;
                    }
                    y += this.chromaSubV;
                    ++j;
                }
                return tile;
            }
        }
        return tile;
    }

    private void readShorts(int shortCount, short[] shortArray) {
        int byteCount = 2 * shortCount;
        byte[] byteArray = new byte[byteCount];
        try {
            this.stream.readFully(byteArray, 0, byteCount);
        }
        catch (IOException ioe) {
            throw new RuntimeException("TIFFImage13");
        }
        this.interpretBytesAsShorts(byteArray, shortArray, shortCount);
    }

    private void readInts(int intCount, int[] intArray) {
        int byteCount = 4 * intCount;
        byte[] byteArray = new byte[byteCount];
        try {
            this.stream.readFully(byteArray, 0, byteCount);
        }
        catch (IOException ioe) {
            throw new RuntimeException("TIFFImage13");
        }
        this.interpretBytesAsInts(byteArray, intArray, intCount);
    }

    private void interpretBytesAsShorts(byte[] byteArray, short[] shortArray, int shortCount) {
        int j = 0;
        if (this.isBigEndian) {
            int i = 0;
            while (i < shortCount) {
                int firstByte = byteArray[j++] & 0xFF;
                int secondByte = byteArray[j++] & 0xFF;
                shortArray[i] = (short)((firstByte << 8) + secondByte);
                ++i;
            }
        } else {
            int i = 0;
            while (i < shortCount) {
                int firstByte = byteArray[j++] & 0xFF;
                int secondByte = byteArray[j++] & 0xFF;
                shortArray[i] = (short)((secondByte << 8) + firstByte);
                ++i;
            }
        }
    }

    private void interpretBytesAsInts(byte[] byteArray, int[] intArray, int intCount) {
        int j = 0;
        if (this.isBigEndian) {
            int i = 0;
            while (i < intCount) {
                intArray[i] = (byteArray[j++] & 0xFF) << 24 | (byteArray[j++] & 0xFF) << 16 | (byteArray[j++] & 0xFF) << 8 | byteArray[j++] & 0xFF;
                ++i;
            }
        } else {
            int i = 0;
            while (i < intCount) {
                intArray[i] = byteArray[j++] & 0xFF | (byteArray[j++] & 0xFF) << 8 | (byteArray[j++] & 0xFF) << 16 | (byteArray[j++] & 0xFF) << 24;
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private byte[] decodePackbits(byte[] data, int arraySize, byte[] dst) {
        if (dst == null) {
            dst = new byte[arraySize];
        }
        srcCount = 0;
        dstCount = 0;
lbl5:
        // 3 sources

        try {
            while (dstCount < arraySize) {
                block7: {
                    block6: {
                        if ((b = data[srcCount++]) < 0 || b > 127) break block6;
                        i = 0;
                        while (i < b + 1) {
                            dst[dstCount++] = data[srcCount++];
                            ++i;
                        }
                        ** GOTO lbl5
                    }
                    if (b > -1 || b < -127) break block7;
                    repeat = data[srcCount++];
                    i = 0;
                    while (i < -b + 1) {
                        dst[dstCount++] = repeat;
                        ++i;
                    }
                    ** GOTO lbl5
                }
                ++srcCount;
            }
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new RuntimeException("TIFFImage14");
        }
        return dst;
    }

    private ComponentColorModel createAlphaComponentColorModel(int dataType, int numBands, boolean isAlphaPremultiplied, int transparency) {
        ComponentColorModel ccm = null;
        int[] RGBBits = null;
        ColorSpace cs = null;
        switch (numBands) {
            case 2: {
                cs = ColorSpace.getInstance(1003);
                break;
            }
            case 4: {
                cs = ColorSpace.getInstance(1000);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int componentSize = 0;
        switch (dataType) {
            case 0: {
                componentSize = 8;
                break;
            }
            case 1: 
            case 2: {
                componentSize = 16;
                break;
            }
            case 3: {
                componentSize = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        RGBBits = new int[numBands];
        int i = 0;
        while (i < numBands) {
            RGBBits[i] = componentSize;
            ++i;
        }
        ccm = new ComponentColorModel(cs, RGBBits, true, isAlphaPremultiplied, transparency, dataType);
        return ccm;
    }
}

