/*
 * Decompiled with CFR 0.152.
 */
package org.ardverk.collection;

import java.io.Serializable;
import org.ardverk.collection.AbstractKeyAnalyzer;

public class CharArrayKeyAnalyzer
extends AbstractKeyAnalyzer<char[]>
implements Serializable {
    private static final long serialVersionUID = 683256578013018792L;
    public static final CharArrayKeyAnalyzer CHAR = new CharArrayKeyAnalyzer(16);
    public static final CharArrayKeyAnalyzer BYTE = new CharArrayKeyAnalyzer(8);
    @Deprecated
    public static final CharArrayKeyAnalyzer INSTANCE = CHAR;
    private final int size;
    private final int msb;

    protected CharArrayKeyAnalyzer(int n) {
        this(n, 1 << n - 1);
    }

    protected CharArrayKeyAnalyzer(int n, int n2) {
        this.size = n;
        this.msb = n2;
    }

    @Override
    public int compare(char[] cArray, char[] cArray2) {
        if (cArray == null) {
            return cArray2 == null ? 0 : -1;
        }
        if (cArray2 == null) {
            return cArray == null ? 0 : 1;
        }
        if (cArray.length != cArray2.length) {
            return cArray.length - cArray2.length;
        }
        for (int i = 0; i < cArray.length; ++i) {
            int n = (cArray[i] & 0xFF) - (cArray2[i] & 0xFF);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    @Override
    public int lengthInBits(char[] cArray) {
        return cArray.length * this.size;
    }

    @Override
    public boolean isBitSet(char[] cArray, int n) {
        if (n >= this.lengthInBits(cArray)) {
            return false;
        }
        int n2 = n / this.size;
        int n3 = n % this.size;
        return (cArray[n2] & this.mask(n3)) != 0;
    }

    @Override
    public int bitIndex(char[] cArray, char[] cArray2) {
        int n = Math.max(cArray.length, cArray2.length);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = this.valueAt(cArray, i);
            if (c2 != (c = this.valueAt(cArray2, i))) {
                int n2 = c2 ^ c;
                for (int j = 0; j < this.size; ++j) {
                    if ((n2 & this.mask(j)) == 0) continue;
                    return i * this.size + j;
                }
            }
            if (c2 == '\u0000') continue;
            bl = false;
        }
        if (bl) {
            return -1;
        }
        return -2;
    }

    @Override
    public boolean isPrefix(char[] cArray, char[] cArray2) {
        if (cArray.length < cArray2.length) {
            return false;
        }
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    private int mask(int n) {
        return this.msb >>> n;
    }

    private char valueAt(char[] cArray, int n) {
        if (n < cArray.length) {
            char c = cArray[n];
            if (this.size == 8) {
                c = (char)(c & 0xFF);
            }
            return c;
        }
        return '\u0000';
    }
}

