#include <ctime>
#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <algorithm>
using namespace std;

const int max_num_point=310;

int num_point;
int s[max_num_point][max_num_point]={0};

int d_Int[max_num_point][max_num_point]={0};
int d_L[max_num_point][max_num_point][max_num_point]={0};
int d_R[max_num_point][max_num_point][max_num_point]={0};
int d_N[max_num_point][max_num_point][max_num_point]={0};
int d_LR[max_num_point][max_num_point][max_num_point]={0};

void Dp_LRN( int i, int j, int x );
int Dynamic_Programming()
{
    // Init
    for( int i=1; i<num_point; i++ )
    {
        d_Int[i][i+1] = s[i][i+1];
        for( int x=1; x<=num_point; x++ )
            d_L[i][i+1][x] = d_R[i][i+1][x] = d_N[i][i+1][x] = d_LR[i][i+1][x] = s[i][i+1];
    }
    
    for( int dist=2; dist<num_point; dist++ )
        for( int i=1, j; (j=i+dist) <= num_point; i++ )
        {
            // Int
            d_Int[i][j] = 0;
            for( int k=i+1; k<j; k++ )
            {
                // Case 1
                d_Int[i][j] = max( d_Int[i][j],
                                  d_LR[i][k][j] + d_Int[k][j] + s[i][j] );
                // Case 3.2
                for( int l=i+1; l<k; l++ )
                    d_Int[i][j] = max( d_Int[i][j],
                                      d_R[i][l][k] + d_Int[l][k] + d_L[k][j][l] 
                                      + s[i][k] + s[l][j] + s[i][j] );
            }
            // N, L, R, LR
            for( int x=1; x<i; x++ )
                Dp_LRN( i, j, x );
            for( int x=j+1; x<=num_point; x++ )
                Dp_LRN( i, j, x );
            
        }
    return d_Int[1][num_point];
}

void Dp_LRN( int i, int j, int x) // N, L, R, LR
{
    // N
    d_N[i][j][x] = d_Int[i][j];
    for( int k=i+1; k<j; k++ )
        d_N[i][j][x] = max( d_N[i][j][x], 
                           d_N[i][k][x] + d_Int[k][j] + s[x][k] );
    
    // L
    d_L[i][j][x] = d_Int[i][j];
    for( int k=i+1; k<j; k++ )
    {
        d_L[i][j][x] = max( d_L[i][j][x],
                           d_L[i][k][x] + d_N[k][j][i] + s[x][k] + s[i][j] );
        d_L[i][j][x] = max( d_L[i][j][x],
                           d_Int[i][k] +  d_L[k][j][i] + s[x][k] + s[i][j] );
    }
    
    // R
    d_R[i][j][x] = d_Int[i][j];
    for( int k=i+1; k<j; k++ )
    {
        d_R[i][j][x] = max( d_R[i][j][x],
                           d_N[i][k][j] + d_R[k][j][x] + s[x][k] + s[i][j] );
        d_R[i][j][x] = max( d_R[i][j][x],
                           d_R[i][k][j] + d_Int[k][j]  + s[x][k] + s[i][j] );
    }
    
    // LR
    d_LR[i][j][x] = max( d_L[i][j][x], d_R[i][j][x] );
    for( int k=i+1; k<j; k++ )
        d_LR[i][j][x] = max( d_LR[i][j][x],
                            d_L[i][k][x] + d_R[k][j][x] + s[x][k] + s[i][j] );
    return;
}


FILE *fin;
char cache[11000]={0};
int edge_in[max_num_point]={0};
int read_edge[max_num_point][max_num_point]={0};
void Get_Item(char *&pos, char *get) 
{
    sscanf( pos, "%s", get );
    pos += strlen(get)+1;
    return;
}
int Read() 
{
    int num_edge_dis = 0;
    int len, num_edge = 0, num_in=0;
    char *pos, get[11000]={0};
    num_point = 0;
    for(int point=1; !feof(fin) ;point++)
    {
        fgets( cache, 10000, fin );
        pos = cache;
        len = strlen(cache);
        Get_Item( pos, get );
        if( len<5 )
            break;
        for( int i=0; i<9; i++ )
            Get_Item( pos, get );
        Get_Item( pos, get );
        if( strcmp( get, "_" ) )
            edge_in[num_in++] = point;
        for(int i=0;;i++)
        {
            Get_Item(pos, get);
            if( strcmp( get, "_") )
                read_edge[point][i] = 1;
            else
                read_edge[point][i] = 0;
            if( pos-cache >= len )
                break;
            
        }
        if( point>max_num_point-5 )
            printf("*** ERROR ****");
        num_point = point;
    }
    for( int x=1; x<=num_point; x++ )
        for( int y=1; y<=num_point; y++ )
            s[x][y] = 0;
    for( int x=1; x<=num_point; x++ )
        for( int y=0; y<num_in; y++ )
            if( read_edge[x][y])
            {
                ++num_edge;
                num_edge_dis += ( !s[x][ edge_in[y] ] && x!=edge_in[y] );
                s[x][ edge_in[y] ] = s[ edge_in[y] ][x] = 1;
            }
    return num_edge_dis;
}



int main()
{
    fin = fopen("../cover/data/enccg.trn.conll08","r");
    int num1, num2;
    int sum = 0;
    int count[1100]={0};
    int edge_num1 = 0, edge_num2 = 0;
    for( int i=0; !feof(fin); i++ )
    {
        if(i%1000==0)
            printf("%d\n", i);
        num1 = Read(); 
        if( !num1 && !num_point )
            continue;
        num2 = Dynamic_Programming();
        ++sum;
        edge_num1 += num1;
        edge_num2 += num2;
        if( num2 > num1 || num1-num2 > 100 )
            printf("Error %d %d\n",num1, num2);
        else
            ++count[num1-num2];
    }
    printf("time : %lfs\n", (double)clock()/CLOCKS_PER_SEC);
    printf("sum : %d\n", sum);
    printf("edge cover: %d / %d\n", edge_num2, edge_num1 );
    for( int i=0; i<=100; i++ )
        if( count[i] )
            printf("count %d:\t%d\t%lf%%\n", i, count[i], (double)count[i]/sum*100);
    fclose(fin);
    return 0;
}