import sys
import getopt
import numpy as np
import collections
import random
from space import Space
from utils import read_dict, apply_tm, score, get_valid_data

def usage(errno=0):
    print >>sys.stderr,\
    """
    Given a translation matrix, test data (words and their translations) and 
    source and target language vectors, it returns translations of source test 
    words and computes Top N accuracy.

    Usage:
    python TransmateSourceMatrix.py [options] trans_matrix test_data source_vecs target_vecs
    \n\
    Options:
    -o --output <file>: file prefix. It prints the vectors obtained after 
                        the translation matrix is applied (.vecs.txt and .wds.txt).
                        Optional. Default is ./translated_vecs

                          
    -h --help : help

    Arguments:
    trans_matrix: <file>, translation matrix
    source_vecs: <file>, vectors in source language, Space-separated, with string 
                identifier as first column (dim+1 columns, where dim is the 
                dimensionality of the space)



    Example:
    1) Retrieve translations with standard nearest neighbour retrieval

    python TransmateSourceMatrix.py tm.txt ENspace.txt 
    
    """
    sys.exit(errno)


def main(sys_argv):

    try:
        opts, argv = getopt.getopt(sys_argv[1:], "ho:",
                                   ["help", "output="])
    except getopt.GetoptError, err:
        print str(err)
        usage()
        sys.exit(1)

    # out_file = "./transformed_wiki_800vecs_150306"

    additional = None
    for opt, val in opts:
        if opt in ("-o", "--ouput"):
            out_file = val
            print "Transformate matrix is saved as: " + out_file
        elif opt in ("-h", "--help"):
            usage(0)
        else:
            usage(1)

    if len(argv) == 3:
        tm_file = argv[0] 
        dict_file = argv[1]
        source_file = argv[2]	
        #target_file = argv[3]


    else:
	print str(err)
	usage(1)

    print "Loading the translation matrix"
    tm = np.loadtxt(tm_file)

    print "Reading the common vocabulary"
    vocabulary_data = read_dict(dict_file)


 
    print "Reading source file: %s" % source_file
    source_sp = Space.build(source_file, vocabulary_data)
    print "Normalize source file: %s" % source_file
    source_sp.normalize()

    print "Transmate the source matrix to new matrix" #translates all the elements loaded in the source space
    mapped_source_sp = apply_tm(source_sp, tm)
    mapped_source_sp.normalize;
    
    print "Printing mapped source vectors: %s" % out_file
    np.savetxt("%s.vecs.txt" % out_file, mapped_source_sp.mat)
    np.savetxt("%s.wds.txt" % out_file, mapped_source_sp.id2row, fmt="%s")

    # print "Reading and normalizing target matrix: %s" % target_file
    # target_sp = Space.build(target_file, vocabulary_data)
    # target_sp.normalize()

    # print "Saving correspoding target vectors: %s" % out_file
    # np.savetxt("tweet_target.vecs.txt", target_sp.mat)
    # np.savetxt("tweet_target.wds.txt", target_sp.id2row, fmt="%s")

    

if __name__ == '__main__':
    main(sys.argv)

