/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.modification.morefeatures;

import edu.pku.coli.io.DAGSentenceReader;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import matetools.is2.data.D6;
import matetools.is2.data.DX;
import matetools.is2.data.Instances;
import matetools.is2.data.Long2IntInterface;
import matetools.is2.data.SentenceData09;
import matetools.is2.modification.morefeatures.MoreFeaturesInterface;
import matetools.is2.parser.D5;
import matetools.is2.parser.Extractor;

public class GraphFeatures
extends MoreFeaturesInterface {
    static String GRAPH_LAB = "MORE_GRAPH_LAB";
    String[] trainFiles;
    String[] testFiles;
    String format = "sdp15";
    List<Iterator<SentenceForDAGParsing>> sentIts;
    DX d0;
    DX d1;
    int nolab;

    public GraphFeatures(String trainGraphDir, String testGraphDir, String graphFormat) {
        this.trainFiles = trainGraphDir.split(";");
        this.testFiles = testGraphDir.split(";");
        this.format = graphFormat;
    }

    @Override
    public void register() {
        this.nolab = this.mf.register(GRAPH_LAB, "<NO_LAB>");
        for (Iterator<SentenceForDAGParsing> it : this.sentIts) {
            while (it.hasNext()) {
                SentenceForDAGParsing sent = it.next();
                for (Pair<Pair<Integer, Integer>, String> arc : sent.getGoldDAG().toLabeledPairs()) {
                    this.mf.register(GRAPH_LAB, arc.getSecond());
                }
            }
        }
    }

    @Override
    public void init(int what) {
        Long2IntInterface l2i = MoreFeaturesInterface.l2i;
        if (what == 1) {
            this.d0 = new D6(l2i);
            this.d1 = new D6(l2i);
        } else {
            this.d0 = new D5(l2i);
            this.d1 = new D5(l2i);
        }
        int nlabs = this.mf.getFeatureCounter().get(GRAPH_LAB);
        this.d0.a0 = Extractor.s_type;
        this.d0.a1 = Extractor.s_rel;
        this.d0.a2 = Extractor.s_pos;
        this.d0.a3 = Extractor.s_pos;
        this.d0.a4 = nlabs;
        this.d0.fix();
        this.d1.a0 = Extractor.s_type;
        this.d1.a1 = Extractor.s_rel;
        this.d1.a2 = Extractor.s_word;
        this.d1.a3 = Extractor.s_word;
        this.d1.a4 = Extractor.s_pos;
        this.d1.a5 = Extractor.s_pos;
        this.d1.a6 = nlabs;
        this.d1.fix();
    }

    @Override
    public void initFeats() {
        int i = 0;
        while (i < 10) {
            this.mf.register("TYPE", "Graph" + i);
            ++i;
        }
        this.featureIndex = this.mf.getFeatureCounter().get("TYPE") - 2;
    }

    @Override
    public void createFeatures(Instances is, SentenceData09 instance) {
        IntGraphs graphs = new IntGraphs();
        for (Iterator<SentenceForDAGParsing> it : this.sentIts) {
            SentenceForDAGParsing sent = it.next();
            graphs.addGraph(sent);
        }
        if (is.moreIntFeats[is.size() - 1] == null) {
            is.moreIntFeats[is.size() - 1] = new MoreFeaturesInterface.MoreIntFeats(graphs);
        } else {
            is.moreIntFeats[is.size() - 1].graphs = graphs;
        }
    }

    @Override
    public void addFirstOrderFeatures(Instances is, int i, int w1, int w2, int label, List<Long> ret) {
    }

    @Override
    public void startReadingTrain() {
        this.sentIts = new ArrayList<Iterator<SentenceForDAGParsing>>(this.trainFiles.length);
        String[] stringArray = this.trainFiles;
        int n = this.trainFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            DAGSentenceReader dags = DAGSentenceReader.newDAGSentenceReader(this.format, false, false, file);
            this.sentIts.add(dags.iterator());
            ++n2;
        }
    }

    @Override
    public void startReadingTest() {
        this.sentIts = new ArrayList<Iterator<SentenceForDAGParsing>>(this.testFiles.length);
        String[] stringArray = this.testFiles;
        int n = this.testFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            DAGSentenceReader dags = DAGSentenceReader.newDAGSentenceReader(this.format, false, false, file);
            this.sentIts.add(dags.iterator());
            ++n2;
        }
    }

    class IntGraphs {
        IntGraphs() {
        }

        public void addGraph(SentenceForDAGParsing sent) {
        }
    }
}

