/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.pear.dag;

import edu.pku.coli.ccg.CCGNode;
import edu.pku.coli.io.DAGSentenceReader;
import edu.pku.coli.viewer.DepTree;
import edu.pku.coli.viewer.Edge;
import fig.basic.DeepCloneable;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PredicateArgumentAdjunctDAG
implements DeepCloneable<PredicateArgumentAdjunctDAG> {
    public static final int CONLL06_HEAD_COL = 6;
    public static final int CONLL06_LABEL_COL = 7;
    public static final int MALT_HEAD_COL = 2;
    public static final int MALT_LABEL_COL = 3;
    public static final int CONLL08_TREE_HEAD_COL = 8;
    public static final int CONLL08_TREE_LABEL_COL = 9;
    public static final int CONLL08_DAG_HEAD_COL = 10;
    public static int CONLL08_TYPE_COL = -1;
    public static boolean PARG_SENT_LEN_PLUS_ONE = true;
    public static final String ROOT_TYPE = "#ROOT_TYPE#";
    public int sentLen;
    public List<String> _types;
    public PredicateArgumentAdjunctArcAdjacencyList[] arcAdjacencyLists;
    private List<List<Integer>> _coordinationGroups;
    private CCGNode _ccgTree;

    public PredicateArgumentAdjunctDAG(int len) {
        this.sentLen = len;
        this.arcAdjacencyLists = new PredicateArgumentAdjunctArcAdjacencyList[this.sentLen + 1];
        int i = 0;
        while (i <= this.sentLen) {
            this.arcAdjacencyLists[i] = new PredicateArgumentAdjunctArcAdjacencyList(i);
            ++i;
        }
        this._types = new ArrayList<String>(this.sentLen + 1);
        this._types.add(ROOT_TYPE);
    }

    public static PredicateArgumentAdjunctDAG buildDagFromPARG(String[][] CCGPARG) {
        int sentLen = Integer.parseInt(CCGPARG[0][CCGPARG[0].length - 1]);
        if (PARG_SENT_LEN_PLUS_ONE) {
            ++sentLen;
        }
        PredicateArgumentAdjunctDAG dag = new PredicateArgumentAdjunctDAG(sentLen);
        int i = 1;
        while (i < CCGPARG.length) {
            int to = Integer.parseInt(CCGPARG[i][0]);
            int from = Integer.parseInt(CCGPARG[i][1]);
            dag.addArc(from + 1, to + 1, CCGPARG[i][3]);
            ++i;
        }
        return dag;
    }

    public static PredicateArgumentAdjunctDAG buildDagFromStanfordPARG(String[] parg, int sentLen) {
        PredicateArgumentAdjunctDAG dag = new PredicateArgumentAdjunctDAG(sentLen);
        String[] stringArray = parg;
        int n = parg.length;
        int n2 = 0;
        while (n2 < n) {
            String oldLabel;
            String line = stringArray[n2];
            Pattern p = Pattern.compile("(.+)\\(.+-(\\d+)'*, .+-(\\d+)'*\\)");
            Matcher m = p.matcher(line);
            m.find();
            String label = m.group(1);
            int from = Integer.parseInt(m.group(2));
            int to = Integer.parseInt(m.group(3));
            if (from != to && !dag.containsArc(from, to)) {
                dag.addArc(from, to, label);
            } else if (from != to && !(oldLabel = dag.getArcLabel(from, to)).contains(label)) {
                label = String.valueOf(oldLabel) + ":" + label;
                dag.setArcLabel(from, to, label);
            }
            ++n2;
        }
        return dag;
    }

    public static PredicateArgumentAdjunctDAG buildTreeFromCONLL06(String[][] conll) {
        return PredicateArgumentAdjunctDAG.buildTreeFromCONLL(conll, 6, 7);
    }

    public static PredicateArgumentAdjunctDAG buildTreeFromMALT(String[][] conll) {
        return PredicateArgumentAdjunctDAG.buildTreeFromCONLL(conll, 2, 3);
    }

    public static PredicateArgumentAdjunctDAG buildTreeFromCONLL08(String[][] conll) {
        return PredicateArgumentAdjunctDAG.buildTreeFromCONLL(conll, 8, 9);
    }

    public static PredicateArgumentAdjunctDAG buildTreeFromCONLL(String[][] conll, int headCol, int labelCol) {
        String[] headStrings = conll[headCol];
        String[] labels = conll[labelCol];
        return PredicateArgumentAdjunctDAG.buildTreeFromHeadsAndLabels(headStrings, labels);
    }

    public static PredicateArgumentAdjunctDAG buildTreeFromHeadsAndLabels(String[] headStrings, String[] labels) {
        int[] heads = new int[headStrings.length];
        int i = 0;
        while (i < headStrings.length) {
            heads[i] = "_".equals(headStrings[i]) ? -1 : Integer.parseInt(headStrings[i]);
            ++i;
        }
        return PredicateArgumentAdjunctDAG.buildTreeFromHeadsAndLabels(heads, labels);
    }

    public static PredicateArgumentAdjunctDAG buildTreeFromHeadsAndLabels(int[] heads, String[] labs) {
        PredicateArgumentAdjunctDAG dag = new PredicateArgumentAdjunctDAG(heads.length);
        if (labs == null) {
            labs = new String[heads.length];
        }
        int i = 0;
        while (i < heads.length) {
            if (heads[i] != -1) {
                dag.addArc(heads[i], i + 1, labs[i]);
            }
            ++i;
        }
        return dag;
    }

    public static PredicateArgumentAdjunctDAG buildDagFromCONLL08(String[][] conll) {
        if (conll == null || conll.length == 0) {
            return null;
        }
        if (conll.length <= 10) {
            return new PredicateArgumentAdjunctDAG(conll[0].length);
        }
        String[] heads = conll[10];
        PredicateArgumentAdjunctDAG dag = new PredicateArgumentAdjunctDAG(heads.length);
        if (CONLL08_TYPE_COL != -1) {
            String[] stringArray = conll[CONLL08_TYPE_COL];
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                if (!type.equals("_")) {
                    if (CONLL08_TYPE_COL == 7) {
                        dag._types.add(type.split("_")[0]);
                    } else if (CONLL08_TYPE_COL == 10) {
                        String[] types = type.split("\\.");
                        dag._types.add(types[types.length - 1]);
                    }
                } else {
                    dag._types.add(type);
                }
                ++n2;
            }
        }
        int depColumn = 11;
        int i = 0;
        while (i < heads.length) {
            if (!"_".equals(heads[i])) {
                String[] deps = conll[depColumn];
                int j = 0;
                while (j < deps.length) {
                    if (!"_".equals(deps[j])) {
                        dag.addArc(i + 1, j + 1, deps[j]);
                    }
                    ++j;
                }
                ++depColumn;
            }
            ++i;
        }
        return dag;
    }

    public static PredicateArgumentAdjunctDAG buildDAGFromSDP(String[][] sdp, DAGSentenceReader.SDPFormat format) {
        if (sdp == null || sdp.length == 0) {
            return null;
        }
        if (sdp.length <= 5) {
            return new PredicateArgumentAdjunctDAG(sdp[0].length);
        }
        String[] heads = sdp[5];
        PredicateArgumentAdjunctDAG dag = new PredicateArgumentAdjunctDAG(heads.length);
        int depColumn = 6;
        if (format == DAGSentenceReader.SDPFormat.SDP15) {
            depColumn = 7;
        }
        int i = 0;
        while (i < heads.length) {
            if ("+".equals(heads[i])) {
                String[] deps = sdp[depColumn];
                int j = 0;
                while (j < deps.length) {
                    if (!"_".equals(deps[j])) {
                        dag.addArc(i + 1, j + 1, deps[j]);
                    }
                    ++j;
                }
                ++depColumn;
            }
            ++i;
        }
        i = 0;
        while (i < heads.length) {
            if ("+".equals(sdp[4][i])) {
                dag.addArc(0, i + 1, "ROOT");
            }
            ++i;
        }
        return dag;
    }

    public static PredicateArgumentAdjunctDAG builDagFromDepTree(DepTree depTree) {
        List tokens = depTree.getTokenlist();
        PredicateArgumentAdjunctDAG dag = null;
        dag = depTree.hasRoot() ? new PredicateArgumentAdjunctDAG(tokens.size() - 1) : new PredicateArgumentAdjunctDAG(tokens.size());
        for (Edge e : depTree.getEdgelist()) {
            dag.addArc(e.getStart() + 1, e.getEnd() + 1, e.getLabel());
        }
        return dag;
    }

    public void addArc(int from, int to, String label) {
        this.arcAdjacencyLists[from].addOutArc(to, label);
        this.arcAdjacencyLists[to].addInArc(from, label);
    }

    public void removeArc(int from, int to) {
        this.arcAdjacencyLists[from].removeOutArc(to);
        this.arcAdjacencyLists[to].removeInArc(from);
    }

    public void setArcLabel(int from, int to, String label) {
        this.arcAdjacencyLists[from].setOutArcLabel(to, label);
        this.arcAdjacencyLists[to].setInArcLabel(from, label);
    }

    public RightArcInfo getOneRightArc(int left) {
        return this.arcAdjacencyLists[left].rightArcs.get(0);
    }

    public void removeOneRightArc(int left) {
        RightArcInfo arc = this.arcAdjacencyLists[left].rightArcs.get(0);
        if (arc.direction == ArcDirection.LEFT) {
            this.removeArc(arc.rightIndex, left);
        } else {
            this.removeArc(left, arc.rightIndex);
        }
    }

    public void addRightArc(int left, int right, ArcDirection arcDirection, String label) {
        if (arcDirection == ArcDirection.LEFT) {
            this.addArc(right, left, label);
        } else {
            this.addArc(left, right, label);
        }
    }

    public boolean ContainsSubgraphUnlab(PredicateArgumentAdjunctDAG g) {
        for (Pair<Integer, Integer> arc : g.toUnlabeledPairs()) {
            if (this.containsArc(arc.getFirst(), arc.getSecond())) continue;
            return false;
        }
        return true;
    }

    public void minusGraphUnlab(PredicateArgumentAdjunctDAG g) {
        for (Pair<Integer, Integer> arc : g.toUnlabeledPairs()) {
            this.removeArc(arc.getFirst(), arc.getSecond());
        }
    }

    public boolean containsArc(int from, int to) {
        if (from < 0 || to < 0 || from >= this.arcAdjacencyLists.length) {
            return false;
        }
        return this.arcAdjacencyLists[from].containsOutArc(to);
    }

    public String getArcLabel(int from, int to) {
        return this.arcAdjacencyLists[from].getOutArcLabel(to);
    }

    public int sentenceLength() {
        return this.sentLen;
    }

    public List<ArcInfo> getParents(int wordIndex) {
        return this.arcAdjacencyLists[wordIndex].getInArcs();
    }

    public ArcInfo getOneParent(int wordIndex) {
        if (this.arcAdjacencyLists[wordIndex].getInArcs().isEmpty()) {
            return null;
        }
        return this.arcAdjacencyLists[wordIndex].getInArcs().get(0);
    }

    public List<ArcInfo> getChildren(int wordIndex) {
        return this.arcAdjacencyLists[wordIndex].getOutArcs();
    }

    public PredicateArgumentAdjunctArcAdjacencyList[] getAdjacencyLists() {
        return this.arcAdjacencyLists;
    }

    public PredicateArgumentAdjunctArcAdjacencyList[] getDeepCloneOfAdjacencyLists() {
        PredicateArgumentAdjunctArcAdjacencyList[] copiedArray = new PredicateArgumentAdjunctArcAdjacencyList[this.arcAdjacencyLists.length];
        int i = 0;
        while (i < copiedArray.length) {
            copiedArray[i] = this.arcAdjacencyLists[i].deepClone();
            ++i;
        }
        return copiedArray;
    }

    public int arcCount() {
        int arcCount = 0;
        int i = 0;
        while (i < this.arcAdjacencyLists.length) {
            PredicateArgumentAdjunctArcAdjacencyList arcList = this.arcAdjacencyLists[i];
            arcCount += arcList.rightArcs.size();
            ++i;
        }
        return arcCount;
    }

    public int crossingArcPairCount() {
        int crossArcPairCount = 0;
        int i = 0;
        while (i < this.arcAdjacencyLists.length) {
            PredicateArgumentAdjunctArcAdjacencyList arcList = this.arcAdjacencyLists[i];
            for (RightArcInfo arc : arcList.getRightArcs()) {
                int j = arc.rightIndex;
                int k = i + 1;
                while (k < j) {
                    PredicateArgumentAdjunctArcAdjacencyList arcListk = this.arcAdjacencyLists[k];
                    for (RightArcInfo arc2 : arcListk.getRightArcs()) {
                        if (arc2.rightIndex <= j) continue;
                        ++crossArcPairCount;
                    }
                    ++k;
                }
            }
            ++i;
        }
        return crossArcPairCount;
    }

    public Set<Pair<Integer, Integer>> toUnlabeledPairs() {
        return this.toUnlabeledPairs(false);
    }

    public Set<Pair<Integer, Integer>> toUnlabeledPairs(boolean excludeRoot) {
        int start;
        HashSet<Pair<Integer, Integer>> pairs = new HashSet<Pair<Integer, Integer>>();
        int i = start = excludeRoot ? 1 : 0;
        while (i < this.arcAdjacencyLists.length) {
            PredicateArgumentAdjunctArcAdjacencyList arcList = this.arcAdjacencyLists[i];
            for (RightArcInfo arc : arcList.getRightArcs()) {
                if (arc.direction == ArcDirection.LEFT) {
                    pairs.add(new Pair<Integer, Integer>(arc.rightIndex, i));
                    continue;
                }
                pairs.add(new Pair<Integer, Integer>(i, arc.rightIndex));
            }
            ++i;
        }
        return pairs;
    }

    public Set<Pair<Pair<Integer, Integer>, String>> toLabeledPairs() {
        return this.toLabeledPairs(false);
    }

    public Set<Pair<Pair<Integer, Integer>, String>> toLabeledPairs(boolean excludeRoot) {
        int start;
        HashSet<Pair<Pair<Integer, Integer>, String>> pairs = new HashSet<Pair<Pair<Integer, Integer>, String>>();
        int i = start = excludeRoot ? 1 : 0;
        while (i < this.arcAdjacencyLists.length) {
            PredicateArgumentAdjunctArcAdjacencyList arcList = this.arcAdjacencyLists[i];
            for (RightArcInfo arc : arcList.getRightArcs()) {
                if (arc.direction == ArcDirection.LEFT) {
                    pairs.add(new Pair<Pair<Integer, Integer>, String>(new Pair<Integer, Integer>(arc.rightIndex, i), arc.label));
                    continue;
                }
                pairs.add(new Pair<Pair<Integer, Integer>, String>(new Pair<Integer, Integer>(i, arc.rightIndex), arc.label));
            }
            ++i;
        }
        return pairs;
    }

    public Set<Pair<Pair<Pair<Integer, Integer>, String>, String>> toTypedPairs() {
        return this.toTypedPairs(false);
    }

    public Set<Pair<Pair<Pair<Integer, Integer>, String>, String>> toTypedPairs(boolean excludeRoot) {
        int start;
        if (!this.isTyped()) {
            return null;
        }
        HashSet<Pair<Pair<Pair<Integer, Integer>, String>, String>> pairs = new HashSet<Pair<Pair<Pair<Integer, Integer>, String>, String>>();
        int i = start = excludeRoot ? 1 : 0;
        while (i < this.arcAdjacencyLists.length) {
            PredicateArgumentAdjunctArcAdjacencyList arcList = this.arcAdjacencyLists[i];
            for (RightArcInfo arc : arcList.getRightArcs()) {
                String type;
                if (arc.direction == ArcDirection.LEFT) {
                    type = this._types.size() > arc.rightIndex ? this._types.get(arc.rightIndex) : null;
                    pairs.add(new Pair<Pair<Pair<Integer, Integer>, String>, String>(new Pair<Pair<Integer, Integer>, String>(new Pair<Integer, Integer>(arc.rightIndex, i), arc.label), type));
                    continue;
                }
                type = this._types.size() > i ? this._types.get(i) : null;
                pairs.add(new Pair<Pair<Pair<Integer, Integer>, String>, String>(new Pair<Pair<Integer, Integer>, String>(new Pair<Integer, Integer>(i, arc.rightIndex), arc.label), type));
            }
            ++i;
        }
        return pairs;
    }

    public boolean isEmpty() {
        int i = 0;
        while (i < this.arcAdjacencyLists.length) {
            if (!this.arcAdjacencyLists[i].rightArcs.isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isTyped() {
        return this._types.size() != 1;
    }

    public List<String> getTypes() {
        return this._types;
    }

    public void setTypes(String[] types) {
        this._types = new ArrayList<String>(this.sentLen + 1);
        this._types.add(ROOT_TYPE);
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            this._types.add(type);
            ++n2;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PredicateArgumentAdjunctDAG)) {
            return false;
        }
        PredicateArgumentAdjunctDAG other = (PredicateArgumentAdjunctDAG)obj;
        if (this.sentLen != other.sentLen) {
            return false;
        }
        return this.toLabeledPairs().equals(other.toLabeledPairs()) && this._types.equals(other._types);
    }

    public boolean equalsUntype(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PredicateArgumentAdjunctDAG)) {
            return false;
        }
        PredicateArgumentAdjunctDAG other = (PredicateArgumentAdjunctDAG)obj;
        if (this.sentLen != other.sentLen) {
            return false;
        }
        return this.toLabeledPairs().equals(other.toLabeledPairs());
    }

    public boolean equalsUnlabel(PredicateArgumentAdjunctDAG other) {
        if (this == other) {
            return true;
        }
        if (this.sentLen != other.sentLen) {
            return false;
        }
        return this.toUnlabeledPairs().equals(other.toUnlabeledPairs());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.arcAdjacencyLists.length) {
            sb.append("Arc adjency list " + i + ": \n" + this.arcAdjacencyLists[i].toString() + "\n");
            ++i;
        }
        return sb.toString();
    }

    public String toArcString() {
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k <= this.sentLen) {
            for (ArcInfo arc : this.getParents(k)) {
                sb.append(String.valueOf(arc.index) + "--" + arc.label + "->" + k + "; ");
            }
            ++k;
        }
        return sb.toString();
    }

    @Override
    public PredicateArgumentAdjunctDAG deepClone() {
        PredicateArgumentAdjunctDAG clone = new PredicateArgumentAdjunctDAG(this.sentLen);
        clone.arcAdjacencyLists = this.getDeepCloneOfAdjacencyLists();
        ArrayList<String> types = new ArrayList<String>();
        for (String type : this._types) {
            types.add(type);
        }
        clone._types = types;
        if (this._coordinationGroups != null) {
            ArrayList<List<Integer>> groups = new ArrayList<List<Integer>>();
            for (List<Integer> group : this._coordinationGroups) {
                ArrayList<Integer> groupCopy = new ArrayList<Integer>();
                for (int i : group) {
                    groupCopy.add(i);
                }
                groups.add(groupCopy);
            }
            clone._coordinationGroups = groups;
        }
        return clone;
    }

    public List<Integer> getNodesConnectedTo(int node) {
        ArrayList<Integer> connectedNodes = new ArrayList<Integer>();
        LinkedList<Integer> toBeTraversed = new LinkedList<Integer>();
        toBeTraversed.add(node);
        boolean[] isconnected = new boolean[this.sentLen];
        while (!toBeTraversed.isEmpty()) {
            int curNode = (Integer)toBeTraversed.poll();
            if (isconnected[curNode]) continue;
            isconnected[curNode] = true;
            connectedNodes.add(curNode);
            for (ArcInfo parent : this.arcAdjacencyLists[curNode].getInArcs()) {
                toBeTraversed.add(parent.index);
            }
            for (ArcInfo child : this.arcAdjacencyLists[curNode].getOutArcs()) {
                toBeTraversed.add(child.index);
            }
        }
        Collections.sort(connectedNodes);
        return connectedNodes;
    }

    public List<List<Integer>> getCoordinateGroups() {
        return this._coordinationGroups;
    }

    public String getSupertagOfKthWord(int k) {
        if (k < 0) {
            return "#BOST#";
        }
        if (k > this.sentLen) {
            return "#EOST#";
        }
        if (k >= this._types.size() && k <= this.sentLen) {
            return null;
        }
        return this._types.get(k);
    }

    public void setGroups(List<List<Integer>> groups) {
        this._coordinationGroups = groups;
    }

    public void setCCGTree(CCGNode ccgNode) {
        this._ccgTree = ccgNode;
    }

    public CCGNode getCCGTree() {
        return this._ccgTree;
    }

    public PredicateArgumentAdjunctDAG reverse() {
        PredicateArgumentAdjunctDAG reversed = new PredicateArgumentAdjunctDAG(this.sentLen);
        for (RightArcInfo arc : this.arcAdjacencyLists[0].getRightArcs()) {
            if (arc.direction == ArcDirection.RIGHT) {
                reversed.addArc(0, this.sentLen - arc.rightIndex + 1, arc.label);
                continue;
            }
            if (arc.direction != ArcDirection.LEFT) continue;
            reversed.addArc(0, this.sentLen - arc.rightIndex + 1, arc.label);
        }
        int i = 1;
        while (i < this.arcAdjacencyLists.length) {
            PredicateArgumentAdjunctArcAdjacencyList arcList = this.arcAdjacencyLists[i];
            for (RightArcInfo arc : arcList.getRightArcs()) {
                if (arc.direction == ArcDirection.RIGHT) {
                    reversed.addArc(this.sentLen - i + 1, this.sentLen - arc.rightIndex + 1, arc.label);
                    continue;
                }
                if (arc.direction != ArcDirection.LEFT) continue;
                reversed.addArc(this.sentLen - arc.rightIndex + 1, this.sentLen - i + 1, arc.label);
            }
            ++i;
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add(ROOT_TYPE);
        int i2 = 1;
        while (i2 < this._types.size()) {
            types.add(this._types.get(this._types.size() - i2));
            ++i2;
        }
        reversed._types = types;
        return reversed;
    }

    public static enum ArcDirection {
        LEFT,
        RIGHT;

    }

    public static class ArcInfo
    implements Comparable<ArcInfo>,
    DeepCloneable<ArcInfo> {
        public int index;
        public String label;

        public ArcInfo(int index) {
            this.index = index;
            this.label = null;
        }

        public ArcInfo(int index, String label) {
            this.index = index;
            this.label = label;
        }

        @Override
        public ArcInfo deepClone() {
            return new ArcInfo(this.index, this.label);
        }

        @Override
        public int compareTo(ArcInfo other) {
            if (this.index < other.index) {
                return -1;
            }
            if (this.index > other.index) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ArcInfo)) {
                return false;
            }
            ArcInfo other = (ArcInfo)obj;
            if (this.label == null && other.label != null) {
                return false;
            }
            return this.index == other.index && this.label.equals(other.label);
        }

        public String toString() {
            return "(index, label) = (" + this.index + ", " + this.label + ")";
        }
    }

    public static class PredicateArgumentAdjunctArcAdjacencyList
    implements Comparable<PredicateArgumentAdjunctArcAdjacencyList>,
    DeepCloneable<PredicateArgumentAdjunctArcAdjacencyList> {
        public int wordIndex;
        public List<RightArcInfo> rightArcs;
        public List<ArcInfo> inArcs;
        public List<ArcInfo> outArcs;

        PredicateArgumentAdjunctArcAdjacencyList() {
        }

        PredicateArgumentAdjunctArcAdjacencyList(int wordIndex) {
            this.wordIndex = wordIndex;
            this.rightArcs = new ArrayList<RightArcInfo>();
            this.inArcs = new ArrayList<ArcInfo>();
            this.outArcs = new ArrayList<ArcInfo>();
        }

        void addInArc(int from, String label) {
            ArcInfo arc = new ArcInfo(from, label);
            this.inArcs.add(arc);
            if (from > this.wordIndex) {
                RightArcInfo rightArc = new RightArcInfo(from, ArcDirection.LEFT, label);
                this.rightArcs.add(rightArc);
            }
            this.sortArcs();
        }

        public void setInArcLabel(int from, String label) {
            for (ArcInfo arc : this.inArcs) {
                if (arc.index != from) continue;
                arc.label = label;
                break;
            }
            if (from > this.wordIndex) {
                for (RightArcInfo rightArc : this.rightArcs) {
                    if (rightArc.rightIndex != from || rightArc.direction != ArcDirection.LEFT) continue;
                    rightArc.label = label;
                    break;
                }
            }
        }

        void addOutArc(int to, String label) {
            ArcInfo arc = new ArcInfo(to, label);
            this.outArcs.add(arc);
            if (to >= this.wordIndex) {
                RightArcInfo rightArc = new RightArcInfo(to, ArcDirection.RIGHT, label);
                this.rightArcs.add(rightArc);
            }
            this.sortArcs();
        }

        public void setOutArcLabel(int to, String label) {
            for (ArcInfo arc : this.outArcs) {
                if (arc.index != to) continue;
                arc.label = label;
                break;
            }
            if (to >= this.wordIndex) {
                for (RightArcInfo rightArc : this.rightArcs) {
                    if (rightArc.rightIndex != to || rightArc.direction != ArcDirection.RIGHT) continue;
                    rightArc.label = label;
                    break;
                }
            }
        }

        public void removeOutArc(int to) {
            int i = 0;
            while (i < this.outArcs.size()) {
                if (this.outArcs.get((int)i).index == to) {
                    this.outArcs.remove(i);
                    break;
                }
                ++i;
            }
            if (to >= this.wordIndex) {
                i = 0;
                while (i < this.rightArcs.size()) {
                    if (this.rightArcs.get((int)i).rightIndex == to) {
                        this.rightArcs.remove(i);
                        break;
                    }
                    ++i;
                }
            }
        }

        public void removeInArc(int from) {
            int i = 0;
            while (i < this.inArcs.size()) {
                if (this.inArcs.get((int)i).index == from) {
                    this.inArcs.remove(i);
                    break;
                }
                ++i;
            }
            if (from > this.wordIndex) {
                i = 0;
                while (i < this.rightArcs.size()) {
                    if (this.rightArcs.get((int)i).rightIndex == from) {
                        this.rightArcs.remove(i);
                        break;
                    }
                    ++i;
                }
            }
        }

        public List<RightArcInfo> getRightArcs() {
            return this.rightArcs;
        }

        public List<ArcInfo> getInArcs() {
            return this.inArcs;
        }

        public List<ArcInfo> getOutArcs() {
            return this.outArcs;
        }

        public void sortArcs() {
            Collections.sort(this.rightArcs);
            Collections.sort(this.inArcs);
            Collections.sort(this.outArcs);
        }

        @Override
        public int compareTo(PredicateArgumentAdjunctArcAdjacencyList other) {
            Iterator<RightArcInfo> it0 = this.rightArcs.iterator();
            Iterator<RightArcInfo> it1 = other.rightArcs.iterator();
            while (it0.hasNext() && it1.hasNext()) {
                RightArcInfo arc1;
                RightArcInfo arc0 = it0.next();
                if (arc0.compareTo(arc1 = it1.next()) == 0) continue;
                return arc0.compareTo(arc1);
            }
            if (it0.hasNext()) {
                return 1;
            }
            if (it1.hasNext()) {
                return -1;
            }
            return 0;
        }

        @Override
        public PredicateArgumentAdjunctArcAdjacencyList deepClone() {
            PredicateArgumentAdjunctArcAdjacencyList clone = new PredicateArgumentAdjunctArcAdjacencyList(this.wordIndex);
            clone.rightArcs = new ArrayList<RightArcInfo>();
            for (RightArcInfo rightArcInfo : this.rightArcs) {
                clone.rightArcs.add(rightArcInfo.deepClone());
            }
            clone.outArcs = new ArrayList<ArcInfo>();
            for (ArcInfo arcInfo : this.outArcs) {
                clone.outArcs.add(arcInfo.deepClone());
            }
            clone.inArcs = new ArrayList<ArcInfo>();
            for (ArcInfo arcInfo : this.inArcs) {
                clone.inArcs.add(arcInfo.deepClone());
            }
            return clone;
        }

        public boolean isEmpty() {
            return this.inArcs.isEmpty() && this.outArcs.isEmpty();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (RightArcInfo rightArc : this.rightArcs) {
                sb.append(String.valueOf(rightArc.toString()) + " ");
            }
            return sb.toString();
        }

        public boolean containsOutArc(int to) {
            for (ArcInfo arc : this.outArcs) {
                if (arc.index != to) continue;
                return true;
            }
            return false;
        }

        public String getOutArcLabel(int to) {
            for (ArcInfo arc : this.outArcs) {
                if (arc.index != to) continue;
                return arc.label;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PredicateArgumentAdjunctArcAdjacencyList)) {
                return false;
            }
            PredicateArgumentAdjunctArcAdjacencyList other = (PredicateArgumentAdjunctArcAdjacencyList)obj;
            return this.rightArcs.equals(other.rightArcs) && this.inArcs.equals(other.inArcs) && this.outArcs.equals(other.outArcs);
        }
    }

    public static class RightArcInfo
    implements Comparable<RightArcInfo>,
    DeepCloneable<RightArcInfo> {
        public int rightIndex;
        public ArcDirection direction;
        public String label;

        public RightArcInfo(int rightIndex, ArcDirection direction) {
            this.rightIndex = rightIndex;
            this.direction = direction;
            this.label = null;
        }

        public RightArcInfo(int rightIndex, ArcDirection direction, String label) {
            this.rightIndex = rightIndex;
            this.direction = direction;
            this.label = label;
        }

        @Override
        public int compareTo(RightArcInfo other) {
            if (this.rightIndex < other.rightIndex) {
                return -1;
            }
            if (this.rightIndex > other.rightIndex) {
                return 1;
            }
            return 0;
        }

        @Override
        public RightArcInfo deepClone() {
            return new RightArcInfo(this.rightIndex, this.direction, this.label);
        }

        public String toString() {
            return "<" + this.rightIndex + " : " + (Object)((Object)this.direction) + " : " + this.label + ">";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RightArcInfo)) {
                return false;
            }
            RightArcInfo other = (RightArcInfo)obj;
            if (this.label == null && other.label != null) {
                return false;
            }
            return this.rightIndex == other.rightIndex && this.direction == other.direction && this.label.equals(other.label);
        }
    }
}

