/*
 * Decompiled with CFR 0.152.
 */
package jigsaw.grammar;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jigsaw.syntax.CollinsHeadFinder;
import jigsaw.syntax.Grammar;
import jigsaw.syntax.Rule;
import jigsaw.syntax.Tree;
import jigsaw.treebank.PennTreebankReader;
import jigsaw.treebank.Trees;
import jigsaw.util.StringUtils;

public class AnnotPtbPcfgExtractor {
    public static Grammar extractPcfgWithGP(String ptbroot, int gplevel, boolean tagpa) {
        Grammar g = new Grammar();
        Collection<Tree<String>> trees = PennTreebankReader.readTrees(ptbroot, 200, 2172);
        g.registerS("ROOT");
        int tcount = 0;
        for (Tree<String> tree : trees) {
            ++tcount;
            tree = new Trees.StandardTreeNormalizer().transformTree(tree);
            GPAnnotator annot = new GPAnnotator(gplevel, tagpa);
            tree = annot.transformTree(tree);
            for (Tree<String> tree2 : tree) {
                if (tree2.isLeaf()) continue;
                if (tree2.isPreTerminal()) {
                    int t = g.registerT(tree2.getLabel());
                    int tag = g.T2i(t);
                    List<String> yield = tree2.getYield();
                    String word = StringUtils.join(yield, " ");
                    g.incrSeenCount(word, tag, 1);
                    continue;
                }
                int lhs = g.registerNT(tree2.getLabel());
                int[] rhs = new int[tree2.getChildren().size()];
                int i = 0;
                for (Tree<String> c : tree2.getChildren()) {
                    rhs[i] = c.isPreTerminal() ? g.registerT(c.getLabel()) : g.registerNT(c.getLabel());
                    ++i;
                }
                Rule r = new Rule(lhs, rhs);
                g.incrSeenCount(r);
            }
        }
        System.out.println(String.valueOf(tcount) + " trees extracted.");
        return g;
    }

    public static Grammar extractPcfgWithAnnot(Trees.TreeTransformer<String> annot, String ptbroot) {
        Grammar g = new Grammar();
        Collection<Tree<String>> trees = PennTreebankReader.readTrees(ptbroot, 200, 2172);
        g.registerS("ROOT");
        int tcount = 0;
        for (Tree<String> tree : trees) {
            ++tcount;
            tree = new NPTmpRetainingTreeNormalizer().transformTree(tree);
            tree = annot.transformTree(tree);
            for (Tree<String> tree2 : tree) {
                if (tree2.isLeaf()) continue;
                if (tree2.isPreTerminal()) {
                    int t = g.registerT(tree2.getLabel());
                    int tag = g.T2i(t);
                    List<String> yield = tree2.getYield();
                    String word = StringUtils.join(yield, " ");
                    g.incrSeenCount(word, tag, 1);
                    continue;
                }
                int lhs = g.registerNT(tree2.getLabel());
                int[] rhs = new int[tree2.getChildren().size()];
                int i = 0;
                for (Tree<String> c : tree2.getChildren()) {
                    rhs[i] = c.isPreTerminal() ? g.registerT(c.getLabel()) : g.registerNT(c.getLabel());
                    ++i;
                }
                Rule r = new Rule(lhs, rhs);
                g.incrSeenCount(r);
            }
        }
        System.out.println(String.valueOf(tcount) + " trees extracted.");
        return g;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: <ptb directory> <output grammar name>");
            System.exit(1);
        }
        try {
            KMAnnotator annot = new KMAnnotator();
            Grammar g = AnnotPtbPcfgExtractor.extractPcfgWithAnnot(annot, args[0]);
            g.dumpGrammar(args[1]);
            System.out.println("Dumped");
            System.out.println();
            System.out.println("Unnormalaized grammar:");
            System.out.println("Rules : " + g.rules().size());
            System.out.println("Non-Terminals : " + g.nts().size());
            System.out.println("Preterminal Tags : " + g.ts().size());
            g.normalize();
            g.buildProb();
            g.lexicon().buildUWModel();
            System.out.println("Normalized");
            g.dumpGrammar(String.valueOf(args[1]) + "-normalized");
            System.out.println("Dumped normalized grammmar");
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(String.valueOf(args[1]) + ".gr"));
            oos.writeObject(g);
            System.out.println("Serialized");
            System.out.println();
            System.out.println("Normalaized grammar:");
            System.out.println("Rules : " + g.rules().size());
            System.out.println("Non-Terminals : " + g.nts().size());
            System.out.println("Preterminal Tags : " + g.ts().size());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class AUXAnnotator
    implements Trees.TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            ArrayList<Tree<String>> path = new ArrayList<Tree<String>>();
            path.add(tree);
            return this.transformTreeHelper(path);
        }

        private Tree<String> transformTreeHelper(List<Tree<String>> path) {
            Tree<String> node = path.get(0);
            if (node.isPreTerminal()) {
                String cat = node.getLabel();
                String baseCat = AnnotTmpRemover.transformLabel(node.getLabel());
                String word = StringUtils.join(node.getYield(), " ");
                Tree<String> parent = null;
                if (path.size() > 1) {
                    parent = path.get(1);
                }
                if (baseCat.equals("VBZ") || baseCat.equals("VBP") || baseCat.equals("VBD") || baseCat.equals("VBN") || baseCat.equals("VBG") || baseCat.equals("VB")) {
                    if (parent != null && (word.equalsIgnoreCase("'s") || word.equalsIgnoreCase("s"))) {
                        List<Tree<String>> sisters = parent.getChildren();
                        int i = 0;
                        while (i < sisters.size()) {
                            if (sisters.get(i).getLabel().startsWith("VBZ")) break;
                            ++i;
                        }
                        boolean annotateHave = false;
                        int j = i + 1;
                        while (j < sisters.size() && !annotateHave) {
                            if (sisters.get(j).getLabel().startsWith("VP")) {
                                for (Tree<String> kid : sisters.get(j).getChildren()) {
                                    if (!kid.getLabel().startsWith("VBN") && !kid.getLabel().startsWith("VBD")) continue;
                                    annotateHave = true;
                                    break;
                                }
                            }
                            ++j;
                        }
                        cat = annotateHave ? String.valueOf(cat) + "-HV" : String.valueOf(cat) + "-BE";
                    } else if (word.equalsIgnoreCase("am") || word.equalsIgnoreCase("is") || word.equalsIgnoreCase("are") || word.equalsIgnoreCase("was") || word.equalsIgnoreCase("were") || word.equalsIgnoreCase("'m") || word.equalsIgnoreCase("'re") || word.equalsIgnoreCase("be") || word.equalsIgnoreCase("being") || word.equalsIgnoreCase("been") || word.equalsIgnoreCase("ai")) {
                        cat = String.valueOf(cat) + "-BE";
                    } else if (word.equalsIgnoreCase("have") || word.equalsIgnoreCase("'ve") || word.equalsIgnoreCase("having") || word.equalsIgnoreCase("has") || word.equalsIgnoreCase("had") || word.equalsIgnoreCase("'d")) {
                        cat = String.valueOf(cat) + "-HV";
                    } else if (word.equalsIgnoreCase("do") || word.equalsIgnoreCase("did") || word.equalsIgnoreCase("does") || word.equalsIgnoreCase("done") || word.equalsIgnoreCase("doing")) {
                        cat = String.valueOf(cat) + "-DO";
                    }
                    node.setLabel(cat);
                }
            }
            for (Tree<String> child : node.getChildren()) {
                path.add(0, child);
                this.transformTreeHelper(path);
            }
            path.remove(0);
            return node;
        }
    }

    public static class AnnotRemover
    implements Trees.TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            if (tree.isLeaf()) {
                return tree;
            }
            String label = tree.getLabel();
            String cat = AnnotRemover.transformLabel(label);
            ArrayList children = new ArrayList();
            Tree<String> newtree = new Tree<String>(cat, children);
            for (Tree<String> child : tree.getChildren()) {
                children.add(this.transformTree(child));
            }
            return newtree;
        }

        public static String transformLabel(String annotlabel) {
            return annotlabel.split("@")[0];
        }
    }

    public static class AnnotTmpRemover
    implements Trees.TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            if (tree.isLeaf()) {
                return tree;
            }
            String label = tree.getLabel();
            String cat = AnnotTmpRemover.transformLabel(label);
            ArrayList children = new ArrayList();
            Tree<String> newtree = new Tree<String>(cat, children);
            for (Tree<String> child : tree.getChildren()) {
                children.add(this.transformTree(child));
            }
            return newtree;
        }

        public static String transformLabel(String annotlabel) {
            return annotlabel.split("@")[0].split("-")[0];
        }
    }

    public static class BNPAnnotator
    implements Trees.TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            if (this.isBaseNP(tree)) {
                tree.setLabel(String.valueOf(tree.getLabel()) + "-B");
            }
            for (Tree<String> child : tree.getChildren()) {
                this.transformTree(child);
            }
            return tree;
        }

        private boolean isBaseNP(Tree<String> tree) {
            if (tree.isLeaf() || tree.isPreTerminal()) {
                return false;
            }
            String cat = AnnotRemover.transformLabel(tree.getLabel());
            if (!cat.startsWith("NP")) {
                return false;
            }
            for (Tree<String> child : tree.getChildren()) {
                if (child.isPreTerminal()) continue;
                return false;
            }
            return true;
        }
    }

    public static class CCAnnotator
    implements Trees.TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            String word;
            if (tree.isLeaf()) {
                return tree;
            }
            if (tree.isPreTerminal() && tree.getLabel().startsWith("CC") && ((word = StringUtils.join(tree.getYield(), " ")).equals("and") || word.equals("or"))) {
                tree.setLabel(String.valueOf(tree.getLabel()) + "-C");
            }
            for (Tree<String> child : tree.getChildren()) {
                this.transformTree(child);
            }
            return tree;
        }
    }

    public static class DVAnnotator
    implements Trees.TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            if (tree.isLeaf() || tree.isPreTerminal()) {
                return tree;
            }
            boolean hasv = false;
            for (Tree<String> pt : tree.getPreTerminals()) {
                String tag = AnnotRemover.transformLabel(pt.getLabel());
                if (!tag.startsWith("V") && !tag.startsWith("MD")) continue;
                hasv = true;
                break;
            }
            if (hasv && !tree.getLabel().startsWith("ROOT")) {
                tree.setLabel(String.valueOf(tree.getLabel()) + "-v");
            }
            for (Tree<String> child : tree.getChildren()) {
                this.transformTree(child);
            }
            return tree;
        }
    }

    public static class DummyDelimAnnotator
    implements Trees.TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            if (!tree.isLeaf() && !tree.getLabel().equals("ROOT")) {
                tree.setLabel(String.valueOf(tree.getLabel()) + "@");
            }
            for (Tree<String> child : tree.getChildren()) {
                this.transformTree(child);
            }
            return tree;
        }
    }

    public static class GPAnnotator
    implements Trees.TreeTransformer<String> {
        private int _gplevel = 2;
        private boolean _tagpa = false;

        public GPAnnotator(int gplevel) {
            this._gplevel = gplevel;
        }

        public GPAnnotator(int gplevel, boolean tagpa) {
            this(gplevel);
            this._tagpa = tagpa;
        }

        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            ArrayList<Tree<String>> path = new ArrayList<Tree<String>>();
            path.add(tree);
            Tree<String> newtree = this.transformTree(path);
            return newtree;
        }

        @Override
        public Tree<String> transformTree(List<Tree<String>> path) {
            Tree<String> oldnode = path.get(0);
            if (oldnode.isLeaf() || oldnode.isPreTerminal() && !this._tagpa) {
                path.remove(0);
                return oldnode;
            }
            StringBuffer sb = new StringBuffer(oldnode.getLabel());
            int i = 1;
            while (i <= this._gplevel && i < path.size()) {
                sb.append("^");
                sb.append(AnnotTmpRemover.transformLabel(path.get(i).getLabel()));
                ++i;
            }
            ArrayList children = new ArrayList();
            Tree<String> newnode = new Tree<String>(sb.toString());
            newnode.setChildren(children);
            for (Tree<String> child : oldnode.getChildren()) {
                path.add(0, child);
                children.add(this.transformTree(path));
            }
            path.remove(0);
            return newnode;
        }
    }

    public static class INAnnotator
    implements Trees.TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            ArrayList<Tree<String>> path = new ArrayList<Tree<String>>();
            path.add(tree);
            return this.transformTreeHelper(path);
        }

        public Tree<String> transformTreeHelper(List<Tree<String>> path) {
            Tree<String> node = path.get(0);
            if (node.isPreTerminal() && node.getLabel().startsWith("IN")) {
                String gpstr;
                String cat = node.getLabel();
                Tree<String> parent = null;
                if (path.size() > 1) {
                    parent = path.get(1);
                }
                Tree<String> gparent = null;
                if (path.size() > 2) {
                    gparent = path.get(2);
                }
                String pstr = parent != null ? parent.getLabel() : "";
                String string = gpstr = gparent != null ? gparent.getLabel() : "";
                if (gpstr.startsWith("N") && (pstr.startsWith("P") || pstr.startsWith("A"))) {
                    cat = String.valueOf(cat) + "-N";
                } else if (pstr.startsWith("Q") && (gpstr.startsWith("N") || gpstr.startsWith("ADJP"))) {
                    cat = String.valueOf(cat) + "-Q";
                } else if (gpstr.startsWith("S@")) {
                    cat = pstr.startsWith("SBAR") ? String.valueOf(cat) + "-SCC" : String.valueOf(cat) + "-SC";
                } else if (pstr.startsWith("SBAR") || pstr.startsWith("WHNP")) {
                    cat = String.valueOf(cat) + "-T";
                }
                node.setLabel(cat);
            }
            for (Tree<String> child : node.getChildren()) {
                path.add(0, child);
                this.transformTreeHelper(path);
            }
            path.remove(0);
            return node;
        }
    }

    public static class KMAnnotator
    implements Trees.TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            tree = new DummyDelimAnnotator().transformTree(tree);
            tree = new GPAnnotator(1, true).transformTree(tree);
            tree = new UIAnnotator().transformTree(tree);
            tree = new UDTAnnotator().transformTree(tree);
            tree = new URBAnnotator().transformTree(tree);
            tree = new INAnnotator().transformTree(tree);
            tree = new AUXAnnotator().transformTree(tree);
            tree = new CCAnnotator().transformTree(tree);
            tree = new PercentAnnotator().transformTree(tree);
            tree = new NPTMPAnnotator().transformTree(tree);
            tree = new PossAnnotator().transformTree(tree);
            tree = new VPAnnotator().transformTree(tree);
            tree = new BNPAnnotator().transformTree(tree);
            tree = new DVAnnotator().transformTree(tree);
            tree = new RRNPAnnotator().transformTree(tree);
            return tree;
        }
    }

    public static class NPTMPAnnotator
    implements Trees.TreeTransformer<String> {
        CollinsHeadFinder headFinder = new CollinsHeadFinder();

        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            if (tree.isLeaf()) {
                return tree;
            }
            if (AnnotRemover.transformLabel(tree.getLabel()).equals("NP-TMP")) {
                this.annotateTmpRec(tree);
            }
            for (Tree<String> child : tree.getChildren()) {
                this.transformTree(child);
            }
            return tree;
        }

        private void annotateTmpRec(Tree<String> tree) {
            Tree<String> t = this.headFinder.determineHead(tree);
            while (t != null && !t.isLeaf()) {
                if (t.isPreTerminal()) {
                    t.setLabel(String.valueOf(t.getLabel()) + "^TMP");
                    return;
                }
                t = this.headFinder.determineHead(t);
            }
        }
    }

    public static class NPTmpRetainingTreeNormalizer
    implements Trees.TreeTransformer<String> {
        Trees.EmptyNodeStripper emptyNodeStripper = new Trees.EmptyNodeStripper();
        Trees.XOverXRemover<String> xOverXRemover = new Trees.XOverXRemover();
        Trees.NPTmpRetainingFunctionNodeStripper functionNodeStripper = new Trees.NPTmpRetainingFunctionNodeStripper();

        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            tree = this.functionNodeStripper.transformTree(tree);
            tree = this.emptyNodeStripper.transformTree(tree);
            tree = this.xOverXRemover.transformTree(tree);
            return tree;
        }
    }

    public static class PercentAnnotator
    implements Trees.TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            if (tree.isLeaf()) {
                return tree;
            }
            if (tree.isPreTerminal() && StringUtils.join(tree.getYield(), " ").equals("%")) {
                tree.setLabel(String.valueOf(tree.getLabel()) + "-%");
            }
            for (Tree<String> child : tree.getChildren()) {
                this.transformTree(child);
            }
            return tree;
        }
    }

    public static class PossAnnotator
    implements Trees.TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            if (tree.isLeaf() || tree.isPreTerminal()) {
                return tree;
            }
            if (tree.getLabel().startsWith("NP") && tree.getChildren().get(tree.getChildren().size() - 1).getLabel().startsWith("POS")) {
                tree.setLabel(String.valueOf(tree.getLabel()) + "-P");
            }
            for (Tree<String> child : tree.getChildren()) {
                this.transformTree(child);
            }
            return tree;
        }
    }

    public static class RRNPAnnotator
    implements Trees.TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            if (RRNPAnnotator.rightRecNP(tree)) {
                tree.setLabel(String.valueOf(tree.getLabel()) + "-RN");
            }
            for (Tree<String> child : tree.getChildren()) {
                this.transformTree(child);
            }
            return tree;
        }

        /*
         * Unable to fully structure code
         */
        private static boolean rightRecNP(Tree<String> t) {
            if (t.isLeaf() || t.isPreTerminal()) {
                return false;
            }
            cat = AnnotRemover.transformLabel(t.getLabel());
            if (cat.startsWith("NP")) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                str = (t = t.getChildren().get(t.getChildren().size() - 1)).getLabel();
                if (!str.startsWith("NP")) continue;
                return true;
lbl9:
                // 2 sources

                ** while (!t.isLeaf())
            }
lbl10:
            // 1 sources

            return false;
        }
    }

    public static class UDTAnnotator
    implements Trees.TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            return this.transformTreeHelper(tree, true);
        }

        private Tree<String> transformTreeHelper(Tree<String> tree, boolean nosibling) {
            if (tree.isLeaf()) {
                return tree;
            }
            for (Tree<String> child : tree.getChildren()) {
                this.transformTreeHelper(child, tree.getChildren().size() == 1);
            }
            if (tree.isPreTerminal() && tree.getLabel().startsWith("DT") && nosibling) {
                tree.setLabel(String.valueOf(tree.getLabel()) + "^U");
            }
            return tree;
        }
    }

    public static class UIAnnotator
    implements Trees.TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            if (tree.isLeaf() || tree.isPreTerminal()) {
                return tree;
            }
            for (Tree<String> child : tree.getChildren()) {
                this.transformTree(child);
            }
            if (tree.getChildren().size() == 1 && !tree.getLabel().startsWith("ROOT")) {
                tree.setLabel(String.valueOf(tree.getLabel()) + "-U");
            }
            return tree;
        }
    }

    public static class URBAnnotator
    implements Trees.TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            return this.transformTreeHelper(tree, true);
        }

        private Tree<String> transformTreeHelper(Tree<String> tree, boolean nosibling) {
            if (tree.isLeaf()) {
                return tree;
            }
            for (Tree<String> child : tree.getChildren()) {
                this.transformTreeHelper(child, tree.getChildren().size() == 1);
            }
            if (tree.isPreTerminal() && tree.getLabel().startsWith("RB") && nosibling) {
                tree.setLabel(String.valueOf(tree.getLabel()) + "^U");
            }
            return tree;
        }
    }

    public static class VPAnnotator
    implements Trees.TreeTransformer<String> {
        private CollinsHeadFinder headFinder = new CollinsHeadFinder();

        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            if (tree.isLeaf() || tree.isPreTerminal()) {
                return tree;
            }
            String cat = tree.getLabel();
            String baseCat = AnnotTmpRemover.transformLabel(cat);
            String baseTag = AnnotTmpRemover.transformLabel(this.headFinder.determineHead(tree).getLabel());
            if (baseCat.equals("VP")) {
                if (baseTag.equals("VBZ") || baseTag.equals("VBD") || baseTag.equals("VBP") || baseTag.equals("MD")) {
                    cat = String.valueOf(cat) + "-VBF";
                } else if (baseTag.equals("TO") || baseTag.equals("VBG") || baseTag.equals("VBN") || baseTag.equals("VB")) {
                    cat = String.valueOf(cat) + "-" + baseTag;
                }
                tree.setLabel(cat);
            }
            for (Tree<String> child : tree.getChildren()) {
                this.transformTree(child);
            }
            return tree;
        }
    }
}

