/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.Exceptions;
import fig.basic.Fmt;
import fig.prob.Dirichlet;
import fig.prob.DirichletInterface;
import fig.prob.Distrib;
import fig.prob.SuffStats;
import java.util.Random;

public class DegenerateDirichlet
implements DirichletInterface {
    private double[] value;

    public DegenerateDirichlet(double[] value) {
        this.value = value;
    }

    @Override
    public double[] getMean() {
        return this.value;
    }

    @Override
    public double[] getMode() {
        return this.value;
    }

    @Override
    public double getAlpha(int i) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double totalCount() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double logProb(SuffStats stats) {
        throw Exceptions.unsupported;
    }

    @Override
    public double logProbObject(double[] x) {
        throw Exceptions.unsupported;
    }

    @Override
    public double[] sampleObject(Random random) {
        return this.value;
    }

    @Override
    public double crossEntropy(Distrib<double[]> _that) {
        if (_that instanceof DegenerateDirichlet) {
            return 0.0;
        }
        Dirichlet that = (Dirichlet)_that;
        return that.logProb(this.value);
    }

    @Override
    public double expectedLog(int i) {
        return Math.log(this.value[i]);
    }

    @Override
    public double[] expectedLog() {
        double[] result = new double[this.dim()];
        int i = 0;
        while (i < this.dim()) {
            result[i] = this.expectedLog(i);
            ++i;
        }
        return result;
    }

    @Override
    public DirichletInterface modeSpike() {
        return this;
    }

    @Override
    public int dim() {
        return this.value.length;
    }

    public String toString() {
        return String.format("DegenerateDirichlet(%s)", Fmt.D(this.value));
    }
}

