/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.syntax;

import LinguaView.TreePanel;
import LinguaView.syntax.TSNodeLabel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;

@Deprecated
public class ConstTreePanelD
extends TreePanel<TSNodeLabel> {
    int sentenceLength;
    int nodesCount;
    IdentityHashMap<TSNodeLabel, Integer> indexTable;
    TSNodeLabel[] nodesArray;
    TSNodeLabel[] lexicalsArray;
    String[] labelArray;
    int[] XLeftArray;
    int[] YArray;
    int[] XMiddleArray;
    int[] wordLengthsArray;
    public boolean skewedLines = true;

    public ConstTreePanelD() {
    }

    public ConstTreePanelD(ArrayList<TSNodeLabel> treebank) {
        this.loadTreebank(treebank);
    }

    public void setSentenceNumber(int sn) {
        this.sentenceNumber = sn;
    }

    @Override
    public void init() {
        this.loadFont();
        this.loadSentence();
        this.setPreferredSize(this.area);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void render(Graphics2D g2) {
        g2.setFont(this.font);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke());
        if (this.indexTable != null) {
            TSNodeLabel[] tSNodeLabelArray = this.nodesArray;
            int n = this.nodesArray.length;
            int n2 = 0;
            while (n2 < n) {
                TSNodeLabel n3 = tSNodeLabelArray[n2];
                int i = this.indexTable.get(n3);
                g2.drawString(this.labelArray[i], this.XLeftArray[i], this.YArray[i]);
                TSNodeLabel p = n3.parent;
                if (p != null) {
                    int pIndex = this.indexTable.get(p);
                    this.drawLine(this.XMiddleArray[i], this.YArray[i] - this.fontSize - this.textTipMargin, this.XMiddleArray[pIndex], this.YArray[pIndex] + this.textTipMargin, g2);
                }
                ++n2;
            }
        }
    }

    public void renderText(Graphics2D g2, String text) {
        g2.setFont(this.font);
        g2.setColor(Color.black);
        g2.drawString(text, 0, 0);
    }

    private void drawLine(int x1, int y1, int x2, int y2, Graphics2D g2) {
        if (!this.skewedLines) {
            int yM = y1 + (y2 - y1) / 2;
            g2.drawLine(x1, y1, x1, yM);
            g2.drawLine(x1, yM, x2, yM);
            g2.drawLine(x2, yM, x2, y2);
        } else {
            g2.drawLine(x1, y1, x2, y2);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.render(g2);
    }

    @Override
    public void loadSentence() {
        TSNodeLabel t = (TSNodeLabel)this.treebank.get(this.sentenceNumber);
        if (t.label == null) {
            this.sentenceLength = 0;
            this.nodesCount = 0;
            this.indexTable = null;
            this.nodesArray = null;
            this.lexicalsArray = null;
            this.labelArray = null;
            this.XLeftArray = null;
            this.YArray = null;
            this.XMiddleArray = null;
            this.wordLengthsArray = null;
            this.area.width = 0;
            this.area.height = 0;
            return;
        }
        this.indexTable = new IdentityHashMap();
        this.nodesCount = t.countAllNodes();
        this.sentenceLength = t.countLexicalNodes();
        this.lexicalsArray = t.collectLexicalItems().toArray(new TSNodeLabel[this.sentenceLength]);
        this.nodesArray = t.collectAllNodes().toArray(new TSNodeLabel[this.nodesCount]);
        int maxDepth = t.maxDepth();
        int i = 0;
        while (i < this.nodesCount) {
            TSNodeLabel n = this.nodesArray[i];
            this.indexTable.put(n, i);
            ++i;
        }
        this.labelArray = new String[this.nodesCount];
        this.XLeftArray = new int[this.nodesCount];
        this.XMiddleArray = new int[this.nodesCount];
        this.wordLengthsArray = new int[this.nodesCount];
        Arrays.fill(this.XLeftArray, -1);
        this.YArray = new int[this.nodesCount];
        int treeWidth = 0;
        int previousWordLength = 0;
        int previousXLeft = this.leftMargin;
        int j = 0;
        while (j < this.sentenceLength) {
            int wordLengthColumn;
            TSNodeLabel n = this.lexicalsArray[j];
            int i2 = this.indexTable.get(n);
            this.labelArray[i2] = n.label();
            int wordLength = this.metrics.stringWidth(this.labelArray[i2]);
            this.wordLengthsArray[i2] = wordLengthColumn = this.getWordLengthColumn(n, wordLength);
            this.XMiddleArray[i2] = wordLengthColumn / 2 + previousXLeft + previousWordLength + this.wordSpace;
            this.XLeftArray[i2] = this.XMiddleArray[i2] - wordLength / 2;
            this.YArray[i2] = (int)((double)(this.topMargin + this.fontHight) + (double)n.level() * this.levelSize);
            previousWordLength = wordLengthColumn;
            previousXLeft = this.XLeftArray[i2];
            if (j == this.sentenceLength - 1) {
                treeWidth = previousXLeft + previousWordLength + this.wordSpace;
            }
            ++j;
        }
        TSNodeLabel[] tSNodeLabelArray = this.nodesArray;
        int n = this.nodesArray.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel n3 = tSNodeLabelArray[n2];
            if (!n3.isLexical) {
                int i3 = this.indexTable.get(n3);
                this.updateValues(n3, i3);
            }
            ++n2;
        }
        int treeHeight = (int)((double)(this.topMargin + this.fontHight) + (double)maxDepth * this.levelSize + (double)this.bottomMargin);
        this.area.width = treeWidth += this.rightMargin;
        this.area.height = treeHeight;
    }

    private int getWordLengthColumn(TSNodeLabel n, int wordLength) {
        while (n.parent != null && n.isUniqueDaughter()) {
            n = n.parent;
            int length = this.metrics.stringWidth(n.label());
            if (length <= wordLength) continue;
            wordLength = length;
        }
        return wordLength;
    }

    private void updateValues(TSNodeLabel n, int i) {
        int wordLength;
        if (this.XLeftArray[i] != -1) {
            return;
        }
        this.labelArray[i] = n.label();
        this.YArray[i] = (int)((double)(this.topMargin + this.fontHight) + (double)n.level() * this.levelSize);
        this.wordLengthsArray[i] = wordLength = this.metrics.stringWidth(this.labelArray[i]);
        TSNodeLabel[] daughters = n.daughters;
        TSNodeLabel firstDaughter = n.daughters[0];
        int iDF = this.indexTable.get(firstDaughter);
        if (!firstDaughter.isLexical) {
            this.updateValues(firstDaughter, iDF);
        }
        if (daughters.length == 1) {
            this.XMiddleArray[i] = this.XMiddleArray[iDF];
            this.XLeftArray[i] = this.XMiddleArray[i] - wordLength / 2;
        } else {
            TSNodeLabel lastDaughter = n.daughters[n.prole() - 1];
            int iDL = this.indexTable.get(lastDaughter);
            if (!lastDaughter.isLexical) {
                this.updateValues(lastDaughter, iDL);
            }
            this.XMiddleArray[i] = this.XLeftArray[iDF] + (this.XLeftArray[iDL] + this.wordLengthsArray[iDL] - this.XLeftArray[iDF]) / 2;
            this.XLeftArray[i] = this.XMiddleArray[i] - wordLength / 2;
        }
    }

    public TSNodeLabel getSentence(int n) {
        return (TSNodeLabel)this.treebank.get(n);
    }
}

