///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <fstream>
#include <sstream>
#include <getopt.h>

#include "nl-randvar.h"
#include "nl-dtree.h"
#include "nl-iomacros.h"
#include "nl-refrv.h"
//#include "nl-modelfile.h"

//char psX[]="";
//char psUscUscUsc[]="___";

//#define NOISY 1

#define THRESHOLD 0.0

////////////////////////////////////////////////////////////////////////////////
//
//  Random Variables
//
////////////////////////////////////////////////////////////////////////////////

#include "TextObsVars.h"
#include "PCFGLangModel-vecmd-rlnclust.h"
#include "TextObsModel-svs.h"

////////////////////////////////////////////////////////////////////////////////
//
//  helper classes, functions
//
////////////////////////////////////////////////////////////////////////////////

bool NOISY = false;
bool VERYNOISY = false;
bool PROBS = false;
bool EVALVEC = false;

class ChartCell {
 private:
  static const ChartCell ccDummy;
  bool             bRooted;
  GE                ge;
  int              k;
  const ChartCell* pcc1;
  const ChartCell* pcc2;
  LogProb          pr; // max
 public:
  ChartCell ( )                                                                                : bRooted(false), ge(),    k(0),  pcc1(NULL), pcc2(NULL), pr()    { }
  ChartCell (       GE& geA,                                                     LogProb prA ) : bRooted(false), ge(geA), k(0),  pcc1(NULL), pcc2(NULL), pr(prA) { }
  ChartCell (       GE& geA,         const ChartCell& cc1,                       LogProb prA ) : bRooted(false), ge(geA), k(0),  pcc1(&cc1), pcc2(NULL), pr(prA) { }
  ChartCell (       GE& geA, int kA, const ChartCell& cc1, const ChartCell& cc2, LogProb prA ) : bRooted(false), ge(geA), k(kA), pcc1(&cc1), pcc2(&cc2), pr(prA) { }
  ChartCell ( const GE& geA, int kA, const ChartCell& cc1, const ChartCell& cc2, LogProb prA ) : bRooted(false), ge(geA), k(kA), pcc1(&cc1), pcc2(&cc2),  pr(prA) { }
  void setRooted ( )       { bRooted=true; }
  bool getRooted ( ) const { return bRooted; }
  bool operator!= ( const ChartCell& cc ) const { return (ge!=cc.ge || k!=cc.k || pcc1!=cc.pcc1 || pcc2!=cc.pcc2 || pr!=cc.pr); }
  const GE&        getGE   ( ) const { return ge;  }
  int              getK    ( ) const { return k;  }
  const UDLC&      getUDLC ( ) const { return ge.first; }
  const Evec&      getE    ( ) const { return ge.second; }
  const ChartCell& getCC1  ( ) const { return (pcc1!=NULL) ? *pcc1 : ccDummy; }
  const ChartCell& getCC2  ( ) const { return (pcc2!=NULL) ? *pcc2 : ccDummy; }
  LogProb          maxProb ( ) const { return pr; }
  void prune      ( ) { /*???*/ }
  void writeBest  ( FILE* pf, List<X>& lx ) const { 
    //fprintf(pf," (%s:%s{%s}",ge.first.second.first.getString().c_str(),ge.first.second.second.getString().c_str(),
    //ge.second.argmax().first.getString().c_str()); // SUSPECT
    fprintf(pf," (%s:%s",ge.first.second.first.getString().c_str(),ge.first.second.second.getString().c_str());
    if(pcc1)pcc1->writeBest(pf,lx);
    if(pcc2)pcc2->writeBest(pf,lx);
    if(!pcc1 && !pcc2){fprintf(pf," ");fprintf(pf,"%s",lx.getFirst()->getString().c_str());lx.pop();}
    fprintf(pf,")"); }
  void writePVitVecs  ( FILE* pf, List<X>& lx ) const { 
    if(pcc1)pcc1->writePVitVecs(pf,lx);
    if(pcc2)pcc2->writePVitVecs(pf,lx);
    if(!pcc1 && !pcc2){ cout<<getE()<<((lx.getCard()==1)?"":";"); lx.pop(); }
  }
  void writePath  ( FILE* pf, List<X>& lx ) const { 
    //fprintf(pf," (%s:%s{%s}",ge.first.second.first.getString().c_str(),ge.first.second.second.getString().c_str(),
    //ge.second.argmax().first.getString().c_str()); // SUSPECT
    fprintf(pf," (%s:%s[%d]",ge.first.second.first.getString().c_str(),ge.first.second.second.getString().c_str(),pr.toInt());
    if(pcc1)pcc1->writePath(pf,lx);
    if(pcc2)pcc2->writePath(pf,lx);
    if(!pcc1 && !pcc2){fprintf(pf," ");fprintf(pf,"%s",lx.getFirst()->getString().c_str());lx.pop();}
    fprintf(pf,")"); }
};
const ChartCell ChartCell::ccDummy;

////////////////////////////////////////////////////////////////////////////////

typedef SimpleHash<UDLC,ChartCell> RefCell;
//std::map<G2Cell,G2Cell> domCell;
//typedef RefRV<G2Cell,domCell> RefCell;
//typedef SafePtr<G2Cell> RefCell;
//typedef pair<G,ChartCell> GCell;
//std::map<GCell,GCell> domCell;
//typedef RefRV<GCell,domCell> RefCell;


////////////////////////////////////////////////////////////////////////////////

// NOTE: unary rules deprecated
void tryUnary ( SafeArray2D<Id<int>,Id<int>,RefCell>& accChart, int i, int j, const ChartCell& ccGE, const GEuModel& modGEgivGE ) {
  /*
    GE geP;
    //  for ( bool bgep=geP.setFirst(); bgep; bgep=geP.setNext() ) {
    for ( GEuModel::const_iterator iter = modGEgivGE.begin(); iter!=modGEgivGE.end(); iter++ ) {
    GE          geP = iter->first.getX1();
    GE          gege = xGE.getGE();
    ChartCell& xP = axChart.set(i,j).set(geP.first);
    LogProb    pr = modGEgivGE.getProb(gege,geP) * xGE.maxProb(); //diag( modGEgivGE.getVec(gege,geP) ) * xGE.getE(); // does not work
    if ( pr>xP.maxProb() ) {
    xP = ChartCell(geP,xGE,pr);
    if ( NOISY )
    cout << "unary match! " << i << " " << j << " " << geP.first << " -> " << gege.first << " -> " << pr.toInt() << endl;
    tryUnary ( axChart, i, j, xP, modGEgivGE );
    }
    }
  */
}


////////////////////////////////////////////////////////////////////////////////
//
//  Main Function (pipe data input)
//
////////////////////////////////////////////////////////////////////////////////

static struct option long_options[] = {
  {"forest", optional_argument, 0, 'f'},
  {"help", no_argument, 0, 'h'},
  {"verbose", no_argument, 0, 'v'},
  {0, 0, 0, 0} };

void printUsage(char* progname) {
  fprintf(stderr,"Usage: cat <RAW_FILE> | %s [OPTIONS]... [MODEL_FILE1] [MODEL_FILE2] ...\n",progname);
  fprintf(stderr,"Runs the speech recognition system on RAW_FILE using the models in MODEL_FILE1, 2, etc.\n");
  fprintf(stderr," System variable Settings:\n");
  fprintf(stderr,"  -f, --forest=TRUE\n");
  fprintf(stderr,"  -h, --help\t\tPrint this message\n");
  fprintf(stderr,"  -v, --verbose=TRUE\n");
  fprintf(stderr,"  -V, --veryverbose=TRUE\n");
  fprintf(stderr,"  -p, --printprobs=TRUE\n");
  fprintf(stderr,"  -e, --evalvecs=TRUE\n");
}

int main (int nArgs, char* argv[]) {

  //modGEgivGE.NOISY_READ = true;

  bool FOREST = false;

  //GEGEModel modGEGEgivGE;
  MModel  modM;
  LModel  modL;
  GEuModel modGEgivGE;
  GErModel modGEr;
  GEModel  modGE;
  LCModel modLC;
  IModel  modI;
  //HModel  modH;
  XModel  modX;
  //OModel  mO;

  // Parse command-line options
  char* progname = strdup(argv[0]);
  int option_index = 0;
  char opt;
  while( (opt = getopt_long(nArgs, argv, "fhvVpe", long_options, &option_index)) != -1 ) {
    switch(opt) {
    case 'f': FOREST=true; break;
    case 'h': printUsage(progname); exit(0);
    case 'v': NOISY=true; break;
    case 'V': VERYNOISY=true; NOISY=true; break;
    case 'p': PROBS=true; break;
    case 'e': EVALVEC=true; break;
    default: break;
    }
  }

  for ( int a=optind; a<nArgs; a++ ) {
    FILE* pf = fopen(argv[a],"r"); assert(pf);                                // READ MODEL FILE
    cerr << "Loading model \'" << argv[a] << "\'...\n";
    int c=' '; int i=0; int line=1; Array<char*> aps(100); String sBuff(1000);   // Lookahead/ctrs/buffers
    CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                   // Get to first record
    while ( c!=-1 && c!='\0' && c!='\5' ) {                                      // For each record
      CONSUME_STR ( pf, c, (c!='\n' && c!='\0' && c!='\5'), sBuff, i, line );    //   Consume line
      String sBuff2(sBuff); StringInput si(sBuff2.c_array());
      //sBuff.split(aps," :=");                                                  //   Split into fields
      //cerr<<si.c_str()<<endl;
      if ( !( sBuff[0]=='#' ||                                                   //   Accept comments/fields
              //si>>mH>>"\0"!=NULL ||
	      si>>"M_SIZE ">>M_SIZE>>"\0"!=NULL ||
              si>>modX>>"\0"!=NULL ||
              //si>>mO>>"\0"!=NULL ||
	      si>>"LC ">>modLC>>"\0"!=NULL || 
	      si>>"Gr ">>modGEr>>"\0"!=NULL || 
	      si>>"G ">>modGE>>"\0"!=NULL || 
	      //si>>"Gu ">>modGgivG>>"\0"!=NULL || 
	      //si>>"GG ">>modGGgivG>>"\0"!=NULL ) )
	      si>>"HW ">>modI>>"\0"!=NULL || 
	      //si>>"H ">>modH>>"\0"!=NULL ||
	      si>>"M ">>modM>>"\0"!=NULL || 
	      si>>"L ">>modL>>"\0"!=NULL ) )
	//si>>"Pc ">>modPgivCvar>>"\0"!=NULL ||
	//si>>"Pw ">>modPgivWs>>"\0"!=NULL ||
	//si>>"PwDT ">>modPgivWdt>>"\0"!=NULL ||
	//si>>"P ">>modP>>"\0"!=NULL ) )
	////mH.readFields(aps) || mO.readFields(aps)*/ ) )
	//	cerr<<"\nERROR: "<<aps.size()<<"-arg "<<((aps.size()>0)?aps[0]:"??")<<" in line "<<line<<"\n\n";
	cerr<<"\nERROR: can't parse \'"<<sBuff<<"\' in line "<<line<<"\n\n";
      CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                 //   Consume whitespace
      if ( line%100000==0 ) cerr<<"  "<<line<<" lines read...\n";                //   Progress for big models
    }
    cerr << "Model \'" << argv[a] << "\' loaded.\n";
  }
  //   for ( int i=optind; i<nArgs; i++ ) {
  //     cerr << "Loading model \'" << argv[i] << "\'\n";
  //     FILE* pf = fopen(argv[i],"r"); 
  //     assert(pf);
  //     processModelFilePtr ( pf, readFields );
  //     cerr << "Model \'" << argv[i] << "\' loaded.\n";
  //   }

  ifstream fin;
  List<X>  lx;
  string   sLine;
  int ctr=0;
  IndexedVector N_1 ( M_SIZE.getInt(), 1, Prob(1.0) );

  //  if (nArgs>2) fin.open(argv[2]);

  // Read in each line...
  //  while ( (nArgs>2) ? getline(fin,sLine) : getline(cin,sLine) ) {
  while ( getline(cin,sLine) ) {
    ctr++;
    cerr << ctr ;

    // Read in each word...
    stringstream ss(stringstream::in|stringstream::out);
    lx=List<X>();
    ss<<sLine;
    for (string s; ss>>s; ) {
      cerr << " " << s;
      lx.add() = X(s.c_str()); //.read(s);
    }

    cerr << endl;

    // Allocate chart...
    SafeArray2D<Id<int>,Id<int>,RefCell> accChart;
    int n = lx.getCard();
    accChart.init ( n+1, n+2 );

    // Initialize chart with terminals (POSs)...
    int i=0;
    Listed(X)* px;
    foreach(px,lx) {

      //OModel::RandVarType w; w.set(*pw,mO);
      X& x = *px;
      if ( NOISY )
        cerr << "word " << px->getString() << endl;
      GE ge;

      for ( MModel::const_iterator iudlclclc = modM.begin(); iudlclclc!=modM.end(); iudlclclc++ ) {
        const UDLC& udlc = iudlclclc->first.first;
        const LCLC& lclc = iudlclclc->first.second;
        if ( LCLC_BOT == lclc ) {
          IndexedVector v(M_SIZE.getInt(),1);
          for ( I vi; vi<M_SIZE.getInt(); ++vi ) {
            v.set(vi,I()) = /* iudlclclc->second.get(vi,0) * */ modX.getProb(x,udlc.second.second,vi);
          }
          if ( v.infnorm() != Prob() ) {
            Evec e = v;
            ge = GE( udlc, e );
            ChartCell* pcc = &accChart.set(i,i+1).set(udlc);
            *pcc = ChartCell ( ge, ge.second.infnorm() );
            //tryUnary ( axChart, i, i+1, *px, modGgivG );
            if ( VERYNOISY )
              cerr << "pos match! " << i << " " << i+1 << " " << ge.first << " -> " << px->getString()
                   << " = " << pcc->maxProb().toInt() << endl;
            // TEMPORARILY DISABLE
            // if ( FOREST )
            // fprintf ( stdout, "%d %s:%s{%s} %d : %d %s %d = %d\n",
            // i, g.second.first.getString().c_str(), g.second.second.getString().c_str(), g.second.third.getString().c_str(), i+1,
            // i, pw->getString().c_str(), i+1, w.getProb(g.second.second,g.second.third).toInt() );            
          }
        }
      }

      /*
      // Consider the possible hw, then words, generated by each referent
      for ( HModel::const_iterator iudlc = modH.begin(); iudlc!=modH.end(); iudlc++ ) {
        //I iP = I(iudlc->first.getH1().second);
        UDLC udlc = UDLC(iudlc->first);
        if (udlc.second.second.getTerm()==B_0) { continue; }  // non-terms never generate words
        H h(pw->getString().c_str());

        Evec e(M_SIZE.getInt(),1);
        if (HModel::hlch.get(udlc).contains(H_UNK))
          e = HModel::hlch.get(udlc).get(H_UNK) * w.getProb(udlc.second.second).toProb();
        if (HModel::hlch.get(udlc).contains(h))
          e = e + HModel::hlch.get(udlc).get(h);

        if (e.infnorm()==Prob()) { 
          //cerr<<" WARNING: in pos search, category ["<<udlc<<"] never matched a referent. h="<<h<<" p_unk="<< w.getProb(udlc.second.second).toProb()<<" max(e)="<<e.infnorm()<<endl; 
          continue; 
        } 
        //else { cerr<<" no warning for ["<<udlc<<"] h="<<h<<" p_unk="<<w.getProb(udlc.second.second).toProb()<<" max(e)="<<e.infnorm()<<endl; }
          
        g = G( udlc, e );

        ChartCell* px = &axChart.set(i,i+1).set(udlc);
        *px = ChartCell ( g, g.second.infnorm() );
        //tryUnary ( axChart, i, i+1, *px, modGgivG );
        if ( NOISY )
          cerr << "pos match! " << i << " " << i+1 << " " << g.first << " -> " << pw->getString()
               << " = " << px->maxProb().toInt() << endl;
        // TEMPORARILY DISABLE
        // if ( FOREST )
        // fprintf ( stdout, "%d %s:%s{%s} %d : %d %s %d = %d\n",
        // i, g.second.first.getString().c_str(), g.second.second.getString().c_str(), g.second.third.getString().c_str(), i+1,
        // i, pw->getString().c_str(), i+1, w.getProb(g.second.second,g.second.third).toInt() );
      }
      */

      i++;
    }

    //if ( false )

    // Fill chart with nonterminals...
    for ( int di=1; di<=n; di++ ) {
      cerr << "  " << di << endl;
      for ( int i=0; i<=n-di; i++ ) {
        int j=i+di;

	// consider the best children for each head, regardless of split point
	CPT1DModel<UDLC,LogProb> maxProb;
        for ( int k=i+1; k<=j-1; k++ ) {

	  //// Check/fill the chart
          for ( MModel::const_iterator iudlclclc = modM.begin(); iudlclclc!=modM.end(); iudlclclc++ ) {
            UDLC udlcP = iudlclclc->first.first;
	    LCLC lclc  = iudlclclc->first.second;
	    UDLCLCLC udlclclc = UDLCLCLC(udlcP,lclc);

	    D  dL = (udlcP.first.first==U_R) ? D(udlcP.first.second.toInt()+1) : D(udlcP.first.second.toInt());
	    UD udL( U_L, dL );
	    UD udR( U_R, udlcP.first.second );
            //UD udL(U_L,D("1"));
            //UD udR(U_L,D("1"));
	    UDL  udlLeft  = UDL( udL, lclc.first.first );
	    UDL  udlRight = UDL( udR, lclc.second.first );

	    UDLC udlc1 = UDLC(udL,lclc.first);
	    UDLC udlc2 = UDLC(udR,lclc.second);
		
	    //cerr  << i << "," << k << "," << j << " found M rule "<< udlcP << " -> " << lclc << endl;
	    const ChartCell& cc1 = accChart.get(i,k).get(udlc1);
	    const ChartCell& cc2 = accChart.get(k,j).get(udlc2);
	    if ( cc1!=ChartCell() && cc2!=ChartCell() ) {
	      //cerr << " binary possible! " << i << " " << k << " " << j << " " << udlcP
	      //<< " -> " << cc1.getUDLC().first << " " << cc2.getUDLC().first << " with matrices\n  e1="
	      //<< cc1.getE() << "  and e2=" << cc2.getE() << endl;
	      //cerr <<" chain of mults starts with: M"<<udlclclc<<MModel::hM.get(udlclclc)
	      //<< "Lleft "<<udlc1.second.first<< LModel::hL.get(lLeft)<< "Eleft"<<cc1.getE()
	      //<< "Lright "<<udlc2.second.first<< LModel::hL.get(lRight)<< "Eright"<< cc2.getE()<<endl;

              // the actual multiplication.  '&' is overloaded as pt-by-pt multiplication
              Evec e = MModel::hM.get(udlclclc)
                & ( LModel::hL.get(udlLeft)  * cc1.getE() ) //* diag( LModel::hL.get(udlLeft)  * cc1.getE() )
                & ( LModel::hL.get(udlRight) * cc2.getE() ); //* diag( LModel::hL.get(udlRight) * cc2.getE() )  *  N_1;
	      //cerr<< "  yields "<< e <<endl;
	      //if ( FOREST )
	      //  fprintf ( stdout, "%d %s %d : %d %s %d %s %d = %d\n",
	      //            i, gP.getString().c_str(), j,
	      //            i, g1.getString().c_str(), k, g2.getString().c_str(), j, pr.toInt() );
	      //if ( LogProb(e.infnorm())>maxProb.getProb(udlcP) && !(e==IndexedVector()) ) {
              if ( LogProb( (GEModel::hGEr.get(udlcP)*e).get(0,0) )>maxProb.getProb(udlcP) && !(e==IndexedVector()) ) {
		//if (maxProb.getProb(udlcP)==LogProb()) cerr<<"  brand new probability for this constituent "<<udlcP<<"..."<<endl;
		//else if (LogProb(e.infnorm())>maxProb.getProb(udlcP)) cerr<<"  old probability for this constituent "<<udlcP<<" = "<<maxProb.getProb(udlcP).toInt()<<", replacing with "<<LogProb(e.infnorm()).toInt()<<endl;
		ChartCell& cc = accChart.set(i,j).set(udlcP);
		cc = ChartCell(GE(udlcP,e),k,cc1,cc2,LogProb(e.infnorm()));
                //maxProb.setProb(udlcP) = LogProb(e.infnorm());
                maxProb.setProb(udlcP) = LogProb( (GEModel::hGEr.get(udlcP)*e).get(0,0) );
 		//tryUnary ( accChart, i, j, cc, modGgivG );
		if ( VERYNOISY )
		  cerr << "      binary match! " << i << " " << k << " " << j << " " << udlcP
		       << " -> " << udlc1 << " " << udlc2 << " has max "
		       << cc1.maxProb() << "*" << cc2.maxProb() << " * M,L,L " 
		       << "max= " << LogProb(e.infnorm()) << endl;
	      }
	    }
          }
        }
      }
    }

    /*
      if ( FOREST ) {

      //ModeledC c;
      GModel::IterVal gr;
      for ( bool bgr=modGr.setFirst(gr); bgr; bgr=modGr.setNext(gr) )
      if ( axChart.get(0,n).get(gr).getProb()*modGr.getProb(gr) != LogProb() ) {
      axChart.set(0,n).set(gr).setRooted();
      }

      for ( int di=n; di>=1; di-- ) {
      //cerr << "  " << di << endl;
      for ( int i=0; i<=n-di; i++ ) {
      int j=i+di;
      for ( MModel::const_iterator igr = modM.begin(); igr!=modM.end(); igr++ ) {
      G gP = igr->first.getX1();

      const ChartCell& x  = axChart.get(i,j).get(gP);
      if ( x.getRooted() ) {
      for ( int k=i+1; k<=j-1; k++ ) {
      Evec eP = Evec(gP.second.third);
		
      D  dL = (gP.first.first==U_R) ? D(gP.first.second.toInt()+1) : D(gP.first.second.toInt());
      UD udL( U_L, dL );
      UD udR( U_R, gP.first.second );
		
      MModel::IterVal ilclc;
      LModel::IterVal ieLeft;
      LModel::IterVal ieRight;
		
      for ( bool bg=modM.setFirst(ilclc,gP); bg; bg=modM.setNext(ilclc,gP) ) {
		  
      L lLeft  = ilclc.first.first;
      L lRight = ilclc.second.first;
		  
      for ( bool ble=modL.setFirst(ieLeft,lLeft,eP); ble; ble=modL.setNext(ieLeft,lLeft,eP) ) {
      //cerr<<"   iter over eLeft = "<<ieLeft<<endl;
      for ( bool ble=modL.setFirst(ieRight,lRight,eP); ble; ble=modL.setNext(ieRight,lRight,eP) ) {
      //cerr<<"   iter over eRight = "<<ieRight<<endl;
		      
      G g1 = G(udL,LCE(ilclc.first.first,ilclc.first.second,ieLeft));
      G g2 = G(udR,LCE(ilclc.second.first,ilclc.second.second,ieRight));
		      
      //cerr  << i << "," << k << "," << j << " found GG rule "<< gP << " -> " << gg<< endl;
      ChartCell& x1 = axChart.set(i,k).set(g1);
      ChartCell& x2 = axChart.set(k,j).set(g2);
      if ( x1!=ChartCell() && x2!=ChartCell() ) {
      x1.setRooted();
      x2.setRooted();
      LogProb pr = x1.getProb() * x2.getProb()
      * LogProb(modM.getProb(ilclc,gP)) * LogProb(modL.getProb(ieLeft,lLeft,eP)) * LogProb(modL.getProb(ieRight,lRight,eP));
      fprintf ( stdout, "%d %s:%s{%s} %d : %d %s:%s{%s} %d %s:%s{%s} %d = %d\n",
      i, gP.second.first.getString().c_str(),gP.second.second.getString().c_str(), gP.second.third.getString().c_str(), j,
      i, g1.second.first.getString().c_str(),g1.second.second.getString().c_str(), g1.second.third.getString().c_str(), 
      k, g2.second.first.getString().c_str(),g2.second.second.getString().c_str(), g2.second.third.getString().c_str(), j, pr.toInt() );
      }
      }
      }
      }
      }
      }
      }
      }
      }
      cout << "-" << endl;

      } else */ 
    {
      // Print best...
      LogProb         prBest=LogProb();
      Evec            eBest=Evec();
      UDLC            udlcBest;

      //for (SimpleHash<UDLC,ChartCell>::const_iterator it=axChart.get(0,n).begin(); !(it==axChart.get(0,n).end()); it++) {
      //cerr<< "Rooted node, P("<<it->first<<")="<<axChart.get(0,n).get(it->first).getE()<<endl;
      //}

      //GModel::IterVal gr;
      //for ( bool bgr=modGr.setFirst(gr); bgr; bgr=modGr.setNext(gr) ) {
      for (GErModel::const_iterator iudlc=modGEr.begin(); iudlc!=modGEr.end(); iudlc++) {
	//for (SimpleHash<UDLC,ChartCell>::const_iterator iudlc=axChart.get(0,n).begin(); !(iudlc==axChart.get(0,n).end()); iudlc++) {
	UDLC udlc ( UD(iudlc->first.first), LC(iudlc->first.second) );
	//cerr<< "Gr Root, P("<<iudlc->first<<")="<<GrModel::hGr.get(udlc)<<endl;
	if ( !accChart.get(0,n).contains(udlc) ) { continue; }
	//cerr<<endl;;
	Evec er = GErModel::hGEr.get(udlc) * accChart.get(0,n).get(udlc).getE();
	//cerr<<" ...matches chart-topper root P("<<udlc<<")=";
	//cerr<<axChart.get(0,n).get(iudlc->first).getE()<<"    yields "<<er;
        if ( LogProb()==prBest || LogProb(er.infnorm())>prBest) {
	  udlcBest  = udlc;
	  prBest = er.infnorm();
          eBest = accChart.get(0,n).get(udlc).getE();
	}
	//err<<endl;
      }
      if ( prBest>LogProb() ) {
	List<X> lx2,lx3 = lx;
        accChart.get(0,n).get(udlcBest).writeBest(stdout,lx);
	if (NOISY) {
	  cout<<endl;
	  accChart.get(0,n).get(udlcBest).writePath(stderr,lx2);
	  cerr << endl<<"   NumWords="<<n<<"   Probability="<<prBest;
	} 
	if (PROBS) {
	  cout << endl<<"   NumWords="<<n<<"   Probability="<<prBest;
	}
        if (EVALVEC) {
          cout << endl << "{ ["<<eBest<<"], [";
          accChart.get(0,n).get(udlcBest).writePVitVecs(stdout,lx3);
          cout << "] },";
        }
      }
      else {
        if (EVALVEC) {
          cout << "0,0 },";
            } else {
        cout << "[ERROR failed]";
        }
      }
      cout << endl;
    }

    // clear caches
    //mLxE.clear();
    //mMxLExLE.clear();

  }

  //if (nArgs>2) fin.close();
  //if (NOISY) {
  //  cerr << " trying to dump modGGgivG\n";
  //  modGGgivG.dump(cerr,"GG");
  //}


}

