##### run cky parser (obtain parser output file):
## parser output files -- filename `words' delimited by dots (e.g. hhmm.qf.wsjpu.feb27.500.wsj22-pu.eval)
## 1st word:  parse or evaluation framework                            (e.g. hhmm [which produces mls output] or cky)
## 2nd word:  implementation + runtime params delimited by underscores (e.g. vecmd-rlnclust)
## 3rd word:  training set                                             (e.g. wsjpu or wsjnp or swbd)
## 4th word:  eval date/id                                             (e.g. feb27 or feb27b)
## pre-final word:  test set        (e.g. wsj22-pu or wsj22np)
#.PRECIOUS: cky.%.hypoth.cnftrees
#cky.%.hypoth.cnftrees: 
#	make cky.$*.sents
#	make genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).model
#	make genmodel/POS.$(word 3,$(subst ., ,$@)).model
#	make bin/ckyparser-$(word 2,$(subst ., ,$@))
#	@echo 'Do you really want to re-build this big $@ file?  If not, CTRL-C and copy it from somewhere!'
#	@sleep 5
#	cat cky.$*.sents | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $@



### split evaluation...
# 1. create a .gold.cnftrees file)
# 2. make .eval.split


%.wsj22-np.gold.cnftrees: genmodel/wsj22-np.cnftrees
	cat $^ > $@
%.wsj22-pu.gold.cnftrees: genmodel/wsj22-pu.cnftrees
	cat $^ > $@
%.wsj23-np.gold.cnftrees: genmodel/wsj23-np.cnftrees
	cat $^ > $@
%.wsj23-pu.gold.cnftrees: genmodel/wsj23-pu.cnftrees
	cat $^ > $@
%.wsj24-np.gold.cnftrees: genmodel/wsj24-np.cnftrees
	cat $^ > $@
%.wsj24-pu.gold.cnftrees: genmodel/wsj24-pu.cnftrees
	cat $^ > $@

## WSJ Sec 22: use 393 sentences (8,284 words)
%.wsj22-np.gold.cnftrees.pt1: 
	head -98 $*.wsj22-np.gold.cnftrees > $*.wsj22-np.gold.cnftrees.pt1
%.wsj22-np.gold.cnftrees.pt2:
	head -206 $*.wsj22-np.gold.cnftrees | tail -108 > $*.wsj22-np.gold.cnftrees.pt2
%.wsj22-np.gold.cnftrees.pt3:
	head -302 $*.wsj22-np.gold.cnftrees | tail -96 > $*.wsj22-np.gold.cnftrees.pt3
%.wsj22-np.gold.cnftrees.pt4:
	tail -91 $*.wsj22-np.gold.cnftrees > $*.wsj22-np.gold.cnftrees.pt4
%.wsj22-pu.gold.cnftrees.pt1:
	head -98 $*.wsj22-pu.gold.cnftrees > $*.wsj22-pu.gold.cnftrees.pt1
%.wsj22-pu.gold.cnftrees.pt2:
	head -206 $*.wsj22-pu.gold.cnftrees | tail -108 > $*.wsj22-pu.gold.cnftrees.pt2
%.wsj22-pu.gold.cnftrees.pt3:
	head -302 $*.wsj22-pu.gold.cnftrees | tail -96 > $*.wsj22-pu.gold.cnftrees.pt3
%.wsj22-pu.gold.cnftrees.pt4:
	tail -91 $*.wsj22-pu.gold.cnftrees > $*.wsj22-pu.gold.cnftrees.pt4

## WSJ Sec 23: 2416 sentences (49,704 words)
%.wsj23-np.gold.cnftrees.pt1:
	head -587 $*.wsj23-np.gold.cnftrees > $*.wsj23-np.gold.cnftrees.pt1
%.wsj23-np.gold.cnftrees.pt2:
	head -1142 $*.wsj23-np.gold.cnftrees | tail -555 > $*.wsj23-np.gold.cnftrees.pt2
%.wsj23-np.gold.cnftrees.pt3:
	head -1754 $*.wsj23-np.gold.cnftrees | tail -612 > $*.wsj23-np.gold.cnftrees.pt3
%.wsj23-np.gold.cnftrees.pt4:
	tail -662 $*.wsj23-np.gold.cnftrees > $*.wsj23-np.gold.cnftrees.pt4
%.wsj23-pu.gold.cnftrees.pt1:
	head -587 $*.wsj23-pu.gold.cnftrees > $*.wsj23-pu.gold.cnftrees.pt1
%.wsj23-pu.gold.cnftrees.pt2:
	head -1142 $*.wsj23-pu.gold.cnftrees | tail -555 > $*.wsj23-pu.gold.cnftrees.pt2
%.wsj23-pu.gold.cnftrees.pt3:
	head -1754 $*.wsj23-pu.gold.cnftrees | tail -612 > $*.wsj23-pu.gold.cnftrees.pt3
%.wsj23-pu.gold.cnftrees.pt4:
	tail -662 $*.wsj23-pu.gold.cnftrees > $*.wsj23-pu.gold.cnftrees.pt4

## WSJ Sec 24: 1346 sentences (28,998 words)
%.wsj24-np.gold.cnftrees.pt1:
	head -337 $*.wsj24-np.gold.cnftrees > $*.wsj24-np.gold.cnftrees.pt1
%.wsj24-np.gold.cnftrees.pt2:
	head -674 $*.wsj24-np.gold.cnftrees | tail -337 > $*.wsj24-np.gold.cnftrees.pt2
%.wsj24-np.gold.cnftrees.pt3:
	head -1010 $*.wsj24-np.gold.cnftrees | tail -336 > $*.wsj24-np.gold.cnftrees.pt3
%.wsj24-np.gold.cnftrees.pt4:
	tail -336 $*.wsj24-np.gold.cnftrees > $*.wsj24-np.gold.cnftrees.pt4
%.wsj24-pu.gold.cnftrees.pt1:
	head -337 $*.wsj24-pu.gold.cnftrees > $*.wsj24-pu.gold.cnftrees.pt1
%.wsj24-pu.gold.cnftrees.pt2:
	head -674 $*.wsj24-pu.gold.cnftrees | tail -337 > $*.wsj24-pu.gold.cnftrees.pt2
%.wsj24-pu.gold.cnftrees.pt3:
	head -1010 $*.wsj24-pu.gold.cnftrees | tail -336 > $*.wsj24-pu.gold.cnftrees.pt3
%.wsj24-pu.gold.cnftrees.pt4:
	tail -336 $*.wsj24-pu.gold.cnftrees > $*.wsj24-pu.gold.cnftrees.pt4

## TEST Sec 22: use 4 sentences
%.wsj22-np1-4.gold.cnftrees.pt1:
	head -1 $*.wsj22-np1-4.gold.cnftrees > $*.wsj22-np1-4.gold.cnftrees.pt1
%.wsj22-np1-4.gold.cnftrees.pt2:
	head -2 $*.wsj22-np1-4.gold.cnftrees | tail -1 > $*.wsj22-np1-4.gold.cnftrees.pt2
%.wsj22-np1-4.gold.cnftrees.pt3:
	head -3 $*.wsj22-np1-4.gold.cnftrees | tail -1 > $*.wsj22-np1-4.gold.cnftrees.pt3
%.wsj22-np1-4.gold.cnftrees.pt4:
	tail -1 $*.wsj22-np1-4.gold.cnftrees > $*.wsj22-np1-4.gold.cnftrees.pt4
%.wsj22-np1-4.gold.cnftrees: %.wsj22-np1-4.gold.cnftrees.pt1 %.wsj22-np1-4.gold.cnftrees.pt2 %.wsj22-np1-4.gold.cnftrees.pt3 %.wsj22-np1-4.gold.cnftrees.pt4
	cat $^ > $@
%.wsj22-pu1-4.gold.cnftrees.pt1:
	head -1 $*.wsj22-pu1-4.gold.cnftrees > $*.wsj22-pu1-4.gold.cnftrees.pt1
%.wsj22-pu1-4.gold.cnftrees.pt2:
	head -2 $*.wsj22-pu1-4.gold.cnftrees | tail -1 > $*.wsj22-pu1-4.gold.cnftrees.pt2
%.wsj22-pu1-4.gold.cnftrees.pt3:
	head -3 $*.wsj22-pu1-4.gold.cnftrees | tail -1 > $*.wsj22-pu1-4.gold.cnftrees.pt3
%.wsj22-pu1-4.gold.cnftrees.pt4:
	tail -1 $*.wsj22-pu1-4.gold.cnftrees > $*.wsj22-pu1-4.gold.cnftrees.pt4
%.wsj22-pu1-4.gold.cnftrees: %.wsj22-pu1-4.gold.cnftrees.pt1 %.wsj22-pu1-4.gold.cnftrees.pt2 %.wsj22-pu1-4.gold.cnftrees.pt3 %.wsj22-pu1-4.gold.cnftrees.pt4
	cat $^ > $@

%.evalform.pt1: %.cnftrees.pt1 scripts/unbinarize.pl
	cat $< | sed 's/[^ \/]*\#//g' | perl scripts/unbinarize.pl | perl -p -e 's/(\([A-Z\$$\.\,\!\`\'\'']+)[-a-z\$$]+[-a-zA-Z0-9\$$]*/\1/g' > $@
#'
%.evalform.pt2: %.cnftrees.pt2 scripts/unbinarize.pl
	cat $< | sed 's/[^ \/]*\#//g' | perl scripts/unbinarize.pl | perl -p -e 's/(\([A-Z\$$\.\,\!\`\'\'']+)[-a-z\$$]+[-a-zA-Z0-9\$$]*/\1/g' > $@
#'
%.evalform.pt3: %.cnftrees.pt3 scripts/unbinarize.pl
	cat $< | sed 's/[^ \/]*\#//g' | perl scripts/unbinarize.pl | perl -p -e 's/(\([A-Z\$$\.\,\!\`\'\'']+)[-a-z\$$]+[-a-zA-Z0-9\$$]*/\1/g' > $@
#'
%.evalform.pt4: %.cnftrees.pt4 scripts/unbinarize.pl
	cat $< | sed 's/[^ \/]*\#//g' | perl scripts/unbinarize.pl | perl -p -e 's/(\([A-Z\$$\.\,\!\`\'\'']+)[-a-z\$$]+[-a-zA-Z0-9\$$]*/\1/g' > $@
#' # need this to view rest of make correctly following single-quote trickery above


## split sentences
%.sents.pt1: %.gold.evalform.pt1
	cat $< | sed 's/([^ ]* //g;s/)//g;s/[^ \/]*\#//g' > $@
%.sents.pt2: %.gold.evalform.pt2
	cat $< | sed 's/([^ ]* //g;s/)//g;s/[^ \/]*\#//g' > $@
%.sents.pt3: %.gold.evalform.pt3
	cat $< | sed 's/([^ ]* //g;s/)//g;s/[^ \/]*\#//g' > $@
%.sents.pt4: %.gold.evalform.pt4
	cat $< | sed 's/([^ ]* //g;s/)//g;s/[^ \/]*\#//g' > $@

### CKY-ml split eval
## 
.PRECIOUS: cky.ml%.hypoth.cnftrees.pt1 cky.ml%.hypoth.cnftrees.pt2 cky.ml%.hypoth.cnftrees.pt3 cky.ml%.hypoth.cnftrees.pt4
cky.ml%.hypoth.cnftrees.pt1: cky.ml%.sents.pt1
	cat cky.ml$*.sents.pt1 | nice bin/ckyparser-ml genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@
cky.ml%.hypoth.cnftrees.pt2: cky.ml%.sents.pt2
	cat cky.ml$*.sents.pt2 | nice bin/ckyparser-ml genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@
cky.ml%.hypoth.cnftrees.pt3: cky.ml%.sents.pt3
	cat cky.ml$*.sents.pt3 | nice bin/ckyparser-ml genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@
cky.ml%.hypoth.cnftrees.pt4: cky.ml%.sents.pt4
	cat cky.ml$*.sents.pt4 | nice bin/ckyparser-ml genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@

### CKY-md split eval
## 
.PRECIOUS: cky.md%.hypoth.cnftrees.pt1 cky.md%.hypoth.cnftrees.pt2 cky.md%.hypoth.cnftrees.pt3 cky.md%.hypoth.cnftrees.pt4
cky.md%.hypoth.cnftrees.pt1: cky.md%.sents.pt1
	cat cky.md$*.sents.pt1 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@
cky.md%.hypoth.cnftrees.pt2: cky.md%.sents.pt2
	cat cky.md$*.sents.pt2 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@
cky.md%.hypoth.cnftrees.pt3: cky.md%.sents.pt3
	cat cky.md$*.sents.pt3 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@
cky.md%.hypoth.cnftrees.pt4: cky.md%.sents.pt4
	cat cky.md$*.sents.pt4 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@

### CKY-vecmd split eval
## 
.PRECIOUS: cky.vecmd%.hypoth.cnftrees.pt1 cky.vecmd%.hypoth.cnftrees.pt2 cky.vecmd%.hypoth.cnftrees.pt3 cky.vecmd%.hypoth.cnftrees.pt4
cky.vecmd%.hypoth.cnftrees.pt1: cky.vecmd%.sents.pt1
	cat cky.vecmd$*.sents.pt1 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@
cky.vecmd%.hypoth.cnftrees.pt2: cky.vecmd%.sents.pt2
	cat cky.vecmd$*.sents.pt2 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@
cky.vecmd%.hypoth.cnftrees.pt3: cky.vecmd%.sents.pt3
	cat cky.vecmd$*.sents.pt3 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@
cky.vecmd%.hypoth.cnftrees.pt4: cky.vecmd%.sents.pt4
	cat cky.vecmd$*.sents.pt4 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@

### CKY-vecmd split eval for perplexity
## 
.PRECIOUS: perpcky.vecmd%.hypoth.cnftrees.pt1 perpcky.vecmd%.hypoth.cnftrees.pt2 perpcky.vecmd%.hypoth.cnftrees.pt3 perpcky.vecmd%.hypoth.cnftrees.pt4
perpcky.vecmd%.hypoth.cnftrees.pt1: perpcky.vecmd%.sents.pt1
	cat perpcky.vecmd$*.sents.pt1 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) -p genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@
perpcky.vecmd%.hypoth.cnftrees.pt2: perpcky.vecmd%.sents.pt2
	cat perpcky.vecmd$*.sents.pt2 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) -p genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@
perpcky.vecmd%.hypoth.cnftrees.pt3: perpcky.vecmd%.sents.pt3
	cat perpcky.vecmd$*.sents.pt3 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) -p genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@
perpcky.vecmd%.hypoth.cnftrees.pt4: perpcky.vecmd%.sents.pt4
	cat perpcky.vecmd$*.sents.pt4 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) -p genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@

### CKY-vecmd split eval for vec output
## 
.PRECIOUS: eveccky.vecmd%.hypoth.cnftrees.pt1 eveccky.vecmd%.hypoth.cnftrees.pt2 eveccky.vecmd%.hypoth.cnftrees.pt3 eveccky.vecmd%.hypoth.cnftrees.pt4
eveccky.vecmd%.hypoth.cnftrees.pt1: eveccky.vecmd%.sents.pt1
	cat eveccky.vecmd$*.sents.pt1 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) -e genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@
eveccky.vecmd%.hypoth.cnftrees.pt2: eveccky.vecmd%.sents.pt2
	cat eveccky.vecmd$*.sents.pt2 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) -e genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@
eveccky.vecmd%.hypoth.cnftrees.pt3: eveccky.vecmd%.sents.pt3
	cat eveccky.vecmd$*.sents.pt3 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) -e genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@
eveccky.vecmd%.hypoth.cnftrees.pt4: eveccky.vecmd%.sents.pt4
	cat eveccky.vecmd$*.sents.pt4 | nice bin/ckyparser-$(word 2,$(subst ., ,$@)) -e genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $(subst cnftrees,dat,$@)
	rmel $(subst cnftrees,dat,$@) > $@


## combining things
cky.%.hypoth.cnftrees.all: cky.%.hypoth.cnftrees.pt1 cky.%.hypoth.cnftrees.pt2 cky.%.hypoth.cnftrees.pt3 cky.%.hypoth.cnftrees.pt4
	cat $^ > cky.$*.hypoth.cnftrees
perpcky.%.hypoth.perp.all: perpcky.%.hypoth.cnftrees.pt1 perpcky.%.hypoth.cnftrees.pt2 perpcky.%.hypoth.cnftrees.pt3 perpcky.%.hypoth.cnftrees.pt4
	cat $^ | grep 'Probability' > perpcky.$*.hypoth.perp
eveccky.%.hypoth.evec.all: eveccky.%.hypoth.cnftrees.pt1 eveccky.%.hypoth.cnftrees.pt2 eveccky.%.hypoth.cnftrees.pt3 eveccky.%.hypoth.cnftrees.pt4
	echo 'hypoth = [ ...' > eveccky.$*.hypoth.evec
	cat $^ | grep "\[.*\]" >> eveccky.$*.hypoth.evec
	echo '];' >> eveccky.$*.hypoth.evec
.PRECIOUS: eveccky.%.gold.evec
eveccky.%.gold.evec: eveccky.%.gold.cnftrees bin/trees2ptermword
	make bin/wordvec-$(word 2,$(subst ., ,$@))
	echo 'gold = [ ...' > $@
	cat $< | ruby scripts/calcHdwdTree.rb | sed 's/( /(/g;s/ )/)/g;s/ )/)/g' | grep -v '^$$' | bin/trees2ptermword | bin/wordvec-$(word 2,$(subst ., ,$@)) genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model >> $@
	echo '];' >> $@

cky.%.sents.all:
	make cky.$*.sents.pt1
	make cky.$*.sents.pt2
	make cky.$*.sents.pt3
	make cky.$*.sents.pt4
%.dict: %.sents
	cat $< | perl scripts/sents2dict.pl 20000 > $@
perpcky.%.wsj23-np.sents.all:
	make genmodel/all.$(word 3,$(subst ., ,$@)).dict
	make genmodel/wsj23-np.sents
	cat  genmodel/wsj23-np.sents | perl scripts/sents2perpsents.pl genmodel/all.$(word 3,$(subst ., ,$@)).dict > perpcky.$*.wsj23-np.sents
	head -587 perpcky.$*.wsj23-np.sents > perpcky.$*.wsj23-np.sents.pt1
	head -1142 perpcky.$*.wsj23-np.sents | tail -555 > perpcky.$*.wsj23-np.sents.pt2
	head -1754 perpcky.$*.wsj23-np.sents | tail -612 > perpcky.$*.wsj23-np.sents.pt3
	tail -662 perpcky.$*.wsj23-np.sents > perpcky.$*.wsj23-np.sents.pt4
eveccky.%.sents.all:
	make eveccky.$*.sents.pt1
	make eveccky.$*.sents.pt2
	make eveccky.$*.sents.pt3
	make eveccky.$*.sents.pt4

### actual eval scripts
##
cky.ml%.eval.split:
	make genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model
	make genmodel/POS.$(word 3,$(subst ., ,$@)).model
	make bin/ckyparser-ml
	make cky.$*.gold.cnftrees
	make cky.$*.sents.all
	make cky.$*.hypoth.cnftrees.all
	make cky.$*.eval
cky.md%.eval.split:
	make genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model
	make genmodel/POS.$(word 3,$(subst ., ,$@)).model
	make bin/ckyparser-$(word 2,$(subst ., ,$@))
	make cky.md$*.gold.cnftrees
	make cky.md$*.sents.all
	make cky.md$*.hypoth.cnftrees.all
	make cky.md$*.eval
cky.vecmd%.eval.split:
	make genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model
	make genmodel/POS.$(word 3,$(subst ., ,$@)).model
	make bin/ckyparser-$(word 2,$(subst ., ,$@))
	make cky.vecmd$*.gold.cnftrees
	make cky.vecmd$*.sents.all
	make cky.vecmd$*.hypoth.cnftrees.all
	make cky.vecmd$*.eval

# perplexity calculation from cky
perpcky.vecmd%.eval.split:
	make genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model
	make genmodel/POS.$(word 3,$(subst ., ,$@)).model
	make bin/ckyparser-$(word 2,$(subst ., ,$@))
	make perpcky.vecmd$*.gold.cnftrees
	make perpcky.vecmd$*.sents.all
	make perpcky.vecmd$*.hypoth.perp.all
	cat perpcky.vecmd$*.hypoth.perp | perl -n -e '$$_=~ / *NumWords=([^ ]+) *Probability=([^ ]+)/; $$totwords+=$$1; $$totprob+=($$2/100)."\n"; print $$totwords." ".$$totprob." ".(exp(-$$totprob/$$totwords))."\n";' | tail -1 > perpcky.vecmd$*.eval

# vector calculation from cky
eveccky.vecmd%.eval.split:
	make genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).$(word 5,$(subst ., ,$@)).model
	make genmodel/POS.$(word 3,$(subst ., ,$@)).model
	make bin/ckyparser-$(word 2,$(subst ., ,$@))
	make eveccky.vecmd$*.gold.cnftrees 
	make eveccky.vecmd$*.gold.evec
	make eveccky.vecmd$*.sents.all
	make eveccky.vecmd$*.hypoth.evec.all
	make eveccky.vecmd$*.simeval
eveccky.vecmd%.simeval:
	cat eveccky.vecmd$*.hypoth.evec eveccky.vecmd$*.gold.evec > eveccky_$(subst -,_,$(word 2,$(subst ., ,$@))_$(word 3,$(subst ., ,$@))_$(word 4,$(subst ., ,$@))_$(word 5,$(subst ., ,$@))).m
	cat scripts/comparevectors.m >> eveccky_$(subst -,_,$(word 2,$(subst ., ,$@))_$(word 3,$(subst ., ,$@))_$(word 4,$(subst ., ,$@))_$(word 5,$(subst ., ,$@))).m
	echo -e "fid = fopen('$@','w');\nfprintf(fid,['all2add all2mult all2head all2mhm all2mhhm all2mhmm all2mhhhm add2head add2mhm add2mhhm add2mhmm add2mhhhm mult2head mult2mhm mult2mhhm mult2mhmm mult2mhhhm\\\n']);\nfprintf(fid,'%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f\\\n',similarities');\nfprintf(fid,'mean & stdev\\\n');\nfprintf(fid,'%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f\\\n',nanmean(similarities));\nfprintf(fid,'%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f\\\n',nanstd(similarities));\nfclose(fid);\nexit;" >> eveccky_$(subst -,_,$(word 2,$(subst ., ,$@))_$(word 3,$(subst ., ,$@))_$(word 4,$(subst ., ,$@))_$(word 5,$(subst ., ,$@))).m
	matlab -nosplash -nojvm -r eveccky_$(subst -,_,$(word 2,$(subst ., ,$@))_$(word 3,$(subst ., ,$@))_$(word 4,$(subst ., ,$@))_$(word 5,$(subst ., ,$@)))





### HHMM split eval
## 
.PRECIOUS: hhmm.%.hypoth.dat.pt1 hhmm.%.hypoth.dat.pt2 hhmm.%.hypoth.dat.pt3 hhmm.%.hypoth.dat.pt4
hhmm.%.hypoth.dat.pt1: hhmm.%.sents.pt1
	cat hhmm.$*.sents.pt1 | nice bin/hhmmparser-$(word 2,$(subst ., ,$@)) -b $(word 5,$(subst ., ,$@)) genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $@
hhmm.%.hypoth.dat.pt2: hhmm.%.sents.pt2
	cat hhmm.$*.sents.pt2 | nice bin/hhmmparser-$(word 2,$(subst ., ,$@)) -b $(word 5,$(subst ., ,$@)) genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $@
hhmm.%.hypoth.dat.pt3: hhmm.%.sents.pt3
	cat hhmm.$*.sents.pt3 | nice bin/hhmmparser-$(word 2,$(subst ., ,$@)) -b $(word 5,$(subst ., ,$@)) genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $@
hhmm.%.hypoth.dat.pt4: hhmm.%.sents.pt4
	cat hhmm.$*.sents.pt4 | nice bin/hhmmparser-$(word 2,$(subst ., ,$@)) -b $(word 5,$(subst ., ,$@)) genmodel/$(word 2,$(subst ., ,$@)).$(word 3,$(subst ., ,$@)).model genmodel/POS.$(word 3,$(subst ., ,$@)).model > $@

## combining things
hhmm.%.hypoth.dat.all: hhmm.%.hypoth.dat.pt1 hhmm.%.hypoth.dat.pt2 hhmm.%.hypoth.dat.pt3 hhmm.%.hypoth.dat.pt4
	cat $^ > hhmm.$*.hypoth.dat

hhmm.%.sents.all:
	make hhmm.$*.sents.pt1
	make hhmm.$*.sents.pt2
	make hhmm.$*.sents.pt3
	make hhmm.$*.sents.pt4

hhmm.%.eval.split:
	make genmodel/$(word 1,$(subst ., ,$@)).$(word 2,$(subst ., ,$@)).model
	make genmodel/POS.$(word 2,$(subst ., ,$@)).model
	make bin/hhmmparser-$(word 1,$(subst ., ,$@))
	make hhmm.$*.gold.cnftrees
	make hhmm.$*.sents.all
	make hhmm.$*.hypoth.dat.all
	make hhmm.$*.eval