###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

#####################################################################
# propArgs.rb
# Tim Miller
# 
# This script works on binarized trees in a top-down fashion to propagate
# argument structure, to emulate some features of lexicalization without
# requiring any changes to the parser.
# Rules of type X -> X NP will be changed to X -> X-argNP NP
# and the same with S.
#
######################################################################

require "scripts/umnlp.rb"

$error = false
$line = ""

class Tree
  def toDat ( depth, cexpParent, cfullParent, clackParent )

    if @children.size==0
      $stderr.print "ERROR: EXPECT (PRETERM), POS, WORD NODES IN RCTREE!!! curr:"+@head + "\nLine=#{$line}\n"
      return
    end
    if @children.size==1 && @children[0].children.size==1 && @children[0].children[0].children.size!=0
      $stderr.print "ERROR: EXPECT (PRETERM), POS, WORD NODES IN RCTREE!!! curr:"+@head + " child:"+@children[0].head + " granch:"+@children[0].children[0].head + "\n"
      return
    end

    ## terminal case, left child post-transform
    if @children.size==1 && @children[0].children.size==1 && @children[0].children[0].children.size==0
#      @children[0].head.downcase!
      pos = @children[0].children[0].head.gsub(/([^\#]*)\#.*/,'\1')
      if depth<5
        print "Qe " + depth.to_s + " " + cfullParent + " : " + @children[0].head+"/"+@children[0].head+"|"+@children[0].head + "\n"
        print "Qe " + (depth+1).to_s + " " + @children[0].head+"/"+@children[0].head+"|"+@children[0].head + " : -/-|-\n"
        ##print "Fr " + (depth+1).to_s + " " + @children[0].head+"/"+@children[0].head+"|"+@children[0].head + " : 1\n"
        print "Pg " + @children[0].head + " : " + pos + "\n"
      end
      ## if borderline depth...
      if depth==5
        $stderr.print "ERROR: TREE TOO BIG!!!\n"
        #print "Pg " + @head + " : " + @head + "\n"
        print "Pg " + @children[0].head + " : " + pos + "\n"
      end
      ## if beyond max depth...
      if depth>5
        $stderr.print "ERROR: TREE TOO BIG!!!\n"
      end
      word = @children[0].children[0].head.gsub(/.*\#(.*)/,'\1')
      print "Pw " + word + " : " + pos + "\n"
      if word == ""
        $error = true
      end
      return @children[0].head+"/"+@children[0].head+"|"+@children[0].head,@children[0].head+"="  ##+ " " + @head
    end

    ## terminal case, right child post-transform
    if @children.size==1 && @children[0].children.size==0
#      #@head.downcase!
      ## make sure head label equal to pos...
      pos = @children[0].head.gsub(/([^\#]*)\#.*/,'\1')
###      if @head!=pos
###        @head = pos
###      end
      ## if legal depth...
#      if depth<5
###        print "Qe " + depth.to_s + " " + cexpParent + " : -/-|-\n"

        print "Qe " + depth.to_s + " " + cfullParent + " : -/-|-\n"
          
##        print "Qe " + depth.to_s + " " + cfullParent + " : " + @head+"/"+@head+"|"+@head + "\n"
##        print "Qe " + (depth+1).to_s + " " + @head+"/"+@head+"|"+@head + " : -/-|-\n"
##        print "F  " + (depth+1).to_s + " " + @head + " -/-|- : 1 \n"
###        for d in (depth+1)..4
###          print "Qe " + d.to_s + " " + @head + " : " + @head+"/"+@head+"|"+@head + "\n"
###          print "F  " + d.to_s + " " + @head + " " + @head+"/"+@head+"|"+@head + " : 1\n"
###        end
        print "Pg " + @head + " : " + pos + "\n"
#      end
#      ## if borderline depth...
#      if depth==5
#        $stderr.print "ERROR: TREE TOO BIG!!!\n"
#        #print "Pg " + @head + " : " + @head + "\n"
#        print "Pg " + cexpParent + " : " + @head + "\n"
#      end
#      ## if beyond max depth...
#      if depth>5
#        $stderr.print "ERROR: TREE TOO BIG!!!\n"
#      end
      word = @children[0].head.gsub(/.*\#(.*)/,'\1')
      print "Pw " + word + " : " + pos + "\n"
      if word == ""
        $error = true
      end
      return "-/-|-","" ##@head+"/"+@head+"|"+@head,"0+"  ##+ " " + @head
    end

    ## unary case
    if @children.size==1
      ## recurse to left (or unary) child...
      (composL,continL) = @children[0].toDat(depth,cexpParent,cfullParent,clackParent)
      ##########print "----------> at unary: "+@head+" -> "+@children[0].head+"\n";
      return composL,@children[0].head+"="
    end

    ## binary case
    if @children.size==2
      ## propagate curr...
#      if @children[1].children.size==1 && @children[1].children[0].children.size==0
#        @children[1].head.downcase!
#      end
      @children[0].head = @children[0].head+"|"+@children[1].head
      ## recurse to left (or unary) child...
      (composL,continL) = @children[0].toDat(depth,cexpParent,cfullParent,clackParent)
      ## recurse to right child...
      cexpCurr = @children[0].head.gsub( /.*\|(.*)/, '\1' )
      cfullCurr = @children[0].head# @children[0].head.gsub( /.*\/(.*)/, '\1' )
      clackCurr = @children[0].head.gsub( /.*\/(.*)/, '\1' )
      ##########print "----------> at binary: "+@head+" -> "+@children[0].head+" "+@children[1].head+"\n";
      ## left child was not final (and therefore has a transition)...
#      print " -----> " + cexpParent + " " + composL.gsub(/(.*)\/.*/,'\1') + "\n"
#      print " " + ((cexpParent == composL.gsub(/(.*)\/.*/,'\1'))?"true":"false") + "\n"
#      print " " + ((composL.gsub(/.*\/(.*)\|.*/,'\1') == composL.gsub(/.*\|(.*)/,'\1'))?"true":"false") + "\n"
      if ( cexpParent == composL.gsub(/(.*)\/.*/,'\1') && composL.gsub(/.*\/(.*)\|.*/,'\1') == composL.gsub(/.*\|(.*)/,'\1') )
        print "Fr " + depth.to_s     + " " + composL + " : 0\n"         ##composL.gsub!(/^([^ ]*) /,'\1')
      end
      print "Qt " + depth.to_s     + " " + cexpParent + " " + composL + " : " + continL + @children[0].head + "\n"
      ## right child was final (therefore no transition)...
      (composR,continR) = @children[1].toDat(depth+1,cexpCurr,cfullCurr,clackCurr)
      print "Fr " + (depth+1).to_s + " " + composR + " : 1\n"         ##composR.gsub!(/^([^ ]*) /,'\1')
      return @children[0].head,""  ##+ " " + @children[1].head
    end

    $stderr.print "ERROR: N-ARY BRANCH IN RCTREE!!!\n"
    return

  end
end

while($line = gets)
  t = Tree.new($line)
#  begin
  (composL,continL) = t.toDat(1,"S","ROOT/S|S","S|S")
  if $error
    $stderr.puts "\nWARNING: This tree generated a word-less Pw: #{t}\n"
    $error = false
  end
  ## top node was final...
  #print "Fr 1 S : 1\n"
  print "Fr 1 " + t.children[0].head + " : 1\n"

  for d in 1..4
    print "Qe " + d.to_s + " -/-|- : -/-|-\n"
    print "Fr " + d.to_s + " -/-|- : 1\n"
  end
#  rescue Exception
#    $stderr.puts "Skipping sentence: #{$line}"
#  end
  #print "F  1 S END/END|END : 1\n"
  #for d in 1..4
  #  print "F  " + d.to_s + " END END/END|END : 1\n"
  #end
end
