###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/perl

use strict;

my %RuleHash = ();
my %Graveyard = ();
#my %maxNums = ();
my $maxNum = -1;
my $rootRule="";

sub recursiveExpand{
  my $lhs = shift @_;
#  print stderr "$lhs\n";
#  my $ruleNum = shift @_;
  my ($ruleStart, $nt, $ruleEnd) = ($lhs =~ m/\((\d+)\) ([^ ]+) \((\d+)\)/);
  my $rhs = $RuleHash{$lhs};
  
  if($rhs eq $lhs){
#    print "\n$rhs = $lhs\n";
    print "( $nt $nt )";
    return;
  }
#  print "Found rhs = $rhs\n";
  my @rhsArray = split / /,$rhs;
  my $newRuleStart = shift @rhsArray;
  my $newNT = shift @rhsArray;
  my $newRuleEnd = shift @rhsArray;
  if(!exists($RuleHash{"$newRuleStart $newNT $newRuleEnd"})){
    print " ( $nt $newNT ) ";
    return;
  }
#  if ($newRuleStart eq "($ruleStart)" && $newRuleEnd eq "($ruleEnd)" && ($ruleEnd-$ruleStart > 1)){
#    recursiveExpand("$newRuleStart $newNT $newRuleEnd");
#  }else{ 
    print "( $nt ";
    while(defined($newRuleEnd)){
      recursiveExpand("$newRuleStart $newNT $newRuleEnd");
      $newRuleStart = $newRuleEnd;
      $newNT = shift @rhsArray;
      $newRuleEnd = shift @rhsArray;
    }
    print ") ";
#  }
}

my $cur_sent = 0;
## Read in the rules:
while(<STDIN>){

  ## Eliminate some more kinds of empty category crapola...
##  $_ =~ s/(\([^ ]+\)) +([^ ]+) +(\([^ ]+\)) => (.*)\([^ ]+\) +(empty[^ ]+)/\1 \2containing\5 \3 => \4/g;
  if ( $_ =~ s/(\([^ ]+\)) +([^ ]+) +(\([^ ]+\)) +=> +(.*)(\([^ ]+\)) +(empty[^ ]+) +(\([^ ]+\))/\1 \2containing\6 \3 => \4\5 emptyuseless \7/g ) {
#    print stderr "$_\n";
    $RuleHash{"$1 $2 $3"} = "$1 $2containing$6 $3";
    $RuleHash{"$5 emptyuseless $7"} = "$5 -NONE- $7";
  }

  if(m/^Sentence (\d+): \((\d+)\) ([^ ]+) \((\d+)\) => (.*)$/){
    my $s_i = $2; my $lhs = $3; my $e_i = $4; my $rhs = $5;
    if($1 > $cur_sent){
      if($rootRule ne ""){
#        print stderr "Finished reading sentence # $cur_sent\n";
        recursiveExpand($rootRule);
        print "\n";
      }
      %RuleHash = ();
#      %Graveyard = ();
      $maxNum = -1;
      $cur_sent = $1;
    }
    if(($2 == 0) && ($4 > $maxNum)){
      $maxNum = $4;
      $rootRule = "($2) $3 ($4)";
    }
#    print "Adding ($2) $3 ($4) = $5\n";
#    $RuleHash{$1."-($2) $3 ($4)"} = $5;
#    if(exists($RuleHash{"($2) $3 ($4)"})){
#      next;
#    }
#    if(m/\((\d+)\) ([^ ]+) \((\d+)\) => \((\d+)\) ([^ ]+) \((\d+)\)/){
#      if ($1 eq $4 && $3 eq $6 && (int($3)-int($1) > 1)){
#        $Graveyard{"$1 $2 $3"} = "$5";
#        next;
#      }
#    }
    $RuleHash{"($s_i) $lhs ($e_i)"} = $rhs;
  }
}

#print "Root rule is $rootRule\n";
recursiveExpand($rootRule);
print "\n";
#foreach my $ruleNum (keys %maxNums){
#  recursiveExpand($rootRule{$ruleNum}, $ruleNum);
#  print "\n";
#}
