###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

## removeElided.rb
## Removes the __eli word and it's immediate parent from a 
## right-corner transformed tree, thus facilitating processing
## of repair in such trees.

require "scripts/umnlp.rb"

class Tree
  def removeElided!
    if @children.size == 0
      return
    end
    
    ## Do children first
    @children.each{ |child|
      child.removeElided!
    }
    
    ## Now check myself
    ## If right child has one child called "__eli" then
    ## take my left child's head, and his 2 children.
#    if @children.size > 1 and @children[1].children.size > 1 and @children[1].children[1].children[0].head =~ /__eli/
#      @children[1] = @children[1].children[0]
#    els
    if @children.size > 1 and @children[1].children.size == 1 and
      @children[1].children[0].head =~ /__eli/
        @head = @children[0].head
        if @children[0].children[1] != nil
          @children[1] = @children[0].children[1]
        else
          @children.delete_at(1)
        end
        @children[0] = @children[0].children[0]
    elsif @children.size == 1 and @children[0].children.size == 1 and
          @children[0].children[0].children.size != 0
        ## Sometimes this happens when we remove an elided from a multi-reparandum sentence
        @children[0] = @children[0].children[0]
    end
  end
end

while(line = gets)
  t = Tree.new(line)
  t.removeElided!
  if t.prob != nil
    puts "#{t.to_s} : #{t.prob}"
  else
    puts "#{t.to_s} : 1.0"
  end
end
