###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

require "scripts/umnlp.rb"

class Tree
  def maxDepth

    max = @head.gsub(/.*\^([0-9]*).*/,'\1').to_i
    @children.each { |child|
      d = child.maxDepth
      if d > max
        max = d
      end
    }
   
    return max

  end
end

id = 0
totwc = 0
while(line = gets)
  id += 1
  t = Tree.new(line)
  #print "id" + id.to_s + " w=" + t.getNumLeafs.to_s + " d=" + t.maxDepth.to_s + "\n"
  print ("%03d"%t.getNumLeafs) + " " + ("%03d"%t.maxDepth) + "\n"
  totwc += t.getNumLeafs
end
print "AVGWDS---------\n"
print "AVGWDS" + (totwc/id).to_s + "\n"
