#!/usr/bin/perl
###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

###################
# Turn a sequence of predicate labels into data points to be learned by
# relfreq.pl
###################

use strict;

my $MAIN_ARG_ONLY = 0;
my $NO_EXTENSION = 0;
if (defined $ARGV[0] && $ARGV[0] =~ /\-m/) {
	$MAIN_ARG_ONLY = 1;
	delete $ARGV[0];
}

# -ne is no-extension whatsoever. e.g. ARG0, ARG1, ... ARGM. This option covers the $MAIN_ARG_ONLY
if (defined $ARGV[0] && $ARGV[0] =~ /\-ne/) {
	$NO_EXTENSION = 1;
	delete $ARGV[0];
}

sub getMainArg {
  my $arg = shift;
  if ($MAIN_ARG_ONLY == 1) {
  	$arg =~ s/^ARG([0-5])\-.*$/ARG\1/;
  }
  if ($NO_EXTENSION == 1) {
  	$arg =~ s/^ARG([^\-])\-.*$/ARG\1/;
  }
  return $arg;
}

while(<STDIN>){
    unless ( /REL-([^\.]+)\.([^ ]+)/ ) {
	    print STDERR "No REL- in sentence " . $_;
			next;
    }
    # Ignore the features for now
    #my ($label, $sense, $features) = $_ =~ m/REL-([^\.]+)\.([^-]+)-([^ ]+)/;
    my ($label, $sense) = $_ =~ m/REL-([^\.]+)\.([^ ]+)/;      # this looks at the first REL- for predicate
    $_ =~ s/REL[^ ]+/REL/g;
    my @labels = split;
    my $first = $labels[0];
    #print "Ai $label.$sense : $first\n";
    print "A $label.$sense - : " . getMainArg($first) . "\n";
    foreach my $i (0..$#labels-1){
        print "A $label.$sense " . getMainArg($labels[$i]) . " : " . getMainArg($labels[$i+1]) . "\n";
    }
}

