# Multinomial Adversarial Nets
This repo contains the source code for our paper:

[**Multinomial Adversarial Networks for Multi-Domain Text Classification**](https://arxiv.org/abs/1802.05694)
<br>
[Xilun Chen](http://www.cs.cornell.edu/~xlchen/),
[Claire Cardie](http://www.cs.cornell.edu/home/cardie/)
<br>
NAACL 2018 (To appear)

## Requirements:
- Python 3.6
- PyTorch 0.3
- PyTorchNet
- scipy
- tqdm (for progress bar)

An Anaconda `environment.yml` file is also provided.

## Before Running
The data used in our experiments is not included due to space limit.
The full version of our code with data included can be found at:
<br>
<https://github.com/ccsasuke/man>

## Experiment 1: MDTC on the multi-domain Amazon dataset

```bash
cd code/
python train_man_exp1.py --dataset prep-amazon --model mlp
```

## Experiment 2: Multi-Source Domain Adaptation
```bash
cd code/
# target domain: books
python train_man_exp2.py --dataset prep-amazon --model mlp --no_wgan_trick --domains dvd electronics kitchen --unlabeled_domains books --dev_domains books
# target domain: dvd
python train_man_exp2.py --dataset prep-amazon --model mlp --no_wgan_trick --domains books electronics kitchen --unlabeled_domains dvd --dev_domains dvd
# target domain: electronics
python train_man_exp2.py --dataset prep-amazon --model mlp --no_wgan_trick --domains books dvd kitchen --unlabeled_domains electronics --dev_domains electronics
# target domain: kitchen
python train_man_exp2.py --dataset prep-amazon --model mlp --no_wgan_trick --domains dvd electronics kitchen --unlabeled_domains kitchen --dev_domains kitchen
```

## Experiment 3: MDTC on the FDU-MTL dataset

```bash
cd code/
python train_man_exp3.py --dataset fdu-mtl --model cnn --max_epoch 50
```
A larger batch size can also be used to reduce the training time.
