package org.maltparser.core.syntaxgraph.feature;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.AddressFunction;
import org.maltparser.core.feature.value.AddressValue;
import org.maltparser.core.io.dataformat.DataFormatInstance;
import org.maltparser.core.symbol.nullvalue.NullValues.NullValueId;
import org.maltparser.core.syntaxgraph.SyntaxGraphException;
import org.maltparser.core.syntaxgraph.node.DependencyNode;

import java.util.Set;
import java.util.Iterator;
import org.maltparser.core.syntaxgraph.edge.Edge;

public class OutputColumn3T2Feature extends ColumnFeature {
	protected AddressFunction addressFunction;
	protected DataFormatInstance dataFormatInstance;
//	protected int numEdge;
	
	public OutputColumn3T2Feature(DataFormatInstance dataFormatInstance) throws MaltChainedException {
		super();
		setDataFormatInstance(dataFormatInstance);
	}
	
	public void initialize(Object[] arguments) throws MaltChainedException {
		if (arguments.length != 2) {
			throw new SyntaxGraphException("Could not initialize OutputColumn3TFeature: number of arguments are not correct. ");
		}
		if (!(arguments[0] instanceof String)) {
			throw new SyntaxGraphException("Could not initialize OutputColumn3TFeature: the first argument is not a string. ");
		}
		if (!(arguments[1] instanceof AddressFunction)) {
			throw new SyntaxGraphException("Could not initialize OutputColumn3TFeature: the second argument is not an address function. ");
		}
		
		setColumn(dataFormatInstance.getColumnDescriptionByName((String)arguments[0]));
		setAddressFunction((AddressFunction)arguments[1]);
//		setNumEdge(Integer.valueOf((String)arguments[2]));
	}
	
	public Class<?>[] getParameterTypes() {
		Class<?>[] paramTypes = { java.lang.String.class, org.maltparser.core.feature.function.AddressFunction.class };
		return paramTypes; 
	}

	public void update()  throws MaltChainedException {
		
		final AddressValue a = addressFunction.getAddressValue();
		
		if (a.getAddress() == null) {
			featureValue.setCode(column.getSymbolTable().getNullValueCode(NullValueId.NO_NODE));
			featureValue.setSymbol(column.getSymbolTable().getNullValueSymbol(NullValueId.NO_NODE));
			featureValue.setKnown(true);
			featureValue.setNullValue(true);			
		} else {
//			try { 
//				a.getAddressClass().asSubclass(org.maltparser.core.syntaxgraph.node.DependencyNode.class);
			
				final DependencyNode node = (DependencyNode)a.getAddress();
				if (!node.isRoot()) {
					if (node.hasHead()&&node.getHeads().size()>2) {//Debe tener más de una cabeza
						Set<Edge> incomings=node.getHeadEdges();
						Iterator<Edge> it=incomings.iterator();
//						int cont=1;
//						while(it.hasNext() && cont<numEdge)
//						{
//							it.next();
//							cont++;
//						}
						it.next();
						it.next();
						Edge arco=it.next();//arco en la posición numEdge
						featureValue.setCode(arco.getLabelCode(column.getSymbolTable()));
						featureValue.setSymbol(column.getSymbolTable().getSymbolCodeToString(arco.getLabelCode(column.getSymbolTable())));
						featureValue.setKnown(column.getSymbolTable().getKnown(arco.getLabelCode(column.getSymbolTable())));
						featureValue.setNullValue(false);
						
					} else {
						featureValue.setCode(column.getSymbolTable().getNullValueCode(NullValueId.NO_VALUE));
						featureValue.setSymbol(column.getSymbolTable().getNullValueSymbol(NullValueId.NO_VALUE));
						featureValue.setKnown(true);
						featureValue.setNullValue(true);
					}	
				} else {
					featureValue.setCode(column.getSymbolTable().getNullValueCode(NullValueId.ROOT_NODE));
					featureValue.setSymbol(column.getSymbolTable().getNullValueSymbol(NullValueId.ROOT_NODE));
					featureValue.setKnown(true);
					featureValue.setNullValue(true);
				}
//			} catch (ClassCastException e) {
//				featureValue.setCode(column.getSymbolTable().getNullValueCode(NullValueId.NO_NODE));
//				featureValue.setSymbol(column.getSymbolTable().getNullValueSymbol(NullValueId.NO_NODE));
//				featureValue.setKnown(true);
//				featureValue.setNullValue(true);
//			}
				
		}
		
	}
	
	public AddressFunction getAddressFunction() {
		return addressFunction;
	}

	public void setAddressFunction(AddressFunction addressFunction) {
		this.addressFunction = addressFunction;
	}
	
	public DataFormatInstance getDataFormatInstance() {
		return dataFormatInstance;
	}

	public void setDataFormatInstance(DataFormatInstance dataFormatInstance) {
		this.dataFormatInstance = dataFormatInstance;
	}

//	public int getNumEdge() {
//		return numEdge;
//	}
//
//	public void setNumEdge(int numEdge) {
//		this.numEdge = numEdge;
//	}
//	
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		return obj.toString().equals(toString());
	}
	
	public int hashCode() {
		return 217 + (null == toString() ? 0 : toString().hashCode());
	}
	
	public String toString() {
		final StringBuilder sb = new StringBuilder();
		sb.append("OutputColumn3T2(");
		sb.append(super.toString());
		sb.append(", ");
		sb.append(addressFunction.toString());
//		sb.append(", ");
//		sb.append(numEdge);
		sb.append(")");
		return sb.toString();
	}
}


