/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.ucovington;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.Function;
import org.maltparser.parser.AbstractParserFactory;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.ucovington.UcovingtonAddressFunction;
import org.maltparser.parser.algorithm.ucovington.UcovingtonConfig;

public abstract class UcovingtonFactory
implements AbstractParserFactory {
    protected Algorithm algorithm;
    protected DependencyParserConfig manager;

    public UcovingtonFactory(Algorithm algorithm) {
        this.setAlgorithm(algorithm);
        this.setManager(algorithm.getManager());
    }

    public ParserConfiguration makeParserConfiguration() throws MaltChainedException {
        boolean allowRoot = (Boolean)this.manager.getOptionValue("covington", "allow_root");
        boolean allowShift = (Boolean)this.manager.getOptionValue("covington", "allow_shift");
        String recon = (String)this.manager.getOptionValue("covington", "creconstruction");
        String heuristic = (String)this.manager.getOptionValue("covington", "cheuristic");
        if (this.manager.getConfigLogger().isInfoEnabled()) {
            this.manager.getConfigLogger().info("  Parser configuration : Undirected Covington with allow_root=" + allowRoot + " and allow_shift=" + allowShift + ". Reconstruction technique = " + recon + ". Heuristic = " + heuristic + "\n");
        }
        UcovingtonConfig config = new UcovingtonConfig(this.manager.getSymbolTables(), allowRoot, allowShift, recon, heuristic);
        return config;
    }

    public Function makeFunction(String subFunctionName) throws MaltChainedException {
        return new UcovingtonAddressFunction(subFunctionName, this.algorithm);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public DependencyParserConfig getManager() {
        return this.manager;
    }

    public void setManager(DependencyParserConfig manager) {
        this.manager = manager;
    }
}

