/*
 	APS - Affinity Propagation for Segmentation, a linear text segmenter.
 
    Copyright (C) 2011, Anna Kazantseva

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
    */


package commandln;

import java.util.regex.Pattern;

public class StringParam extends ParamBase
{
	private String mValue = null;
	private String mRegex = null;
	private String mDef = null;
	public StringParam(String name, String regex, String defValue)
	{
		super(name, defValue == null, true);
		mRegex = regex;
		mDef = defValue;
	}
	
	@Override
	public void ParseValue(String value) throws Exception 
	{
		if (!Pattern.matches(mRegex, value))
			throw new Exception("Error parsing param: " + mName);
		
		mValue = value;
	}

	@Override
	public String getString() 
	{
		return (mValue == null ? mDef : mValue);
	}
}
