/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.xml;

import com.aliasi.xml.SAXFilterHandler;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated
public class SAXWriterFilter
extends SAXFilterHandler {
    private CharsetEncoder mCharsetEncoder;
    private PrintWriter mPrinter;
    private BufferedWriter mBufWriter;
    private OutputStreamWriter mWriter;
    private String mCharsetName;
    private String mDtdString = null;
    private boolean mStartedElement;
    private final Map<String, String> mPrefixMap = new HashMap<String, String>();

    public SAXWriterFilter(OutputStream out, String charsetName, DefaultHandler handler) throws UnsupportedEncodingException {
        super(handler);
        this.setOutputStream(out, charsetName);
    }

    public SAXWriterFilter() {
    }

    public void setDTDString(String dtdString) {
        this.mDtdString = dtdString;
    }

    public final void setOutputStream(OutputStream out, String charsetName) throws UnsupportedEncodingException {
        Charset charset = Charset.forName(charsetName);
        this.mCharsetEncoder = charset.newEncoder();
        this.mWriter = new OutputStreamWriter(out, this.mCharsetEncoder);
        this.mBufWriter = new BufferedWriter(this.mWriter);
        this.mPrinter = new PrintWriter(this.mBufWriter);
        this.mCharsetName = charsetName;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.printXMLDeclaration();
        this.mStartedElement = false;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.mPrefixMap.put(prefix, uri);
        super.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        if (this.mStartedElement) {
            this.mPrinter.print("/>");
            this.mStartedElement = false;
        }
        this.mPrinter.flush();
        try {
            this.mBufWriter.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.mWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(namespaceURI, localName, qName, atts);
        if (this.mStartedElement) {
            this.mPrinter.print(">");
            this.mStartedElement = false;
        }
        this.mPrinter.print('<');
        this.mPrinter.print(qName);
        this.printAttributes(atts);
        this.mStartedElement = true;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        super.endElement(namespaceURI, localName, qName);
        if (this.mStartedElement) {
            this.mPrinter.print("/>");
            this.mStartedElement = false;
            return;
        }
        this.mPrinter.print('<');
        this.mPrinter.print('/');
        this.mPrinter.print(qName);
        this.mPrinter.print('>');
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (this.mStartedElement) {
            this.mPrinter.print('>');
            this.mStartedElement = false;
        }
        this.printCharacters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
        super.processingInstruction(target, data);
        if (this.mStartedElement) {
            this.mPrinter.print('>');
            this.mStartedElement = false;
        }
        this.mPrinter.print("<?");
        this.mPrinter.print(target);
        if (data != null && data.length() > 0) {
            this.mPrinter.print(' ');
            this.mPrinter.print(data);
        }
        this.mPrinter.print("?>");
    }

    private void printAttributes(Attributes atts) {
        if (this.mPrefixMap.size() > 0) {
            for (Map.Entry<String, String> entry : this.mPrefixMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                this.printAttribute("xmlns:" + key, value);
            }
            this.mPrefixMap.clear();
        }
        TreeSet<String> orderedAtts = new TreeSet<String>();
        for (int i = 0; i < atts.getLength(); ++i) {
            orderedAtts.add(atts.getQName(i));
        }
        for (String attQName : orderedAtts) {
            this.printAttribute(attQName, atts.getValue(attQName));
        }
    }

    private void printAttribute(String att, String val) {
        this.mPrinter.print(' ');
        this.mPrinter.print(att);
        this.mPrinter.print('=');
        this.mPrinter.print('\"');
        this.printCharacters(val);
        this.mPrinter.print('\"');
    }

    private void printCharacters(String s) {
        this.printCharacters(s.toCharArray(), 0, s.length());
    }

    private void printCharacters(char[] ch, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            this.printCharacter(ch[i]);
        }
    }

    private void printCharacter(char c) {
        if (!this.mCharsetEncoder.canEncode(c)) {
            this.printEntity("#x" + Integer.toHexString(c));
            return;
        }
        switch (c) {
            case '<': {
                this.printEntity("lt");
                break;
            }
            case '>': {
                this.printEntity("gt");
                break;
            }
            case '&': {
                this.printEntity("amp");
                break;
            }
            case '\"': {
                this.printEntity("quot");
                break;
            }
            default: {
                this.mPrinter.print(c);
            }
        }
    }

    private void printEntity(String entity) {
        this.mPrinter.print('&');
        this.mPrinter.print(entity);
        this.mPrinter.print(';');
    }

    private void printXMLDeclaration() {
        this.mPrinter.print("<?xml");
        this.printAttribute("version", "1.0");
        this.printAttribute("encoding", this.mCharsetName);
        this.mPrinter.print("?>");
        if (this.mDtdString != null) {
            this.mPrinter.print(this.mDtdString);
        }
    }
}

