/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.features;

import com.aliasi.matrix.SparseFloatVector;
import com.aliasi.matrix.Vector;
import com.aliasi.symbol.SymbolTable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Features {
    private Features() {
    }

    public static Vector toVectorAddSymbols(Map<String, ? extends Number> featureVector, SymbolTable table, int numDimensions, boolean addIntercept) {
        int size = featureVector.size() * 3 / 2;
        HashMap<Integer, Number> vectorMap = new HashMap<Integer, Number>(size);
        for (Map.Entry<String, ? extends Number> entry : featureVector.entrySet()) {
            String feature = entry.getKey();
            Number val = entry.getValue();
            int id = table.getOrAddSymbol(feature);
            vectorMap.put(id, val);
        }
        if (addIntercept) {
            vectorMap.put(0, 1.0);
        }
        return new SparseFloatVector(vectorMap, numDimensions);
    }

    public static Vector toVector(Map<String, ? extends Number> featureVector, SymbolTable table, int numDimensions, boolean addIntercept) {
        int size = featureVector.size() * 3 / 2;
        HashMap<Integer, Number> vectorMap = new HashMap<Integer, Number>(size);
        for (Map.Entry<String, ? extends Number> entry : featureVector.entrySet()) {
            String feature = entry.getKey();
            int id = table.symbolToID(feature);
            if (id < 0) continue;
            Number val = entry.getValue();
            vectorMap.put(id, val);
        }
        if (addIntercept) {
            vectorMap.put(0, 1.0);
        }
        return new SparseFloatVector(vectorMap, numDimensions);
    }
}

