/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.xml;

import com.aliasi.xml.DelegatingHandler;
import com.aliasi.xml.SimpleElementHandler;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DelegateHandler
extends SimpleElementHandler {
    private final Map<String, DefaultHandler> mDelegateMap = new HashMap<String, DefaultHandler>();
    final DelegatingHandler mDelegatingHandler;

    public DelegateHandler(DelegatingHandler handler) {
        this.mDelegatingHandler = handler;
    }

    public void setDelegate(String qName, DefaultHandler handler) {
        if (handler instanceof DelegateHandler && this.mDelegatingHandler != ((DelegateHandler)handler).mDelegatingHandler) {
            String msg = "Delegate handlers must wrap the same delegating handler.";
            throw new IllegalArgumentException(msg);
        }
        this.mDelegateMap.put(qName, handler);
    }

    DefaultHandler getDelegate(String qName) {
        return this.mDelegateMap.get(qName);
    }

    public void finishDelegate(String qName, DefaultHandler handler) {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        DefaultHandler handler = this.getDelegate(qName);
        if (handler == null) {
            return;
        }
        handler.startDocument();
        handler.startElement(namespaceURI, localName, qName, atts);
        int top = ++this.mDelegatingHandler.mStackTop;
        this.mDelegatingHandler.mQNameStack[top] = qName;
        this.mDelegatingHandler.mDelegateStack[top] = handler;
    }
}

