/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tag;

import com.aliasi.classify.ConditionalClassification;
import com.aliasi.symbol.SymbolTable;
import com.aliasi.util.Strings;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TagLattice<E> {
    public abstract List<E> tokenList();

    public abstract List<String> tagList();

    public abstract String tag(int var1);

    public abstract int numTags();

    public abstract E token(int var1);

    public abstract int numTokens();

    public abstract SymbolTable tagSymbolTable();

    public abstract double logProbability(int var1, int var2);

    public abstract double logProbability(int var1, int var2, int var3);

    public abstract double logProbability(int var1, int[] var2);

    public abstract double logForward(int var1, int var2);

    public abstract double logBackward(int var1, int var2);

    public abstract double logTransition(int var1, int var2, int var3);

    public abstract double logZ();

    public ConditionalClassification tokenClassification(int tokenIndex) {
        String[] tags = this.tagList().toArray(Strings.EMPTY_STRING_ARRAY);
        double[] logProbs = new double[tags.length];
        for (int tagId = 0; tagId < tags.length; ++tagId) {
            double logProbTagId = this.logProbability(tokenIndex, tagId);
            logProbs[tagId] = Double.isNaN(logProbTagId) || Double.isInfinite(logProbTagId) ? -500.0 : (logProbTagId > 0.0 ? 0.0 : logProbTagId);
        }
        ConditionalClassification classification = ConditionalClassification.createLogProbs(tags, logProbs);
        return classification;
    }
}

