/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.TagChunkCodec;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.tag.StringTagging;
import com.aliasi.tag.Tagging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagChunkCodecAdapters {
    private TagChunkCodecAdapters() {
    }

    public static ObjectHandler<Chunking> stringTaggingToChunking(TagChunkCodec codec, ObjectHandler<StringTagging> handler) {
        return new StringTaggingHandlerAdapter(codec, handler);
    }

    public static ObjectHandler<Chunking> taggingToChunking(TagChunkCodec codec, ObjectHandler<Tagging<String>> handler) {
        return new TaggingHandlerAdapter(codec, handler);
    }

    public static ObjectHandler<StringTagging> chunkingToStringTagging(TagChunkCodec codec, ObjectHandler<Chunking> handler) {
        return new ChunkingHandlerAdapter(codec, handler);
    }

    public static ObjectHandler<Tagging<String>> chunkingToTagging(TagChunkCodec codec, ObjectHandler<Chunking> handler) {
        return new ChunkingHandlerAdapterPad(codec, handler);
    }

    static StringTagging pad(Tagging<String> tagging) {
        StringBuilder sb = new StringBuilder();
        int[] tokenStarts = new int[tagging.size()];
        int[] tokenEnds = new int[tagging.size()];
        for (int n = 0; n < tagging.size(); ++n) {
            if (n > 0) {
                sb.append(' ');
            }
            tokenStarts[n] = sb.length();
            sb.append(tagging.token(n));
            tokenEnds[n] = sb.length();
        }
        return new StringTagging(tagging.tokens(), tagging.tags(), (CharSequence)sb, tokenStarts, tokenEnds);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChunkingHandlerAdapterPad
    implements ObjectHandler<Tagging<String>> {
        private final TagChunkCodec mCodec;
        private final ObjectHandler<Chunking> mHandler;

        public ChunkingHandlerAdapterPad(TagChunkCodec codec, ObjectHandler<Chunking> handler) {
            this.mCodec = codec;
            this.mHandler = handler;
        }

        @Override
        public void handle(Tagging<String> tagging) {
            StringTagging stringTagging = TagChunkCodecAdapters.pad(tagging);
            Chunking chunking = this.mCodec.toChunking(stringTagging);
            this.mHandler.handle(chunking);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChunkingHandlerAdapter
    implements ObjectHandler<StringTagging> {
        private final TagChunkCodec mCodec;
        private final ObjectHandler<Chunking> mHandler;

        public ChunkingHandlerAdapter(TagChunkCodec codec, ObjectHandler<Chunking> handler) {
            this.mCodec = codec;
            this.mHandler = handler;
        }

        @Override
        public void handle(StringTagging tagging) {
            Chunking chunking = this.mCodec.toChunking(tagging);
            this.mHandler.handle(chunking);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TaggingHandlerAdapter
    implements ObjectHandler<Chunking> {
        private final TagChunkCodec mCodec;
        private final ObjectHandler<Tagging<String>> mHandler;

        public TaggingHandlerAdapter(TagChunkCodec codec, ObjectHandler<Tagging<String>> handler) {
            this.mCodec = codec;
            this.mHandler = handler;
        }

        @Override
        public void handle(Chunking chunking) {
            Tagging<String> tagging = this.mCodec.toTagging(chunking);
            this.mHandler.handle(tagging);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringTaggingHandlerAdapter
    implements ObjectHandler<Chunking> {
        private final TagChunkCodec mCodec;
        private final ObjectHandler<StringTagging> mHandler;

        public StringTaggingHandlerAdapter(TagChunkCodec codec, ObjectHandler<StringTagging> handler) {
            this.mCodec = codec;
            this.mHandler = handler;
        }

        @Override
        public void handle(Chunking chunking) {
            StringTagging tagging = this.mCodec.toStringTagging(chunking);
            this.mHandler.handle(tagging);
        }
    }
}

