/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.coref;

import com.aliasi.coref.CachedMention;
import com.aliasi.coref.Mention;
import com.aliasi.coref.MentionChain;
import com.aliasi.coref.MentionChainImpl;
import com.aliasi.coref.MentionFactory;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.SmallSet;
import com.aliasi.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMentionFactory
implements MentionFactory {
    private int mNextChainIdentifier = 0;
    private final TokenizerFactory mTokenizerFactory;

    public AbstractMentionFactory(TokenizerFactory tokenizerFactory) {
        this.mTokenizerFactory = tokenizerFactory;
    }

    @Override
    public Mention create(String phrase, String entityType) {
        ArrayList<String> tokens = new ArrayList<String>();
        Set<String> honorifics = this.extractTokens(phrase, tokens);
        return new CachedMention(phrase, entityType, honorifics, tokens.toArray(Strings.EMPTY_STRING_ARRAY), this.gender(entityType), this.isPronominal(entityType));
    }

    @Override
    public MentionChain promote(Mention mention, int offset) {
        return new MentionChainImpl(mention, offset, this.nextChainIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextChainIdentifier() {
        AbstractMentionFactory abstractMentionFactory = this;
        synchronized (abstractMentionFactory) {
            return this.mNextChainIdentifier++;
        }
    }

    protected abstract boolean isHonorific(String var1);

    protected abstract String gender(String var1);

    protected abstract boolean isPronominal(String var1);

    protected abstract String normalizeToken(String var1);

    private Set<String> extractTokens(String phrase, List<String> tokens) {
        SmallSet<String> honorifics = SmallSet.create();
        char[] cs = phrase.toCharArray();
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, 0, cs.length);
        for (String token : tokenizer) {
            String normalToken = this.normalizeToken(token);
            if (normalToken == null) continue;
            if (this.isHonorific(normalToken)) {
                honorifics = SmallSet.create(normalToken, honorifics);
                continue;
            }
            tokens.add(normalToken);
        }
        return honorifics;
    }
}

