/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import com.aliasi.util.Arrays;
import java.io.File;
import java.util.Properties;

public abstract class AbstractCommand
implements Runnable {
    private final long mStartTime;
    private final Properties mProperties;
    private int mBareArgCount = 0;
    private Properties mDefaultProperties = null;
    public static final String HAS_PROPERTY_VALUE = "*HAS_PROPERTY_VALUE*";
    public static final String BARE_ARG_PREFIX = "BARE_ARG_";

    public AbstractCommand(String[] args) {
        this(args, new Properties());
    }

    public AbstractCommand(String[] args, Properties defaultProperties) {
        this.mDefaultProperties = defaultProperties;
        this.mProperties = new Properties(defaultProperties);
        this.parse(args);
        this.mStartTime = System.currentTimeMillis();
    }

    public void addDefaultProperty(String property, String defaultValue) {
        this.mDefaultProperties.setProperty(property, defaultValue);
    }

    public long elapsedTimeMillis() {
        return System.currentTimeMillis() - this.mStartTime;
    }

    public long startTimeMillis() {
        return this.mStartTime;
    }

    public abstract void run();

    public int numBareArguments() {
        return this.mBareArgCount;
    }

    public String[] bareArguments() {
        String[] arguments = new String[this.numBareArguments()];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = this.getBareArgument(i);
        }
        return arguments;
    }

    public boolean hasFlag(String arg) {
        String value = this.mProperties.getProperty(arg);
        return value != null && value.equals(HAS_PROPERTY_VALUE);
    }

    public boolean hasProperty(String arg) {
        String value = this.mProperties.getProperty(arg);
        return value != null && !value.equals(HAS_PROPERTY_VALUE);
    }

    public String getBareArgument(int n) {
        return this.mProperties.getProperty(AbstractCommand.bareArgumentProperty(n));
    }

    public String getArgument(String key) {
        return this.mProperties.getProperty(key);
    }

    public Properties getArguments() {
        return this.mProperties;
    }

    public String getExistingArgument(String key) throws IllegalArgumentException {
        String result = this.mProperties.getProperty(key);
        if (result == null) {
            this.illegalPropertyArgument("Require value.", key);
        }
        return result;
    }

    @Deprecated
    public String[] getCSV(String key) {
        String csv = this.getExistingArgument(key);
        String[] result = Arrays.csvToArray(csv);
        return result;
    }

    public boolean hasArgument(String key) {
        return this.mProperties.containsKey(key);
    }

    public int getArgumentInt(String key) {
        String valString = this.getExistingArgument(key);
        try {
            return Integer.valueOf(valString);
        }
        catch (NumberFormatException e) {
            this.illegalPropertyArgument("Required integer.", key);
            return -1;
        }
    }

    public long getArgumentLong(String key) {
        String valString = this.getExistingArgument(key);
        try {
            return Long.valueOf(valString);
        }
        catch (NumberFormatException e) {
            this.illegalPropertyArgument("Required integer.", key);
            return -1L;
        }
    }

    public double getArgumentDouble(String key) {
        String valString = this.getArgument(key);
        if (valString == null) {
            throw new IllegalArgumentException("No value found for argument=" + key);
        }
        try {
            return Double.valueOf(valString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Required double value for arg=" + key + " Found=" + valString);
        }
    }

    public File getArgumentFile(String key) {
        String fileName = this.getExistingArgument(key);
        return new File(fileName);
    }

    public File getArgumentExistingNormalFile(String key) {
        File file = this.getArgumentFile(key);
        if (!file.isFile()) {
            this.illegalPropertyArgument("Require existing normal file.", key);
        }
        return file;
    }

    public File getArgumentDirectory(String key) {
        File dir = this.getArgumentFile(key);
        try {
            if (!dir.isDirectory()) {
                this.illegalPropertyArgument("Require existing directory.", key);
            }
        }
        catch (SecurityException e) {
            this.illegalPropertyArgument("Security exception accessing directory.", key);
        }
        return dir;
    }

    public File getOrCreateArgumentDirectory(String key) {
        File dir = this.getArgumentFile(key);
        try {
            if (dir.isFile()) {
                this.illegalPropertyArgument("Must be existing or creatable directory.", key);
            }
            if (!dir.isDirectory() && !dir.mkdirs()) {
                this.illegalPropertyArgument("Could not create directory.", key);
            }
        }
        catch (SecurityException e) {
            this.illegalPropertyArgument("Security exception inspecting or creating directory.", key);
        }
        return dir;
    }

    protected File getArgumentCreatableFile(String fileParam) {
        File parentDir;
        File file = this.getArgumentFile(fileParam);
        if (file.isDirectory()) {
            this.illegalPropertyArgument("File must be normal.  Found directory=", fileParam);
        }
        if ((parentDir = file.getParentFile()) == null) {
            parentDir = new File(".");
        }
        if (parentDir.isFile()) {
            this.illegalPropertyArgument("Parent cannot be ordinary file.", fileParam);
        }
        if (!parentDir.isDirectory()) {
            System.out.println("Creating model parent directory=" + parentDir);
            parentDir.mkdirs();
        }
        return file;
    }

    private final void parse(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.parseSingleArg(args[i]);
        }
    }

    private final void parseSingleArg(String arg) {
        if (arg.length() < 1) {
            return;
        }
        if (arg.charAt(0) == '-') {
            this.parseSingleBody(arg.substring(1));
        } else {
            this.mProperties.setProperty(AbstractCommand.bareArgumentProperty(this.mBareArgCount++), arg);
        }
    }

    private void parseSingleBody(String arg) {
        if (arg.length() < 1) {
            return;
        }
        int pos = arg.indexOf(61);
        if (pos < 0) {
            this.mProperties.setProperty(arg, HAS_PROPERTY_VALUE);
            return;
        }
        String property = arg.substring(0, pos);
        String value = arg.substring(pos + 1);
        if (property.length() <= 0) {
            this.illegalArgument("Property must have non-zero-length.", '-' + arg + '=' + value);
        }
        this.mProperties.setProperty(property, value);
    }

    protected void illegalPropertyArgument(String msg, String key) {
        throw new IllegalArgumentException(msg + " Found -" + key + "=" + this.getArgument(key));
    }

    protected void illegalArgument(String msg, String arg) {
        this.illegalArgument(msg + "Found:" + arg);
    }

    protected void illegalArgument(String msg, Exception e) {
        this.illegalArgument(msg + " Contained exception =" + e);
    }

    protected void illegalArgument(String msg) {
        throw new IllegalArgumentException(msg);
    }

    public void checkParameterImplication(String ifParam, String thenParam) {
        String ifVal = this.getArgument(ifParam);
        String thenVal = this.getArgument(thenParam);
        if (ifVal != null && thenVal == null) {
            this.illegalArgument("If param=" + ifParam + " is defined, then param=" + thenParam + " should be defined.");
        }
    }

    private static String bareArgumentProperty(int n) {
        return BARE_ARG_PREFIX + n;
    }
}

