/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.features;

import com.aliasi.features.FeatureExtractorFilter;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LengthNormFeatureExtractor<E>
extends FeatureExtractorFilter<E>
implements Serializable {
    static final long serialVersionUID = -5628628360712035433L;

    public LengthNormFeatureExtractor(FeatureExtractor<? super E> extractor) {
        super(extractor);
    }

    @Override
    public Map<String, ? extends Number> features(E in) {
        Map<String, Number> baseMap = this.baseExtractor().features(in);
        double sumOfSquares = 0.0;
        for (Number n : baseMap.values()) {
            double val = n.doubleValue();
            sumOfSquares += val * val;
        }
        if (sumOfSquares == 0.0) {
            return baseMap;
        }
        double length = Math.sqrt(sumOfSquares);
        HashMap<String, Double> resultMap = new HashMap<String, Double>();
        for (Map.Entry<String, Number> entry : baseMap.entrySet()) {
            resultMap.put(entry.getKey(), entry.getValue().doubleValue() / length);
        }
        return resultMap;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Serializer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = 6365515337527915147L;
        private final LengthNormFeatureExtractor<F> mFilter;

        public Serializer() {
            this(null);
        }

        public Serializer(LengthNormFeatureExtractor<F> filter) {
            this.mFilter = filter;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.mFilter.mExtractor);
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            FeatureExtractor extractor = (FeatureExtractor)in.readObject();
            return new LengthNormFeatureExtractor(extractor);
        }
    }
}

