/*
 * Decompiled with CFR 0.152.
 */
package tsg.kernels;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.tools.bzip2.CBZip2OutputStream;
import tsg.TSNodeLabelStructure;
import util.PrintProgress;
import util.Utility;

public abstract class CommonStructures
extends Thread {
    public static int maxCombDaughters = 1000;
    public static int maxDepth = 50;
    public static int flushToDiskEvery = -1;
    public static int flushToDiskFileCounter = 0;
    public static int diskFileCounterSize;
    public static String flushToDiskPath;
    public static String prefixFragmentsFiles;
    public static String prefixTmpFragmentsFiles;
    public static boolean compressTmpFiles;
    int threads;
    int treebankSize;
    int currentIndex;
    PrintProgress progress;
    ArrayList<TSNodeLabelStructure> treebank;
    CommonStructuresThread[] threadsArray;

    static {
        prefixFragmentsFiles = "fragments_";
        prefixTmpFragmentsFiles = "tmp_fragments_";
        compressTmpFiles = true;
    }

    public CommonStructures(ArrayList<TSNodeLabelStructure> treebank, int threads, int startIndex) {
        this.treebank = treebank;
        this.threads = threads;
        this.treebankSize = treebank.size();
        this.currentIndex = startIndex;
    }

    @Override
    public void run() {
        if (this.currentIndex >= this.treebankSize) {
            return;
        }
        this.progress = new PrintProgress("Extracting fragment from treebank :", flushToDiskEvery, this.currentIndex);
        this.extractFromTreebank();
        this.progress.end();
    }

    protected void extractFromTreebank() {
        this.initiateThreadArray();
        int lastThreadIndex = this.threads - 1;
        int i = 0;
        while (i < lastThreadIndex) {
            this.threadsArray[i].start();
            ++i;
        }
        this.threadsArray[lastThreadIndex].run();
        i = 0;
        while (i < lastThreadIndex) {
            try {
                this.threadsArray[i].join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected abstract void initiateThreadArray();

    private synchronized TSNodeLabelStructure[] getNextTreeLoad(int[] startIndex, int[] fileCounter) {
        if (this.currentIndex >= this.treebankSize) {
            return null;
        }
        TSNodeLabelStructure[] result = new TSNodeLabelStructure[flushToDiskEvery];
        startIndex[0] = this.currentIndex;
        fileCounter[0] = ++flushToDiskFileCounter;
        ListIterator<TSNodeLabelStructure> iter = this.treebank.listIterator(this.currentIndex);
        int index = 0;
        while (iter.hasNext()) {
            result[index] = iter.next();
            this.progress.next();
            ++this.currentIndex;
            if (++index == flushToDiskEvery) break;
        }
        return result;
    }

    protected abstract class CommonStructuresThread
    extends Thread {
        int[] startIndex = new int[1];
        int[] fileCounter = new int[1];

        @Override
        public void run() {
            TSNodeLabelStructure[] trees;
            while ((trees = CommonStructures.this.getNextTreeLoad(this.startIndex, this.fileCounter)) != null) {
                this.collectCommonFragments(trees);
                this.flushToDisk();
            }
        }

        protected abstract void collectCommonFragments(TSNodeLabelStructure[] var1);

        private void flushToDisk() {
            if (compressTmpFiles) {
                this.flushToDiskCompressed();
            } else {
                this.flushToDiskStandard();
            }
        }

        private void flushToDiskCompressed() {
            String nextFileNumber = Utility.padZero(diskFileCounterSize, this.fileCounter[0]);
            File outputFile = new File(String.valueOf(flushToDiskPath) + prefixTmpFragmentsFiles + nextFileNumber + ".bz2");
            try {
                BufferedWriter gzipWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new CBZip2OutputStream(new FileOutputStream(outputFile)), "UTF-8"));
                this.printFragmentsToFile(gzipWriter);
                gzipWriter.close();
            }
            catch (Exception e) {
                System.err.println("Problems while writing bzip2 file");
                e.printStackTrace();
                return;
            }
            outputFile.renameTo(new File(String.valueOf(flushToDiskPath) + prefixFragmentsFiles + nextFileNumber + ".bz2"));
            this.clearFragmentBank();
        }

        private void flushToDiskStandard() {
            String nextFileNumber = Utility.padZero(diskFileCounterSize, this.fileCounter[0]);
            File outputFile = new File(String.valueOf(flushToDiskPath) + prefixTmpFragmentsFiles + nextFileNumber + ".txt");
            try {
                BufferedWriter writer = new BufferedWriter(new PrintWriter(outputFile, "UTF-8"));
                this.printFragmentsToFile(writer);
                writer.close();
            }
            catch (Exception e) {
                System.err.println("Problems while writing bzip2 file");
                e.printStackTrace();
                return;
            }
            outputFile.renameTo(new File(String.valueOf(flushToDiskPath) + prefixFragmentsFiles + nextFileNumber + ".txt"));
            this.clearFragmentBank();
        }

        protected abstract void printFragmentsToFile(BufferedWriter var1) throws IOException;

        protected abstract void clearFragmentBank();
    }
}

