/*
 * Decompiled with CFR 0.152.
 */
package tsg;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;
import tsg.TSNodeLabel;
import tsg.corpora.Wsj;
import tsg.parseEval.EvalC;
import util.FileUtil;

public class TsgReranker {
    String workingDir;
    File trainingCorpusFile;
    File goldTestSetFile;
    File parsedTestSetFile;
    TSNodeLabel nextGoldTree;
    ArrayList<TSNodeLabel> nextNBestParses;
    Scanner testScanner;
    Scanner nBestScanner;
    int nBest;
    ArrayList<Integer> iBestIndexes;
    ArrayList<Integer> iWorstIndexes;
    float firstBestFScore;
    float oracleBestFScore;
    float oracleWorstFScore;

    public TsgReranker(String workingDir, File trainingCorpusFile, File goldTestSetFile, File parsedTestSetFile, int nBest) {
        this.workingDir = workingDir;
        this.trainingCorpusFile = trainingCorpusFile;
        this.goldTestSetFile = goldTestSetFile;
        this.parsedTestSetFile = parsedTestSetFile;
        this.nBest = nBest;
        this.testScanner = FileUtil.getScanner(goldTestSetFile);
        this.nBestScanner = FileUtil.getScanner(parsedTestSetFile);
    }

    public void rewind() {
        this.testScanner = FileUtil.getScanner(this.goldTestSetFile);
        this.nBestScanner = FileUtil.getScanner(this.parsedTestSetFile);
    }

    public boolean getNext() throws Exception {
        this.nextGoldTree = null;
        while (this.testScanner.hasNextLine()) {
            String line = this.testScanner.nextLine();
            if (line.equals("")) continue;
            this.nextGoldTree = new TSNodeLabel(line);
            break;
        }
        if (this.nextGoldTree == null) {
            return false;
        }
        this.nextNBestParses = this.getNextNBestParses();
        return true;
    }

    public void makeOracleBest(File oracleBest, boolean printIntermediateResults) throws Exception {
        int totalMatchedBrackets = 0;
        int totalGoldBrackets = 0;
        int totalParsedBrackets = 0;
        this.iBestIndexes = new ArrayList();
        int treeIndex = 0;
        PrintWriter pw = oracleBest == null ? null : FileUtil.getPrintWriter(oracleBest);
        while (this.getNext()) {
            float maxNBestFScore = -1.0f;
            int maxNBestMatchedBrackets = -1;
            int maxNBestParsedBrackets = -1;
            TSNodeLabel bestTree = null;
            int bestIndex = -1;
            int i = 0;
            for (TSNodeLabel iBest : this.nextNBestParses) {
                float fscore;
                int[] scores = EvalC.getScores(this.nextGoldTree, iBest, true);
                if (i == 0) {
                    totalGoldBrackets += scores[1];
                }
                if ((fscore = EvalC.fscore(scores)) > maxNBestFScore) {
                    maxNBestFScore = fscore;
                    maxNBestMatchedBrackets = scores[0];
                    maxNBestParsedBrackets = scores[2];
                    bestTree = iBest;
                    bestIndex = i;
                }
                ++i;
            }
            if (oracleBest != null) {
                pw.println(bestTree.toString());
            }
            this.iBestIndexes.add(bestIndex);
            ++treeIndex;
            this.oracleBestFScore = EvalC.fscore(totalMatchedBrackets += maxNBestMatchedBrackets, totalGoldBrackets, totalParsedBrackets += maxNBestParsedBrackets);
            if (!printIntermediateResults) continue;
            System.out.println(String.valueOf(treeIndex) + ") fscore: " + maxNBestFScore + "  Temp. Oracle score: " + this.oracleBestFScore);
        }
        this.oracleBestFScore = EvalC.fscore(totalMatchedBrackets, totalGoldBrackets, totalParsedBrackets);
        System.out.println(" Oracle best score: " + this.oracleBestFScore);
        if (oracleBest != null) {
            pw.close();
        }
    }

    public void makeOracleFirstBestWorst(File firstBest, File oracleBest, File oracleWorst) throws Exception {
        int totalGoldBrackets = 0;
        int firstTotalMatchedBrackets = 0;
        int firstTotalParsedBrackets = 0;
        int bestTotalMatchedBrackets = 0;
        int bestTotalParsedBrackets = 0;
        int worstTotalMatchedBrackets = 0;
        int worstTotalParsedBrackets = 0;
        this.iBestIndexes = new ArrayList();
        this.iWorstIndexes = new ArrayList();
        int treeIndex = 0;
        PrintWriter pwFirst = FileUtil.getPrintWriter(firstBest);
        PrintWriter pwBest = FileUtil.getPrintWriter(oracleBest);
        PrintWriter pwWorst = FileUtil.getPrintWriter(oracleWorst);
        while (this.getNext()) {
            float maxNBestFScore = -1.0f;
            float minNBestFScore = 2.0f;
            int maxNBestMatchedBrackets = 0;
            int maxNBestParsedBrackets = 0;
            int minNBestMatchedBrackets = 0;
            int minNBestParsedBrackets = 0;
            TSNodeLabel bestTree = null;
            TSNodeLabel worstTree = null;
            int bestIndex = -1;
            int worstIndex = -1;
            int i = 0;
            for (TSNodeLabel iBest : this.nextNBestParses) {
                int[] scores = EvalC.getScores(this.nextGoldTree, iBest, true);
                float fscore = EvalC.fscore(scores);
                if (i == 0) {
                    totalGoldBrackets += scores[1];
                    pwFirst.println(iBest.toString());
                    firstTotalMatchedBrackets += scores[0];
                    firstTotalParsedBrackets += scores[2];
                }
                if (fscore > maxNBestFScore) {
                    maxNBestFScore = fscore;
                    maxNBestMatchedBrackets = scores[0];
                    maxNBestParsedBrackets = scores[2];
                    bestTree = iBest;
                    bestIndex = i;
                }
                if (fscore < minNBestFScore) {
                    minNBestFScore = fscore;
                    minNBestMatchedBrackets = scores[0];
                    minNBestParsedBrackets = scores[2];
                    worstTree = iBest;
                    worstIndex = i;
                }
                ++i;
            }
            pwBest.println(bestTree.toString());
            pwWorst.println(worstTree.toString());
            bestTotalMatchedBrackets += maxNBestMatchedBrackets;
            bestTotalParsedBrackets += maxNBestParsedBrackets;
            worstTotalMatchedBrackets += minNBestMatchedBrackets;
            worstTotalParsedBrackets += minNBestParsedBrackets;
            this.iBestIndexes.add(bestIndex);
            this.iWorstIndexes.add(worstIndex);
            ++treeIndex;
        }
        this.firstBestFScore = EvalC.fscore(firstTotalMatchedBrackets, totalGoldBrackets, firstTotalParsedBrackets);
        this.oracleBestFScore = EvalC.fscore(bestTotalMatchedBrackets, totalGoldBrackets, bestTotalParsedBrackets);
        this.oracleWorstFScore = EvalC.fscore(worstTotalMatchedBrackets, totalGoldBrackets, worstTotalParsedBrackets);
        System.out.println("First best score: " + this.firstBestFScore);
        System.out.println("Oracle best score: " + this.oracleBestFScore);
        System.out.println("Oracle worst score: " + this.oracleWorstFScore);
        pwFirst.close();
        pwBest.close();
        pwWorst.close();
    }

    public void makeOneBestFile(File oneBestFile) throws Exception {
        PrintWriter pw = FileUtil.getPrintWriter(oneBestFile);
        while (this.getNext()) {
            TSNodeLabel oneBestTree = this.nextNBestParses.get(0);
            pw.println(oneBestTree.toString());
        }
        pw.close();
    }

    public static ArrayList<TSNodeLabel> nextNBest(int nBest, Scanner s) throws Exception {
        ArrayList<TSNodeLabel> result = new ArrayList<TSNodeLabel>(nBest);
        int count = 0;
        while (s.hasNextLine() && count < nBest) {
            String line = s.nextLine();
            if (line.equals("")) {
                return result;
            }
            result.add(new TSNodeLabel(line));
            ++count;
        }
        while (s.hasNextLine() && !s.nextLine().equals("")) {
        }
        return result;
    }

    private ArrayList<TSNodeLabel> getNextNBestParses() throws Exception {
        ArrayList<TSNodeLabel> currentNBest = new ArrayList<TSNodeLabel>();
        while (this.nBestScanner.hasNextLine()) {
            String line = this.nBestScanner.nextLine();
            if (line.equals("")) {
                if (!currentNBest.isEmpty()) break;
                continue;
            }
            if (!line.startsWith("(")) continue;
            currentNBest.add(new TSNodeLabel(line));
        }
        return currentNBest;
    }

    public static void cfg() throws Exception {
        int nBest = 1000;
        EvalC.REMOVE_SEMANTIC_TAGS = false;
        String workingDir = "/scratch/fsangati/RESULTS/TSG/CFG/Nbest/";
        File nBestFile = new File(String.valueOf(workingDir) + "BITPAR_OUTPUT_POSTPROCESSED.txt");
        File goldFile = new File(String.valueOf(workingDir) + "wsj-22_clean.mrg");
        File trainigFile = new File(String.valueOf(workingDir) + "wsj-02-21_TOP.mrg");
        TsgReranker reranker = new TsgReranker(workingDir, trainigFile, goldFile, nBestFile, nBest);
        File oracleBest = new File(String.valueOf(workingDir) + "oracleBest_semTagOn.mrg");
        reranker.makeOracleBest(oracleBest, false);
        File evalF = new File(String.valueOf(workingDir) + "oracle_evalF_semTagOn.txt");
        File evalFlog = new File(String.valueOf(workingDir) + "oracle_evalF_semTagOn.log");
        EvalC.staticEvalC(goldFile, oracleBest, evalF, evalFlog, true);
    }

    public static void kernelSimple() throws Exception {
        int nBest = 1000;
        String workingDir = "/scratch/fsangati/RESULTS/TSG/TSGkernels/Wsj/parsing/BigGrammar1000L1_SemTagOff/";
        File nBestFile = new File(String.valueOf(workingDir) + "BITPAR_OUTPUT_POSTPROCESSED.txt");
        File goldFile = new File(String.valueOf(workingDir) + "wsj-22_clean.mrg");
        File oracleBestFile = new File(String.valueOf(workingDir) + "oracle_best.mrg");
        File oneBestFile = new File(String.valueOf(workingDir) + "wsj-22_one_best.mrg");
        TsgReranker reranker = new TsgReranker(workingDir, null, goldFile, nBestFile, nBest);
        reranker.makeOracleBest(oracleBestFile, true);
        reranker.makeOneBestFile(oneBestFile);
        File evalF = new File(String.valueOf(workingDir) + "oracle_evalF_semTagOff.txt");
        File evalFlog = new File(String.valueOf(workingDir) + "oracle_evalF_semTagOff.log");
        EvalC.staticEvalC(goldFile, oracleBestFile, evalF, evalFlog, true);
    }

    public static void standfordKernelOracle() throws Exception {
        String workingDir = "/scratch/fsangati/RESULTS/TSG/TSGkernels/Wsj/parsing/Standford_BigKernelGrammar/";
        File goldFile = new File(String.valueOf(workingDir) + "wsj-22_clean.mrg");
        File kernelOracleFile = new File(String.valueOf(workingDir) + "kernel_oracle_best.mrg");
        File standfordOracleFile = new File(String.valueOf(workingDir) + "standford_oracle_best.mrg");
        File superOracleFile = new File(String.valueOf(workingDir) + "super_oracle_best.mrg");
        PrintWriter pw = FileUtil.getPrintWriter(superOracleFile);
        Scanner goldScanner = FileUtil.getScanner(goldFile);
        Scanner kernelScanner = FileUtil.getScanner(kernelOracleFile);
        Scanner standfordScanner = FileUtil.getScanner(standfordOracleFile);
        while (kernelScanner.hasNextLine()) {
            float standfordFScore;
            String goldLine = goldScanner.nextLine();
            TSNodeLabel goldTree = new TSNodeLabel(goldLine);
            String kernelLine = kernelScanner.nextLine();
            TSNodeLabel kernelTree = new TSNodeLabel(kernelLine);
            String standfordLine = standfordScanner.nextLine();
            TSNodeLabel standfordTree = new TSNodeLabel(standfordLine);
            int[] kernelScores = EvalC.getScores(goldTree, kernelTree, true);
            int[] standfordScores = EvalC.getScores(goldTree, standfordTree, true);
            float kernelFScore = EvalC.fscore(kernelScores);
            if (kernelFScore >= (standfordFScore = EvalC.fscore(standfordScores))) {
                pw.println(kernelTree.toString());
                continue;
            }
            pw.println(standfordTree.toString());
        }
        pw.close();
        kernelScanner.close();
        standfordScanner.close();
        File evalF = new File(String.valueOf(workingDir) + "super_oracle_evalF_semTagOff.txt");
        File evalFlog = new File(String.valueOf(workingDir) + "super_oracle_evalF_semTagOff.log");
        EvalC.staticEvalC(goldFile, superOracleFile, evalF, evalFlog, true);
    }

    public static void evalStandfordNBest() throws Exception {
        int nBest = 10;
        String workingDir = "/scratch/fsangati/RESULTS/StandfordParser/";
        File nBestFileClean = new File(String.valueOf(workingDir) + "wsj-22_parsed_1000_factored_clean.mrg");
        File goldFile = new File(String.valueOf(workingDir) + "wsj-22_gold_clean.mrg");
        File oracleBestFile = new File(String.valueOf(workingDir) + "wsj-22_oracle_best.mrg");
        TsgReranker reranker = new TsgReranker(workingDir, null, goldFile, nBestFileClean, nBest);
        reranker.makeOracleBest(oracleBestFile, true);
        File evalF = new File(String.valueOf(workingDir) + "oracleBest_evalF_semTagOff.txt");
        File evalFlog = new File(String.valueOf(workingDir) + "oracleBest_evalF_semTagOff.log");
        EvalC.staticEvalC(goldFile, oracleBestFile, evalF, evalFlog, true);
    }

    public static void evalNBest(String workingDir, File goldFile, File nBestFileClean, File oracleBestFile, File oracleWorstFile, File oneBestFile, int nBest) throws Exception {
        TsgReranker reranker = new TsgReranker(workingDir, null, goldFile, nBestFileClean, nBest);
        reranker.makeOracleFirstBestWorst(oneBestFile, oracleBestFile, oracleWorstFile);
        File evalF = new File(String.valueOf(workingDir) + "oracleBest_evalF_semTagOff.txt");
        File evalFlog = new File(String.valueOf(workingDir) + "oracleBest_evalF_semTagOff.log");
        EvalC.staticEvalC(goldFile, oracleBestFile, evalF, evalFlog, true);
        evalF = new File(String.valueOf(workingDir) + "oracleWorst_evalF_semTagOff.txt");
        evalFlog = new File(String.valueOf(workingDir) + "oracleWorst_evalF_semTagOff.log");
        EvalC.staticEvalC(goldFile, oracleWorstFile, evalF, evalFlog, true);
        evalF = new File(String.valueOf(workingDir) + "oneBest_evalF_semTagOff.txt");
        evalFlog = new File(String.valueOf(workingDir) + "oneBest_evalF_semTagOff.log");
        EvalC.staticEvalC(goldFile, oneBestFile, evalF, evalFlog, true);
    }

    public static void cleanStandfordNBest() throws Exception {
        String workingDir = "/scratch/fsangati/RESULTS/StandfordParser/";
        File nBestFile = new File(String.valueOf(workingDir) + "wsj-22_parsed_1000_factored.mrg");
        File nBestFileClean = new File(String.valueOf(workingDir) + "wsj-22_parsed_1000_factored_clean.mrg");
        Scanner scan = FileUtil.getScanner(nBestFile);
        PrintWriter pw = FileUtil.getPrintWriter(nBestFileClean);
        String currentTreeLines = "";
        String currentTreeFlat = null;
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.startsWith("#")) continue;
            if (line.length() == 0) {
                TSNodeLabel currentTree = new TSNodeLabel(currentTreeLines = currentTreeLines.replaceAll("\\s+", " ").replaceAll("\\\\", ""));
                String flat = currentTree.toFlatSentence();
                if (!flat.equals(currentTreeFlat)) {
                    if (currentTreeFlat != null) {
                        pw.println();
                    }
                    currentTreeFlat = flat;
                }
                pw.println(currentTree.daughters[0].toString());
                currentTreeLines = "";
            }
            currentTreeLines = String.valueOf(currentTreeLines) + line;
        }
        pw.close();
    }

    private static void evalChiarniack() throws Exception {
        String workingDir = "/scratch/fsangati/RESULTS/ChiarniakParser/wsj22/";
        File wsj22parsed = new File(String.valueOf(workingDir) + "wsj-22_chiarniak_parsed1000.mrg");
        File wsj22parsedCleaned = new File(String.valueOf(workingDir) + "wsj-22_chiarniak_parsed1000_cleaned.mrg");
        Scanner scan = FileUtil.getScanner(wsj22parsed);
        PrintWriter pw = FileUtil.getPrintWriter(wsj22parsedCleaned);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.equals("")) {
                pw.println();
                continue;
            }
            if (!line.startsWith("(")) continue;
            pw.println(line.replaceAll("S1", "TOP").replaceAll("\\\\", ""));
        }
        scan.close();
        pw.close();
        File goldFile = new File(String.valueOf(workingDir) + "wsj-22_clean.mrg");
        File oracleBestFile = new File(String.valueOf(workingDir) + "wsj-22_oracleBest.mrg");
        File oracleWorstFile = new File(String.valueOf(workingDir) + "wsj-22_oracleWorst.mrg");
        File oneBestFile = new File(String.valueOf(workingDir) + "wsj-22_oneBest.mrg");
        TsgReranker.evalNBest(workingDir, goldFile, wsj22parsedCleaned, oracleBestFile, oracleWorstFile, oneBestFile, 1000);
    }

    private static void getOracleExactMatchCharniack() throws Exception {
        String workingDir = "ChiarniakParser/WSJ23/wsj23_EN_noAux/";
        File best1000File = new File("/scratch/fsangati/RESULTS/" + workingDir + "wsj-23_1000best_noAux_cleaned.mrg");
        Scanner scan = FileUtil.getScanner(best1000File);
        File origianlFile = new File(String.valueOf(Wsj.WsjOriginalCleanedTop) + "wsj-23.mrg");
        ArrayList<TSNodeLabel> treebank = TSNodeLabel.getTreebank(origianlFile);
        System.out.println("Total trees: " + treebank.size());
        int exactMatch = 0;
        int treeBankCount = 0;
        block0: for (TSNodeLabel g : treebank) {
            ++treeBankCount;
            ArrayList<TSNodeLabel> nBest = TsgReranker.nextNBest(1000, scan);
            float maxFScore = -1.0f;
            for (TSNodeLabel t : nBest) {
                int[] scores = EvalC.getScores(g, t, true);
                float fscore = EvalC.fscore(scores);
                boolean hasSamePosTag = t.hasSamePosTag(g);
                if (hasSamePosTag && fscore == 1.0f) {
                    System.out.println(String.valueOf(++exactMatch) + " / " + treeBankCount);
                    continue block0;
                }
                if (!(fscore > maxFScore)) continue;
                maxFScore = fscore;
            }
        }
        System.out.println("Total trees: " + treeBankCount);
        System.out.println("Exact match: " + exactMatch);
        float exactMatchRate = (float)exactMatch / (float)treeBankCount;
        System.out.println("Exact match reate: " + exactMatchRate);
    }

    public static void main(String[] args) throws Exception {
        TsgReranker.getOracleExactMatchCharniack();
    }
}

