/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import settings.Parameters;
import tsg.parser.CacheManager;
import tsg.parser.Cell;
import tsg.parser.TestSet;

public class DiskCacheManager
extends CacheManager {
    Hashtable<ArrayList<Integer>, File> fileIndex = new Hashtable();
    int fileCounter = 0;
    static final String workingPath = "/scratch/fsangati/workingPath/";

    public DiskCacheManager(TestSet test) {
        super(test);
    }

    @Override
    public int inquire(ArrayList<Integer> subString) {
        if (!Parameters.cachingActive || subString.size() < 1) {
            return 0;
        }
        if (!this.test.containsSubString(subString)) {
            return 0;
        }
        if (this.fileIndex.containsKey(subString)) {
            return 1;
        }
        return -1;
    }

    @Override
    public void writeToCache(Cell cellToStore) {
        File cellFile = new File("/scratch/fsangati/workingPath/cell_" + cellToStore.yield.size() + "_" + ++this.fileCounter);
        cellToStore.toBinaryFile(cellFile);
        this.fileIndex.put(cellToStore.yield, cellFile);
    }

    @Override
    public Cell readFromCache(ArrayList<Integer> yield) {
        File requestedFile = this.fileIndex.get(yield);
        return Cell.fromBinaryFile(requestedFile);
    }
}

