/*
 * Decompiled with CFR 0.152.
 */
package tsg.LTSG;

import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import settings.Parameters;
import tsg.LTSG.LTSG;
import tsg.TSNode;
import tsg.corpora.ConstCorpus;
import util.FileUtil;
import util.Utility;

public class LTSG_Entropy
extends LTSG {
    public static final String Current = "Current";
    public static final String Random = "Random";
    public static final String FirstLeft = "FirstLeft";
    public static final String FirstRight = "FirstRight";
    public static final String RandomChange = "RandomChange";
    public static final String BiggestChange = "BiggestChange";
    public static final String SmallestChange = "SmallestChange";
    public static final String[] OrderOfChangeTypes = new String[]{"RandomChange", "BiggestChange", "SmallestChange"};

    public void assignStartingHeads() {
        FileUtil.appendReturn("Assigning Starting Heads: " + Parameters.startingHeads, Parameters.logFile);
        if (Parameters.startingHeads.equals(Current)) {
            Parameters.trainingCorpus.correctHeadAnnotation();
            return;
        }
        Parameters.trainingCorpus.removeHeadAnnotations();
        if (Parameters.startingHeads.equals(Random)) {
            Parameters.trainingCorpus.assignRandomHeads();
        } else if (Parameters.startingHeads.equals(FirstLeft)) {
            Parameters.trainingCorpus.assignFirstLeftHeads();
        } else if (Parameters.startingHeads.equals(FirstRight)) {
            Parameters.trainingCorpus.assignFirstRightHeads();
        }
    }

    public void hillClimbing() {
        boolean increasing;
        this.assignStartingHeads();
        ConstCorpus originalTrainingCorpus = null;
        if (Parameters.posTagConversion) {
            originalTrainingCorpus = Parameters.trainingCorpus.deepClone();
            Parameters.trainingCorpus.makePosTagsLexicon();
        }
        this.readTreesFromCorpus(Parameters.spineConversion);
        double entropy = this.entropy();
        String log = "Hill Climbing procedure\n\tStart Entropy:\t" + entropy;
        FileUtil.appendReturn(log, Parameters.logFile);
        int cycle = 0;
        int maxCycles = Parameters.maxEntropyCycles;
        do {
            --maxCycles;
            increasing = false;
            double total_delta = 0.0;
            for (TSNode tree : Parameters.trainingCorpus.treeBank) {
                double delta_entropy = this.hillClimbing(tree);
                if (!(delta_entropy > 0.0)) continue;
                total_delta += delta_entropy;
                entropy -= delta_entropy;
                increasing = true;
            }
            log = "\tHC cycle: " + ++cycle + "\tEntropy: " + entropy;
            log = String.valueOf(log) + "\tDelta Entropy: " + total_delta;
            FileUtil.appendReturn(log, Parameters.logFile);
        } while (increasing && maxCycles != 0);
        log = "Count of trees after hillclimbing. # Trees: " + this.template_freq.size();
        FileUtil.appendReturn(log, Parameters.logFile);
        if (Parameters.posTagConversion) {
            Parameters.trainingCorpus.unMakePosTagsLexicon(originalTrainingCorpus);
        }
    }

    private double hillClimbing(TSNode tree) {
        List<TSNode> internals = tree.collectNodes(true, false, false, false);
        double delta_entropy = 0.0;
        boolean increase = true;
        int changes = Parameters.maxNumberOfChanges;
        while (changes != 0 && increase) {
            increase = false;
            if (Parameters.orderOfChange == 0) {
                Collections.shuffle(internals);
            }
            double bestDelta_value = Parameters.orderOfChange == 1 ? 0.0 : Double.MAX_VALUE;
            TSNode old_HeadNode = null;
            TSNode new_HeadNode = null;
            String[] decreasing_trees = null;
            String[] increasing_trees = null;
            for (TSNode node : internals) {
                TSNode[] head_choices = node.daughters;
                int prole = head_choices.length;
                TSNode originalMarkedDaughter = node.getHeadDaughter();
                while (node.headMarked && node.parent != null) {
                    node = node.parent;
                }
                TSNode original_head_tree = node.lexicalizedTreeCopy();
                original_head_tree.applyAllConversions();
                TSNode new_dependent_tree = originalMarkedDaughter.lexicalizedTreeCopy();
                new_dependent_tree.applyAllConversions();
                String original_head_lexicon = original_head_tree.getAnchor().label;
                int[] daughter_index = null;
                if (Parameters.orderOfChange == 0) {
                    daughter_index = Utility.permutation(prole);
                }
                int d = 0;
                while (d < prole) {
                    TSNode D;
                    TSNode tSNode = D = Parameters.orderOfChange == 0 ? head_choices[daughter_index[d]] : head_choices[d];
                    if (!D.headMarked) {
                        originalMarkedDaughter.headMarked = false;
                        D.headMarked = true;
                        TSNode original_dependent_tree = D.lexicalizedTreeCopy();
                        original_dependent_tree.applyAllConversions();
                        TSNode new_head_tree = node.lexicalizedTreeCopy();
                        new_head_tree.applyAllConversions();
                        String new_head_lexicon = new_head_tree.getAnchor().label;
                        originalMarkedDaughter.headMarked = true;
                        D.headMarked = false;
                        Hashtable<String, Integer> temp_ETrees_freq = new Hashtable<String, Integer>();
                        Hashtable<String, Integer> temp_lex_freq = new Hashtable<String, Integer>();
                        String original_head_tree_String = original_head_tree.toString(false, true);
                        String original_dependent_tree_String = original_dependent_tree.toString(false, true);
                        String new_head_tree_String = new_head_tree.toString(false, true);
                        String new_dependent_tree_String = new_dependent_tree.toString(false, true);
                        String[] trees = new String[]{original_head_tree_String, original_dependent_tree_String, new_head_tree_String, new_dependent_tree_String};
                        String[] lex = new String[]{original_head_lexicon, new_head_lexicon};
                        Utility.putStringIntegerFromToTable(trees, this.template_freq, temp_ETrees_freq);
                        Utility.putStringIntegerFromToTable(lex, this.lexicon_freq, temp_lex_freq);
                        double H0 = LTSG.entropy(temp_ETrees_freq, temp_lex_freq);
                        Utility.decreaseStringInteger(temp_ETrees_freq, original_head_tree_String, 1);
                        Utility.decreaseStringInteger(temp_ETrees_freq, original_dependent_tree_String, 1);
                        Utility.increaseStringInteger(temp_ETrees_freq, new_head_tree_String, 1);
                        Utility.increaseStringInteger(temp_ETrees_freq, new_dependent_tree_String, 1);
                        double H1 = LTSG.entropy(temp_ETrees_freq, temp_lex_freq);
                        double delta = H0 - H1;
                        if (delta > Parameters.entropy_delta_threshold) {
                            increase = true;
                            boolean foundBestDelta = true;
                            if (Parameters.orderOfChange != 0) {
                                boolean bl = Parameters.orderOfChange == 1 ? delta > bestDelta_value : (foundBestDelta = delta < bestDelta_value);
                            }
                            if (foundBestDelta) {
                                decreasing_trees = new String[]{original_head_tree_String, original_dependent_tree_String};
                                increasing_trees = new String[]{new_head_tree_String, new_dependent_tree_String};
                                bestDelta_value = delta;
                                old_HeadNode = originalMarkedDaughter;
                                new_HeadNode = D;
                                if (Parameters.orderOfChange == 0) break;
                            }
                        }
                    }
                    ++d;
                }
                if (increase && Parameters.orderOfChange == 0) break;
            }
            if (!increase) continue;
            delta_entropy += bestDelta_value;
            --changes;
            old_HeadNode.headMarked = false;
            new_HeadNode.headMarked = true;
            Utility.increaseStringInteger(this.template_freq, increasing_trees[0], 1);
            Utility.increaseStringInteger(this.template_freq, increasing_trees[1], 1);
            Utility.decreaseStringInteger(this.template_freq, decreasing_trees[0], 1);
            Utility.decreaseStringInteger(this.template_freq, decreasing_trees[1], 1);
        }
        return delta_entropy;
    }

    public static void main(String[] args) {
        throw new Error("Unresolved compilation problem: \n\tThe constructor Parser(LTSG_Entropy) is undefined\n");
    }
}

