import json
from concurrent.futures import ThreadPoolExecutor
from openai_access import call_chatgpt
from tqdm import tqdm

def process_data(data):
    return call_chatgpt(data['instruction'], max_tokens=4096)
with open('all_dollyMCTS_v0.jsonl','r') as f:
    all_data=json.load(f)


with ThreadPoolExecutor(max_workers=8) as executor:

    results = list(tqdm(executor.map(process_data, all_data), total=len(all_data)))


for data, result in zip(datas, results):
    if(type(result)==list):
        data['output'] = result[0]
        data['input']=""
        data['instruction']=data['instruction']
    else:
        data['output'] = result
        data['input']=""
        data['instruction']=data['instruction']

with open('./MCTS_1k_dolly_v1_response.jsonl','w') as f:
    json.dump(datas, f,indent=4)