## Finetuning on KG-sourced planning data
The code of fine-tuning is constructed based on open-sourced repo LLaMA-Factory(https://github.com/hiyouga/LLaMA-Factory).

Before running experiments, make sure you have downloaded the base model (Llama-3-8B-Instruct or CodeQwen1.5-7B-Chat). Fill in your base model directory, output directory in the shell script. 

It should be note that the training data `kg_supervise.json` contains only one example. We will release training data if accept.

Finetune Llama3:
```
cd fine-tuning
sh run_exp_llama.sh
```

Finetune CodeQwen:
```
cd finetuning
sh run_exp_qwen.sh
```

## Predict the Plan on Downstream QA Datasets
Before running script, fill in your checkpoint directory, base model directory, output directory, and the name of the dataset to be predicted in the script.

it should be note that the `output` in `*_planning.json` is not the true output of planning LLM. They are just the final answers to questions.

Infer Llama3:
```
sh run_predict_llama.sh
```
Infer CodeQwen:
```
sh run_predict_qwen.sh
```

## Parse Result
1. Download the wikipedia dump and put them into `/wikidump/`.
```
cd parser/wikidump
wget https://dl.fbaipublicfiles.com/dpr/wikipedia_split/psgs_w100.tsv.gz
wget https://dl.fbaipublicfiles.com/contriever/embeddings/contriever-msmarco/wikipedia_embeddings.tar
```
2. Download retriever model(Contriever-MSMARCO) and put it into `/contriever_ms/`
3. Fill the planning result directory and output directory in `parse_result.py`
4. Fill your OpenAI key in `gpt/call_gpt.py`
5. Run parser. Make sure you have enough GPU memory to load wikipedia embedding(we use 2*80G A100 in our experiments):
```
cd parser
python parse_result.py
```