
# prefix-16
  i=16
  task="ic"
  size="large"
# server environment
  base_dir="/data"
  data_dir="${base_dir}/flickr30k/features"

  output_path="${base_dir}/trained_output/PGF_${size}/${task}_flickr/pt_ft/${i}/"
  oscar_base_model_path="${base_dir}/oscar_pretrained/${task}/${size}/"

# output
  model_path="${output_path}/wandb/latest-run/files/best"
  eval_output_path="${output_path}/wandb/latest-run/files"

# input
  train_yaml="${data_dir}/train/train.yaml"
  test_yaml="${data_dir}/test/test-dev.yaml"
  val_yaml="${data_dir}/val/val.yaml"

  seed=88
  random_id=$(cat /dev/urandom | tr -dc 'A-Z' | fold -w 2 | sed 1q)

  # PT training
  torchrun \
  --nproc_per_node=8 \
  ./task/captioning/main.py \
  --cfg ./config/flickr30k/base_ce_prefix_1_cfg.yaml  \
  --name "PGF_${size}_PT_${i}_seed_${seed}_id_${random_id}" \
  --seed ${seed} \
  --num_train_epochs 30 \
  --model_name_or_path ${oscar_base_model_path} \
  --output_dir ${output_path} \
  --prefix_drop_prob 0.05 \
  --prefix_shuffle_prob 0.15 \
  --learning_rate 5e-05 \
  --weight_decay 0.1 \
  --per_gpu_train_batch_size 64 \
  --freeze_backbone True \
  --add_prefix True \
  --freeze_prefix False \
  --mlp_for_prefix True \
  --num_prefix ${i} \
  --tag_sep_token False \
  --freeze_embedding True


  prefix_model=$(readlink -f ${model_path})

  # FT training
  torchrun \
  --nproc_per_node=8 \
  ./task/captioning/main.py \
  --cfg ./config/flickr30k/base_ce_prefix_1_cfg.yaml  \
  --name "PGF_${size}_FT_${i}_seed_${seed}_id_${random_id}" \
  --seed $seed \
  --num_train_epochs 70 \
  --weight_decay 0.15 \
  --per_gpu_train_batch_size 64 \
  --model_name_or_path ${prefix_model} \
  --output_dir ${output_path} \
  --tag_sep_token False \
  --max_grad_norm 10.0 \
  --learning_rate 3e-05 \
  --add_prefix True \
  --freeze_backbone False \
  --freeze_prefix False \
  --mlp_for_prefix True \
  --num_prefix ${i} \
  --tag_sep_token False \
  --freeze_embedding True

  torchrun \
  --nproc_per_node=8 \
  ./task/captioning/main.py \
  --cfg ./config/flickr30k/base_test_cfg.yaml  \
  --eval_model_dir ${model_path} \
  --num_prefix ${i} \
  --output_dir ${eval_output_path}

## OSCAR model
## server environment
#  output_path="${base_dir}/trained_output/OSCAR_${size}/${task}_flickr/${i}/"
#
## output
#  model_path="${output_path}/best"
#  eval_output_path="${output_path}/best"
#
#  # CE training
#  torchrun \
#  --nproc_per_node=8 \
#  ./task/captioning/main.py \
#  --cfg ./config/flickr30k/base_ce_vinvl_cfg.yaml  \
#  --per_gpu_train_batch_size 64 \
#  --learning_rate 5e-05 \
#  --name "VINVL_${size}_id_${random_id}" \
#  --seed $seed \
#  --tag_sep_token True \
#  --model_name_or_path ${oscar_base_model_path} \
#  --output_dir ${output_path}