import argparse
import subprocess
import os

model_name = "gpt-3.5-turbo"
shift_mention = False
encode_decode = "encoder"
table_mention = False
method_mention = True
with open('grouping_evaluation.sh', 'r') as f:
    lines = f.readlines()
if method_mention:
    prompt_hyper_list = ["one-shot with method mention", "few-shot with method mention"]
else:
    prompt_hyper_list = ["zero-shot without method mention", "one-shot without method mention", "few-shot without method mention"]
for prompt_hyper in prompt_hyper_list:
    prompt_hyper = prompt_hyper.replace(' ','_')
    for i in range(len(lines)):
        if 'python main_mapping_inducting.py' in lines[i]:
            lines[i] = f'python main_mapping_inducting.py --prompt_hyper "{prompt_hyper}" --model_name "{model_name}" --shift_mention "{shift_mention}" --encode_decode "{encode_decode}" --table_mention "{table_mention}"\n'

        if '#PJM -N' in lines[i]:
            lines[i] = f'#PJM -N Ex{encode_decode}_{prompt_hyper}_s_{shift_mention}_table_{table_mention}\n'

        if '#PJM -o' in lines[i]:
            lines[i] = f'#PJM -o Ex{encode_decode}_{prompt_hyper}_s_{shift_mention}_table_{table_mention}\n'
        
        if '#PJM -e' in lines[i]:
            lines[i] = f'#PJM -e Ex{encode_decode}_{prompt_hyper}_s_{shift_mention}_table_{table_mention}\n'
    
    with open('grouping_evaluation.sh', 'w') as f:
        f.writelines(lines)

    subprocess.run(['pjsub', 'grouping_evaluation.sh'])
