# import matplotlib.pyplot as plt
#
# # 两个模型的正确率数据
# zero_shot = [27, 43]
# two_shot = [48, 65]
#
# # 设置模型名称和任务名称
# models = ['ChatGPT', 'GPT4']
# tasks = ['Zero-shot', 'Two-shot']
#
# # 设置柱状图的宽度
# bar_width = 0.35
# # 设置自定义颜色
# colors = ['#0077B6', '#00B4D8']
#
# # 设置图表样式
# plt.style.use('ggplot')
#
# # 绘制柱状图
# fig, ax = plt.subplots(figsize=(8, 6))
# index = range(len(models))
#
# rects1 = ax.bar(index, zero_shot, bar_width, label='Zero-shot', color=colors[0])
# rects2 = ax.bar([i + bar_width for i in index], two_shot, bar_width, label='Two-shot', color=colors[1])
#
# # 添加标签和标题
# ax.set_xlabel('Models', fontsize=14, fontweight='bold')
# ax.set_ylabel('Accuracy', fontsize=14, fontweight='bold')
# ax.set_title('Accuracy of Results Validating', fontsize=16, fontweight='bold')
# ax.set_xticks([i + bar_width/2 for i in index])
# ax.set_xticklabels(models, fontsize=12)
# ax.legend(fontsize=12)
#
# # 添加数据标签
# def autolabel(rects):
#     for rect in rects:
#         height = rect.get_height()
#         ax.annotate('{}'.format(height),
#                     xy=(rect.get_x() + rect.get_width() / 2, height),
#                     xytext=(0, 3),
#                     textcoords="offset points",
#                     ha='center', va='bottom', fontsize=12)
#
# autolabel(rects1)
# autolabel(rects2)
#
# # 添加网格线
# ax.grid(axis='y', linestyle='--', alpha=0.5)
#
# # 调整图表边距
# plt.subplots_adjust(top=0.88, bottom=0.15, left=0.12, right=0.95)
#
# # 去除上、右边框
# ax.spines['top'].set_visible(False)
# ax.spines['right'].set_visible(False)
#
# # 显示图形
# plt.tight_layout()
# plt.show()

# from datasets import load_dataset
# dataset = load_dataset('app_reviews')
# dataset.filter(lambda example: len(example["review"])<100 )["train"]["review"][:10]

import random
from utlis import generate_color_preferences

random.seed(314)
def random_sum_partition(n, total):
    # 随机抽样，得到n-1个随机数
    numbers = sorted(random.sample(range(1, total), n - 1))

    # 添加整数的开始和结束
    partition_points = [0] + numbers + [total]

    # 使用这些分区点计算出每个子整数
    return [partition_points[i + 1] - partition_points[i] for i in range(n)]

def generate_examples(priority, num_examples):
    examples = []
    partitioned_selection = random_sum_partition(num_examples, len(priority.keys()))
    for idx in range(num_examples):
        example = []
        color_order = list(priority.keys())
        # Remove one color from the order
        colors = random.sample(color_order, partitioned_selection[idx])
        for color in colors:
            example.append(color)
            color_order.remove(color)
        # Add color to example multiple times with varying frequency
        random_selected = random.choices(color_order, k=random.randint(len(priority.keys())-int(len(priority.keys())/2), len(priority.keys())+int(len(priority.keys())/2)))
        example.extend(random_selected)
        # Sort example by color priority
        example.sort(key=lambda color: priority[color])
        examples.append(example)
    return examples

a={}
colors_priority = {'red': 1, 'green': 2, 'blue': 3, 'yellow': 4, "grey": 5, "bronze": 6, "black": 7, "white": 8}
c = 0
while a!=colors_priority:
    c += 1
    examples = generate_examples(colors_priority, 5)
    # 测试函数
    a, b = generate_color_preferences(examples)

for example in examples:
    print(example)