import importlib

class TaskModelFinetuner:
    def __init__(self, task_name:str, method:str) -> None:
        '''
        params:task_name: str: name of the task
        params:method: str: type of the fine-tuning approach, see subfolders in tasks/task_name
        '''
        pck = importlib.import_module(f"tasks.{task_name}.{method}")
        model_finetuner = getattr(pck, 'ModelFinetuner')
        self.task_name = task_name
        self.method = method
        self.model_finetuner = model_finetuner()
    

def main():
    task_model_finetuner = TaskModelFinetuner(task_name='edit_intent_classification', method='finetuning_llm')

if __name__ == "__main__":
    main()